/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc;

import com.ibm.safe.processors.BaseMethodProcessor;
import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.MethodLocation;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.structural.impl.StructuralMessage;
import com.ibm.safe.utils.ReceiverTypeInference;
import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.cfg.CFGSanitizer;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.CompoundPiPolicy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.InstanceOfPiPolicy;
import com.ibm.wala.ssa.NullTestPiPolicy;
import com.ibm.wala.ssa.SSAPiNodePolicy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class InfiniteRecursionMethodProcessor
extends BaseMethodProcessor {
    private static final int UNKNOWN_LINE_NUMBER = -1;
    private ClassHierarchy classHierarchy;
    private Set<StructuralMessage> result = HashSetFactory.make();
    private StructuralRule rule;

    public InfiniteRecursionMethodProcessor(StructuralRule structuralRule, IClassHierarchy cha) {
        super(cha);
        this.rule = structuralRule;
    }

    @Override
    public void setup(IClass c, Object context) {
        this.classHierarchy = (ClassHierarchy)context;
    }

    @Override
    public void processProlog(IMethod method) {
    }

    @Override
    public void process(IMethod method) {
        if (method.isAbstract() || method.isNative()) {
            return;
        }
        try {
            boolean mayInfiniteRecursion = InfiniteRecursionMethodProcessor.checkMethod(method, this.classHierarchy);
            if (mayInfiniteRecursion) {
                MethodLocation currLocation = Location.createMethodLocation((TypeName)method.getDeclaringClass().getName(), (Selector)method.getSelector(), (int)-1);
                StructuralMessage msg = new StructuralMessage(this.rule, (Location)currLocation);
                this.result.add(msg);
            }
        }
        catch (WalaException walaException) {}
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    public static boolean checkMethod(IMethod m, ClassHierarchy cha) throws WalaException {
        HashSet<CallSiteReference> selfCalls;
        IR ir;
        block11: {
            block10: {
                if (!m.isAbstract()) break block10;
                return false;
            }
            ir = null;
            ReceiverTypeInference rti = null;
            selfCalls = new HashSet<CallSiteReference>(5);
            for (CallSiteReference site : CodeScanner.getCallSites((IMethod)m)) {
                IMethod targetMethod;
                Collection<IMethod> possibleTargets;
                TypeAbstraction t;
                if (!site.getDeclaredTarget().getSelector().equals((Object)m.getSelector())) continue;
                MethodReference target = site.getDeclaredTarget();
                if (site.isSpecial() || site.isStatic()) {
                    IMethod t2;
                    IClass klass = cha.lookupClass(target.getDeclaringClass());
                    if (klass == null || (t2 = cha.resolveMethod(klass, target.getSelector())) == null || !t2.equals(m)) continue;
                    selfCalls.add(site);
                    continue;
                }
                if (ir == null) {
                    ir = InfiniteRecursionMethodProcessor.makeIR(m, cha);
                    rti = InfiniteRecursionMethodProcessor.makeRTI(ir);
                }
                if ((t = rti.getReceiverType(site)) == null || (possibleTargets = InfiniteRecursionMethodProcessor.getPossibleTargets(t, cha, site)).size() != 1 || (targetMethod = possibleTargets.iterator().next()) == null || !targetMethod.equals(m)) continue;
                selfCalls.add(site);
            }
            if (!selfCalls.isEmpty()) break block11;
            return false;
        }
        try {
            if (ir == null) {
                ir = InfiniteRecursionMethodProcessor.makeIR(m, cha);
            }
            Graph G = CFGSanitizer.sanitize(ir, (IClassHierarchy)cha);
            final HashSet recursiveBlocks = HashSetFactory.make();
            for (CallSiteReference site : selfCalls) {
                ISSABasicBlock[] b = ir.getBasicBlocksForCall(site);
                int i = 0;
                while (i < b.length) {
                    recursiveBlocks.add(b[i]);
                    ++i;
                }
            }
            Predicate<IBasicBlock> f = new Predicate<IBasicBlock>(){

                public boolean test(IBasicBlock o) {
                    return !recursiveBlocks.contains(o);
                }
            };
            Collection reachable = DFS.getReachableNodes((Graph)G, Collections.singleton(ir.getControlFlowGraph().entry()), (Predicate)f);
            return !reachable.contains(ir.getControlFlowGraph().exit());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new WalaException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static Collection<IMethod> getPossibleTargets(TypeAbstraction t, ClassHierarchy cha, CallSiteReference site) throws WalaException {
        HashSet result = HashSetFactory.make();
        if (t instanceof ConeType) {
            ConeType cone = (ConeType)t;
            if (cone.getType().isInterface()) {
                Set implementors = cha.getImplementors(cone.getType().getReference());
                for (IClass klass : implementors) {
                    IMethod target = cha.resolveMethod(klass, site.getDeclaredTarget().getSelector());
                    result.add(target);
                }
            } else {
                Collection subTypes = cha.computeSubClasses(t.getType().getReference());
                for (IClass klass : subTypes) {
                    IMethod target = cha.resolveMethod(klass, site.getDeclaredTarget().getSelector());
                    result.add(target);
                }
            }
        } else if (t instanceof PointType) {
            IMethod target = cha.resolveMethod(t.getType(), site.getDeclaredTarget().getSelector());
            result.add(target);
        } else {
            if (t.equals((Object)TypeAbstraction.TOP)) {
                return Collections.emptySet();
            }
            throw new WalaException("internal error: " + t.getClass());
        }
        return result;
    }

    private static ReceiverTypeInference makeRTI(IR ir) throws WalaException {
        TypeInference t = TypeInference.make((IR)ir, (boolean)false);
        return new ReceiverTypeInference(t);
    }

    private static IR makeIR(IMethod m, ClassHierarchy cha) throws WalaException {
        AnalysisOptions options = new AnalysisOptions();
        CompoundPiPolicy policy = CompoundPiPolicy.createCompoundPiPolicy((SSAPiNodePolicy)InstanceOfPiPolicy.createInstanceOfPiPolicy(), (SSAPiNodePolicy)NullTestPiPolicy.createNullTestPiPolicy());
        options.getSSAOptions().setPiNodePolicy((SSAPiNodePolicy)policy);
        IR ir = new AnalysisCacheImpl().getSSACache().findOrCreateIR(m, (Context)Everywhere.EVERYWHERE, options.getSSAOptions());
        return ir;
    }
}

