/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.intraproc;

import com.ibm.safe.intraproc.sccp.SCCPValue;
import com.ibm.safe.processors.BaseInstructionProcessor;
import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.reporting.message.MethodLocation;
import com.ibm.safe.rules.StructuralRule;
import com.ibm.safe.structural.impl.StructuralMessage;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAConditionalBranchInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSASwitchInstruction;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.CancelException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class ConstantConditionInstructionProcessor
extends BaseInstructionProcessor {
    private ConstantConditionVisitor ccv;
    private Map<Integer, SCCPValue> methodConstants;
    private Collection<StructuralMessage> result;
    private final StructuralRule rule;

    public ConstantConditionInstructionProcessor(StructuralRule structuralRule) {
        this.rule = structuralRule;
    }

    @Override
    public void setup(IMethod method, Map<Integer, SCCPValue> context, IR ir) throws CancelException {
        super.setup(method, context, ir);
        this.methodConstants = context;
        this.ccv = new ConstantConditionVisitor(this.methodConstants);
    }

    @Override
    public void processProlog(SSAInstruction inst) {
        this.result = Collections.emptySet();
    }

    @Override
    public void process(SSAInstruction inst, int bcIndex) {
        assert (inst != null) : " cannot process null instruction";
        this.ccv.init();
        inst.visit((SSAInstruction.IVisitor)this.ccv);
        if (this.ccv.hasViolation()) {
            int valNum1 = this.ccv.getViolatingNum1();
            int valNum2 = this.ccv.getViolatingNum2();
            int lineNum = -1;
            lineNum = this.method.getLineNumber(bcIndex);
            String valueString = " with value(s): ";
            String valueNamesString = "names: ";
            if (valNum1 >= 0) {
                String[] val1Names = this.ir.getLocalNames(this.getInstructionIndex(inst), valNum1);
                SCCPValue rhs1val = this.methodConstants.get(valNum1);
                valueString = String.valueOf(valueString) + rhs1val;
                valueNamesString = String.valueOf(valueNamesString) + val1Names;
            }
            if (valNum2 >= 0) {
                String[] val2Names = this.ir.getLocalNames(this.getInstructionIndex(inst), valNum2);
                SCCPValue rhs2val = this.methodConstants.get(valNum2);
                valueString = String.valueOf(valueString) + "," + rhs2val;
                valueNamesString = String.valueOf(valueNamesString) + val2Names;
            }
            MethodLocation currLocation = Location.createMethodLocation((TypeName)this.method.getDeclaringClass().getName(), (Selector)this.method.getSelector(), (int)lineNum, (int)bcIndex);
            StructuralMessage msg = new StructuralMessage(this.rule, (Location)currLocation);
            this.result = Collections.singleton(msg);
        }
    }

    @Override
    public void processEpilog(SSAInstruction inst) {
    }

    @Override
    public Collection<? extends Message> getResult() {
        return this.result;
    }

    public class ConstantConditionVisitor
    extends SSAInstruction.Visitor {
        private Map<Integer, SCCPValue> constantValues;
        private boolean hasViolation;
        private int violatingNum1;
        private int violatingNum2;

        public ConstantConditionVisitor(Map<Integer, SCCPValue> constantValues) {
            this.constantValues = constantValues;
        }

        public boolean hasViolation() {
            return this.hasViolation;
        }

        public int getViolatingNum1() {
            return this.violatingNum1;
        }

        public int getViolatingNum2() {
            return this.violatingNum2;
        }

        public void init() {
            this.hasViolation = false;
            this.violatingNum1 = -1;
            this.violatingNum2 = -1;
        }

        private void validate(int valNum) {
            SCCPValue val = this.constantValues.get(valNum);
            if (val != null && val != SCCPValue.TOP && val != SCCPValue.BOTTOM) {
                this.hasViolation = true;
                this.violatingNum1 = valNum;
            }
        }

        private void validate(int rhs1Num, int rhs2Num) {
            SCCPValue rhs1val = this.constantValues.get(rhs1Num);
            SCCPValue rhs2val = this.constantValues.get(rhs2Num);
            if (rhs1val != null && rhs2val != null && rhs1val != SCCPValue.TOP && rhs2val != SCCPValue.TOP && rhs1val != SCCPValue.BOTTOM && rhs2val != SCCPValue.BOTTOM) {
                this.hasViolation = true;
                this.violatingNum1 = rhs1Num;
                this.violatingNum2 = rhs2Num;
            }
        }

        public void visitConditionalBranch(SSAConditionalBranchInstruction instruction) {
            int numUses = instruction.getNumberOfUses();
            switch (numUses) {
                case 2: {
                    this.validate(instruction.getUse(0), instruction.getUse(1));
                    break;
                }
                case 1: {
                    this.validate(instruction.getUse(0));
                }
            }
        }

        public void visitSwitch(SSASwitchInstruction instruction) {
            this.validate(instruction.getUse(0));
        }
    }
}

