/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public final class SimplifiedFormatter
extends Formatter {
    private static final String ROOT_LOGGER_NAME = "java.util.logging.LogManager$RootLogger";

    @Override
    public String format(LogRecord logRecord) {
        StringBuffer buf = new StringBuffer();
        String lineSeparator = System.getProperty("line.separator");
        if (!ROOT_LOGGER_NAME.equals(logRecord.getSourceClassName())) {
            buf.append("Class: ").append(logRecord.getSourceClassName()).append(", Method: ").append(logRecord.getSourceMethodName());
            buf.append(lineSeparator);
        }
        buf.append(logRecord.getLevel().getLocalizedName());
        buf.append(": ");
        buf.append(this.formatMessage(logRecord));
        buf.append(lineSeparator);
        if (logRecord.getThrown() != null) {
            buf.append(this.getStackStrace(logRecord.getThrown()));
        }
        return buf.toString();
    }

    private String getStackStrace(Throwable exception) {
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return strWriter.toString();
    }
}

