/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.utils;

import com.ibm.safe.utils.SafeEclipseUtils;
import java.io.File;
import java.net.URL;
import org.eclipse.osgi.util.NLS;

public final class SafeHome {
    public static final String URL_RESOLUTION_ERROR = "Unable to resolve URL ";
    private static final String USER_DIR = "user.dir";

    public static String getSafeHomeDir(ClassLoader classLoader, boolean shouldDisplayPropertiesFileLoaded) {
        String envProperty = System.getProperty("SAFE_HOME");
        if (envProperty != null) {
            return envProperty;
        }
        URL url = classLoader.getResource("safe.properties");
        if (url == null) {
            return System.getProperty(USER_DIR);
        }
        String file = SafeEclipseUtils.getFileFromURL(url);
        if (file == null) {
            return System.getProperty(USER_DIR);
        }
        if (shouldDisplayPropertiesFileLoaded) {
            System.out.println(NLS.bind((String)"Loaded properties file ''{0}''.", (Object)file));
        }
        return new File(file).getParentFile().getParentFile().getPath();
    }

    public static String getSafeHomeDir(ClassLoader classLoader) {
        return SafeHome.getSafeHomeDir(classLoader, false);
    }
}

