/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.utils;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.CodeScanner;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.HashMap;

public class ReceiverTypeInference {
    private final TypeInference ti;
    private HashMap<CallSiteReference, SSAInvokeInstruction> invokeMap;

    public ReceiverTypeInference(TypeInference ti) {
        this.ti = ti;
        try {
            this.setupInvokeMap();
        }
        catch (InvalidClassFileException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
    }

    private void setupInvokeMap() throws InvalidClassFileException {
        this.invokeMap = HashMapFactory.make((int)5);
        IR ir = this.ti.getIR();
        IMethod method = ir.getMethod();
        HashMap intMap = HashMapFactory.make((int)5);
        for (CallSiteReference site : CodeScanner.getCallSites((IMethod)method)) {
            int pc = site.getProgramCounter();
            intMap.put(pc, site);
        }
        SSAInstruction[] instructions = ir.getInstructions();
        int i = 0;
        while (i < instructions.length) {
            SSAInstruction s = instructions[i];
            if (s instanceof SSAInvokeInstruction) {
                SSAInvokeInstruction call = (SSAInvokeInstruction)s;
                int pc = call.getProgramCounter();
                CallSiteReference site = (CallSiteReference)intMap.get(new Integer(pc));
                this.invokeMap.put(site, call);
            }
            ++i;
        }
    }

    public TypeAbstraction getReceiverType(CallSiteReference site) {
        SSAInvokeInstruction instruction = this.getInvokeInstruction(site);
        if (instruction == null) {
            return null;
        }
        int def = instruction.getReceiver();
        if (def == -1) {
            return null;
        }
        return this.ti.getType(def);
    }

    private SSAInvokeInstruction getInvokeInstruction(CallSiteReference site) {
        return this.invokeMap.get(site);
    }
}

