/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.utils;

import com.ibm.wala.util.WalaException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaLauncher {
    protected static final String PROGRAM_ARGS_EDEFAULT = "";
    protected String programArgs = "";
    protected static final String MAIN_CLASS_EDEFAULT = "";
    protected String mainClass = "";
    protected List<String> classpathEntries = new ArrayList<String>();
    protected int maxHeap = 800;
    protected static final File WORKING_DIR_EDEFAULT = null;
    protected File workingDir = WORKING_DIR_EDEFAULT;
    protected static final Map<String, String> ENV_EDEFAULT = null;
    protected Map<String, String> env = ENV_EDEFAULT;

    public String getProgramArgs() {
        return this.programArgs;
    }

    public void setProgramArgs(String newProgramArgs) {
        this.programArgs = newProgramArgs;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String newMainClass) {
        this.mainClass = newMainClass;
    }

    public List<String> getClasspathEntries() {
        return this.classpathEntries;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (programArgs: ");
        result.append(this.programArgs);
        result.append(", mainClass: ");
        result.append(this.mainClass);
        result.append(", classpathEntries: ");
        result.append(this.classpathEntries);
        result.append(')');
        return result.toString();
    }

    protected String getJavaExe() {
        String java = String.valueOf(System.getProperty("java.home")) + File.separatorChar + "bin" + File.separatorChar + "java";
        return java;
    }

    public void process() throws WalaException {
        String cp = this.makeClasspath();
        String maxHeapString = " -Xmx" + this.maxHeap + "M ";
        String cmd = String.valueOf(this.getJavaExe()) + maxHeapString + cp + this.getMainClass() + " " + this.getProgramArgs();
        Process p = this.spawnProcess(cmd);
        Thread d1 = this.drainStdOut(p);
        Thread d2 = this.drainStdErr(p);
        try {
            d1.join();
            d2.join();
        }
        catch (InterruptedException e) {
            throw new WalaException("Internal error", (Throwable)e);
        }
    }

    private String makeClasspath() {
        if (this.getClasspathEntries().isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" -classpath ");
        Iterator<String> it = this.getClasspathEntries().iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(File.pathSeparator);
        }
        sb.append(" ");
        return sb.toString();
    }

    protected Process spawnProcess(String cmd) throws WalaException {
        System.out.println("spawning process " + cmd);
        String[] env = this.getEnv() == null ? null : this.buildEnv(this.getEnv());
        try {
            Process p = Runtime.getRuntime().exec(cmd, env, this.getWorkingDir());
            return p;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new WalaException("IOException in " + this.getClass());
        }
    }

    private String[] buildEnv(Map<String, String> env) {
        String[] result = new String[env.size()];
        int i = 0;
        for (Map.Entry<String, String> e : env.entrySet()) {
            result[i++] = String.valueOf(e.getKey()) + "=" + e.getValue();
        }
        return result;
    }

    protected Thread drainStdOut(Process p) {
        final BufferedInputStream output = new BufferedInputStream(p.getInputStream());
        Drainer result = new Drainer(this, p){

            @Override
            void drain() throws IOException {
                this.drainAndPrint(output, System.out);
            }
        };
        result.start();
        return result;
    }

    protected Drainer captureStdOut(Process p) {
        final BufferedInputStream output = new BufferedInputStream(p.getInputStream());
        final ByteArrayOutputStream b = new ByteArrayOutputStream();
        Drainer result = new Drainer(this, p){

            @Override
            void drain() throws IOException {
                this.drainAndCatch(output, b);
            }
        };
        result.setCapture(b);
        result.start();
        return result;
    }

    protected Thread drainStdErr(Process p) {
        final BufferedInputStream err = new BufferedInputStream(p.getErrorStream());
        Drainer result = new Drainer(this, p){

            @Override
            void drain() throws IOException {
                this.drainAndPrint(err, System.err);
            }
        };
        result.start();
        return result;
    }

    private void drainAndPrint(BufferedInputStream s, PrintStream p) throws IOException {
        if (s.available() > 0) {
            byte[] data = new byte[s.available()];
            s.read(data);
            p.print(new String(data));
        }
    }

    private void drainAndCatch(BufferedInputStream s, ByteArrayOutputStream b) throws IOException {
        if (s.available() > 0) {
            byte[] data = new byte[s.available()];
            int nRead = s.read(data);
            b.write(data, 0, nRead);
        }
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File newWorkingDir) {
        this.workingDir = newWorkingDir;
    }

    public void setEnv(Map<String, String> newEnv) {
        this.env = newEnv;
    }

    public void setMaxHeap(int maxHeapSize) {
        this.maxHeap = maxHeapSize;
    }

    abstract class Drainer
    extends Thread {
        private final Process p;
        private ByteArrayOutputStream capture;

        abstract void drain() throws IOException;

        Drainer(Process p) {
            this.p = p;
        }

        @Override
        public void run() {
            try {
                boolean repeat = true;
                while (repeat) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    this.drain();
                    try {
                        this.p.exitValue();
                        repeat = false;
                        this.drain();
                        System.out.println("process terminated with exit code " + this.p.exitValue());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        repeat = true;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public ByteArrayOutputStream getCapture() {
            return this.capture;
        }

        public void setCapture(ByteArrayOutputStream capture) {
            this.capture = capture;
        }
    }
}

