/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.NamedValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RuleLevel
extends NamedValue {
    public static final int METHOD_LEVEL = 0;
    public static final int CLASS_LEVEL = 1;
    public static final int PACKAGE_LEVEL = 2;
    public static final int PROJECT_LEVEL = 3;
    public static final RuleLevel METHOD_LEVEL_LITERAL = new RuleLevel(0, "MethodLevel", "MethodLevel");
    public static final RuleLevel CLASS_LEVEL_LITERAL = new RuleLevel(1, "ClassLevel", "ClassLevel");
    public static final RuleLevel PACKAGE_LEVEL_LITERAL = new RuleLevel(2, "PackageLevel", "PackageLevel");
    public static final RuleLevel PROJECT_LEVEL_LITERAL = new RuleLevel(3, "ProjectLevel", "ProjectLevel");
    private static final RuleLevel[] VALUES_ARRAY = new RuleLevel[]{METHOD_LEVEL_LITERAL, CLASS_LEVEL_LITERAL, PACKAGE_LEVEL_LITERAL, PROJECT_LEVEL_LITERAL};
    public static final List<RuleLevel> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static RuleLevel get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleLevel result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleLevel getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RuleLevel result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RuleLevel get(int value) {
        switch (value) {
            case 0: {
                return METHOD_LEVEL_LITERAL;
            }
            case 1: {
                return CLASS_LEVEL_LITERAL;
            }
            case 2: {
                return PACKAGE_LEVEL_LITERAL;
            }
            case 3: {
                return PROJECT_LEVEL_LITERAL;
            }
        }
        return null;
    }

    private RuleLevel(int value, String name, String literal) {
        super(value, name, literal);
    }
}

