/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.ReportLocation;
import com.ibm.safe.rules.RuleLevel;
import com.ibm.safe.rules.RuleSeverity;
import com.ibm.safe.rules.StructuralRule;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LightweightRuleParser {
    public static StructuralRule parseRule(Node node) {
        StructuralRule r = new StructuralRule();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node curr = children.item(i);
            String nodeName = curr.getNodeName();
            if (nodeName.equals("query")) {
                r.setQuery(LightweightRuleParser.parseQuery(curr));
            } else if (nodeName.equals("reportLocationQuery")) {
                ReportLocation repLocQuery = LightweightRuleParser.parseReportLocationQuery(curr);
                r.setReportLocationQuery(repLocQuery);
            } else if (nodeName.equals("attributes")) {
                NamedNodeMap attr = curr.getAttributes();
                Node name = attr.getNamedItem("name");
                Node severity = attr.getNamedItem("severity");
                Node level = attr.getNamedItem("level");
                if (name != null) {
                    r.setName(name.getNodeValue());
                }
                if (severity != null) {
                    r.setSeverity(RuleSeverity.getByName(severity.getNodeValue()));
                }
                if (level != null) {
                    r.setLevel(RuleLevel.getByName(level.getNodeValue()));
                }
            }
            ++i;
        }
        assert (r.getName() != null);
        return r;
    }

    private static String parseQuery(Node node) {
        NodeList children = node.getChildNodes();
        assert (children.getLength() == 1);
        Node curr = children.item(0);
        String result = curr.getNodeValue();
        return result;
    }

    private static ReportLocation parseReportLocationQuery(Node node) {
        NodeList children = node.getChildNodes();
        assert (children.getLength() == 1);
        Node curr = children.item(0);
        ReportLocation result = ReportLocation.getByName(curr.getNodeValue());
        return result;
    }
}

