/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.RuleLevel;
import com.ibm.safe.rules.RuleSeverity;

public abstract class IRule {
    protected String description;
    protected static final RuleLevel LEVEL_EDEFAULT = RuleLevel.METHOD_LEVEL_LITERAL;
    protected static final RuleSeverity SEVERITY_EDEFAULT = RuleSeverity.INFORMATION_LITERAL;
    protected String example;
    protected RuleLevel level = LEVEL_EDEFAULT;
    protected RuleSeverity severity = SEVERITY_EDEFAULT;
    protected String name;
    protected boolean sureAnalysis;
    protected String action;
    protected String fileName;

    public String getAction() {
        return this.action;
    }

    public void setAction(String newAction) {
        this.action = newAction;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getExample() {
        return this.example;
    }

    public void setExample(String newExample) {
        this.example = newExample;
    }

    public RuleLevel getLevel() {
        return this.level;
    }

    public void setLevel(RuleLevel newLevel) {
        this.level = newLevel == null ? LEVEL_EDEFAULT : newLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public RuleSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(RuleSeverity newSeverity) {
        this.severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
    }

    public boolean isSureAnalysis() {
        return this.sureAnalysis;
    }

    public void setSureAnalysis(boolean newSureAnalysis) {
        this.sureAnalysis = newSureAnalysis;
    }

    public void setFileName(String fn) {
        this.fileName = fn;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IRule)) {
            return false;
        }
        IRule otherRule = (IRule)other;
        return this.getName().equals(otherRule.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(" (action: ");
        result.append(this.action);
        result.append(", description: ");
        result.append(this.description);
        result.append(", example: ");
        result.append(this.example);
        result.append(", level: ");
        result.append(this.level);
        result.append(", name: ");
        result.append(this.name);
        result.append(", severity: ");
        result.append(this.severity);
        result.append(", sureAnalysis: ");
        result.append(this.sureAnalysis);
        result.append(')');
        return result.toString();
    }
}

