/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.rules;

import com.ibm.safe.rules.AbstractRulesReader;
import com.ibm.safe.rules.IRulesReader;
import com.ibm.safe.utils.SafeHome;
import com.ibm.safe.utils.SafeLogger;
import java.io.File;
import java.io.IOException;

public final class CommandLineRulesReader
extends AbstractRulesReader
implements IRulesReader {
    public static final String NO_EXISTING_DIR = "No existing directory to load the rules: ";
    public static final String NO_PROPER_DIRS = "Unable to get access to any valid directory to load SAFE rules.";
    private final String[] rulesDirs;

    public CommandLineRulesReader(String[] rulesDirectories) {
        this.rulesDirs = rulesDirectories;
    }

    @Override
    public void load(ClassLoader classLoader) throws IOException {
        boolean oneExistingDir = false;
        int i = 0;
        while (i < this.rulesDirs.length) {
            File directory = this.getDirectoryFile(classLoader, this.rulesDirs[i]);
            if (directory != null) {
                oneExistingDir = true;
                this.preDirectoryTraversal(directory);
            }
            ++i;
        }
        if (!oneExistingDir) {
            SafeLogger.severe(NO_PROPER_DIRS);
        }
    }

    private File getDirectoryFile(ClassLoader classLoader, String dirName) {
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            dir = new File(SafeHome.getSafeHomeDir(classLoader), dirName);
        }
        if (!dir.exists()) {
            SafeLogger.warning(NO_EXISTING_DIR + dirName);
            return null;
        }
        return dir;
    }
}

