/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.reporting.message;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.MethodLocation;
import org.eclipse.jdt.core.Signature;

public final class SignatureUtils {
    public static final String CLINIT_MSG = "Static initialization part";

    public static String getClassName(Location location) {
        String className = location.getLocationClass();
        return className.substring(1).replaceAll("[/$]", ".");
    }

    public static String getMethodSignature(MethodLocation location, boolean withReturnType) {
        String methodSignature = location.getLocationMethodSignature().replace('/', '.');
        if (methodSignature.length() == 0) {
            return methodSignature;
        }
        int signatureStartIndex = methodSignature.indexOf(40);
        if (signatureStartIndex < 0) {
            return methodSignature;
        }
        String methodName = methodSignature.substring(0, signatureStartIndex);
        if ((methodName = methodName.substring(methodName.lastIndexOf(46) + 1)).equals("<clinit>")) {
            return CLINIT_MSG;
        }
        boolean includeReturnType = withReturnType;
        if (methodName.equals("<init>")) {
            String className = SignatureUtils.getClassName(location);
            methodName = className.substring(className.lastIndexOf(46) + 1);
            includeReturnType = false;
        }
        methodSignature = methodSignature.substring(signatureStartIndex);
        return Signature.toString((String)methodSignature, (String)methodName, null, (boolean)true, (boolean)includeReturnType);
    }
}

