/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.reporting.message;

import com.ibm.safe.reporting.message.Location;
import com.ibm.safe.reporting.message.SignatureUtils;

public class MethodLocation
extends Location {
    private final String className;
    private final String methodName;
    private final int lineNumber;
    private final int bcIndex;

    protected MethodLocation(String className, String methodSelector, int line, int bcIndex) {
        this.className = className;
        this.methodName = methodSelector;
        this.lineNumber = line;
        this.bcIndex = bcIndex;
    }

    protected MethodLocation(String className, String methodSelector, int line) {
        this(className, methodSelector, line, -1);
    }

    protected MethodLocation(String className, String methodSelector) {
        this(className, methodSelector, -1, -1);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof MethodLocation)) {
            return false;
        }
        MethodLocation otherMethodLocation = (MethodLocation)other;
        return this.className.equals(otherMethodLocation.className) && this.methodName.equals(otherMethodLocation.methodName) && this.lineNumber == otherMethodLocation.lineNumber;
    }

    @Override
    public int hashCode() {
        return this.className.hashCode() + this.methodName.hashCode() + this.lineNumber;
    }

    @Override
    public String getByteCodeLocation() {
        return this.methodName;
    }

    @Override
    public String getSourceLocation() {
        return SignatureUtils.getMethodSignature(this, false);
    }

    @Override
    public String getLocationClass() {
        return this.className;
    }

    public String getLocationMethodSignature() {
        return this.methodName;
    }

    @Override
    public Object getAdditionalInformation() {
        return null;
    }

    @Override
    public int getLocationLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getByteCodeIndex() {
        return this.bcIndex;
    }

    @Override
    public boolean isMethodMember() {
        return true;
    }

    @Override
    public boolean isFieldMember() {
        return false;
    }

    public String toString() {
        return "MethodLocation: " + this.className + "." + this.methodName + ":" + this.lineNumber;
    }
}

