/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.properties;

import com.ibm.safe.properties.PropertiesManager;
import com.ibm.wala.util.debug.Assertions;

public class CommonProperties {
    public static void register() {
        PropertiesManager.registerProperties(Props.values());
    }

    public static enum Props implements PropertiesManager.IPropertyDescriptor
    {
        ANALYZE_DEPENDENT_JARS("analyze_dependent_jars", PropertiesManager.Type.BOOLEAN, "Specifies if we should analyze dependent jars in a WAR file."),
        AUTO_SEARCH_IN_DIRS("auto_search_in_dirs", PropertiesManager.Type.STRING, "Specifies a list of directories SAFE will walk through in depth to collect all .class, .jar, .ear, .war and .rar."),
        CLOSE_WORLD("close_world", PropertiesManager.Type.BOOLEAN, "Specifies that we consider EJBs (local or home) as entry points."),
        COLLECT_STATISTICS("collect_statistics", PropertiesManager.Type.BOOLEAN, "Specifies to collect different statistics during analyses."),
        DOMO_REPORT("domo_report", PropertiesManager.Type.STRING, "Specifies that you want to create DOMO trace file (default file name in properties file)."),
        DOT_EXE("dot_exe", PropertiesManager.Type.PATH, "Identifies the path where DOT executable file is installed."),
        GHOSTVIEW_EXE("ghostview_exe", PropertiesManager.Type.PATH, "Identifies the path where ghostview executable file is installed."),
        PDFVIEW_EXE("pdfview_exe", PropertiesManager.Type.PATH, "Identifies the path where PDF viewer file is installed."),
        J2SE_DIR("java_runtime_dir", PropertiesManager.Type.PATH, "Identifies the path where the Java Runtime environment is installed."),
        J2EE("j2ee", PropertiesManager.Type.BOOLEAN, "Should be set to true if we analyze J2EE code."),
        J2EE_DIR("j2ee_runtime_dir", PropertiesManager.Type.PATH, "Identifies the path where the J2EE Runtime environment is installed."),
        MAIN_CLASSES("main_classes", PropertiesManager.Type.STRING, "Specifies a list of main classes to choose as entry poinst for the analysis."),
        MAX_FINDINGS_PER_RULE("max_findings_per_rule", PropertiesManager.Type.INT, 50, "Specifies the maximum number of findings per rule."),
        MINE_DFA("mine_dfa", PropertiesManager.Type.BOOLEAN, ""),
        MODULES("modules", PropertiesManager.Type.STRING, "Identifies the modules to analyze by SAFE."),
        MODULES_DIRS("modules_dirs", PropertiesManager.Type.PATH, "Specifies a list of directories where modules can be loaded (otherwise use current class loader)."),
        NULLDEREF("nullderef", PropertiesManager.Type.BOOLEAN, "Activates or not null-dereference analysis on code transmitted."),
        PERFORMANCE_TRACKING("performance_tracking", PropertiesManager.Type.BOOLEAN, "Specifies that some time and memory tracking for graphs building and analysis should be done."),
        PROJECT("project", PropertiesManager.Type.STRING, "Specifies an Eclipse Java project name to analyze (see 'workspace' option)."),
        RESULT_FILENAME("result_filename", PropertiesManager.Type.STRING, "analysis_results.xml", "Specifies XML file name where to dump analysis result (default file name in properties file)."),
        RULES_DIRS("rules_dirs", PropertiesManager.Type.PATH, "nl/en/rules", "Specifies the root directories where SAFE rules are located."),
        OUTPUT_DIR("output_dir", PropertiesManager.Type.PATH, "results", "Specifies directory where all generated files without absolute path will be located."),
        SHORT_PROGRAM_NAME("short_program_name", PropertiesManager.Type.STRING, ""),
        STRUCTURAL("structural", PropertiesManager.Type.BOOLEAN, "Activates or not structural analysis on code transmitted."),
        TIMEOUT_SECS("timeout_secs", PropertiesManager.Type.INT, 60, "Specifies a time after which current typestate solver is cancelled if analysis produces nothing."),
        TYPESTATE("typestate", PropertiesManager.Type.BOOLEAN, "Activates or not typestate analysis on code transmitted."),
        VERBOSE("verbose", PropertiesManager.Type.BOOLEAN, "Specifies verbose mode for SAFE analysis."),
        WORKSPACE("workspace", PropertiesManager.Type.PATH, "Specifies the workspace directory where we could find Eclipse Java projects."),
        NO_EXCLUSIONS("no_exclusions", PropertiesManager.Type.BOOLEAN, false, "avoid SAFE exclusions."),
        EXCLUSION_FILE("exclusion_file", PropertiesManager.Type.STRING, null, "specific exclusion file");

        private final String name;
        private final boolean cmdLine;
        private final PropertiesManager.Type type;
        private final String defaultString;
        private final String description;

        private Props(String name, PropertiesManager.Type type, String defaultString, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.defaultString = defaultString;
            this.description = description;
        }

        private Props(String name, PropertiesManager.Type type, int defaultInt, String description) {
            this(name, type, String.valueOf(defaultInt), description);
        }

        private Props(String name, PropertiesManager.Type type, boolean defaultInt, String description) {
            this(name, type, String.valueOf(defaultInt), description);
        }

        private Props(String name, PropertiesManager.Type type, String description) {
            this.name = name;
            this.type = type;
            this.cmdLine = true;
            this.description = description;
            switch (type) {
                case BOOLEAN: {
                    this.defaultString = "false";
                    break;
                }
                case STRING: 
                case INT: 
                case PATH: {
                    this.defaultString = null;
                    break;
                }
                default: {
                    Assertions.UNREACHABLE();
                    this.defaultString = null;
                }
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isCommandLineOption() {
            return this.cmdLine;
        }

        @Override
        public PropertiesManager.Type getType() {
            return this.type;
        }

        @Override
        public String getDefaultAsString() {
            return this.defaultString;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

