/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.perf;

import com.ibm.safe.perf.NamedTimer;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.perf.Stopwatch;
import java.util.Map;

public class PerformanceTracker {
    protected final Map<String, NamedTimer> timers = HashMapFactory.make();
    private final String name;
    private final Kind kind;

    public PerformanceTracker(String trackerName, Kind trackerKind) {
        this.name = trackerName;
        this.kind = trackerKind;
    }

    public final NamedTimer[] getTimers() {
        return this.timers.values().toArray(new NamedTimer[this.timers.size()]);
    }

    public final Kind getTrackerKind() {
        return this.kind;
    }

    public final String getTrackerName() {
        return this.name;
    }

    public final void startTracking(String timerName) {
        assert (!this.timers.containsKey(timerName));
        NamedTimer timer = this.createTimerInstance(timerName);
        this.timers.put(timerName, timer);
        timer.start();
    }

    public final void stopTracking(String timerName) {
        NamedTimer timer = this.timers.get(timerName);
        assert (timer != null);
        timer.stop();
    }

    public final Stopwatch getTimer(String timerName) {
        return this.timers.get(timerName);
    }

    protected NamedTimer createTimerInstance(String timerName) {
        return new NamedTimer(timerName);
    }

    public String reportPerformanceTracking() {
        StringBuffer result = new StringBuffer();
        NamedTimer[] timers = this.getTimers();
        if (timers.length == 0) {
            return result.toString();
        }
        result.append("\n");
        result.append(this.getTrackerName());
        int totalTime = 0;
        int i = 0;
        while (i < timers.length) {
            NamedTimer current = timers[i];
            totalTime = (int)((long)totalTime + current.getElapsedMillis());
            result.append(String.valueOf(current.getName()) + " \t Time = " + current.getElapsedMillis() + " ms \n");
            ++i;
        }
        result.append("Total time: " + totalTime + " ms");
        return result.toString();
    }

    public static enum Kind {
        GLOBAL,
        SOLVERS;

    }

    public static enum Stages {
        CHA,
        CALLGRAPH,
        HEAPGRAPH,
        CALLGRAPH_REACH,
        STRUCTURAL,
        NULLDEREF,
        TYPESTATE;

    }
}

