/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.runners;

import com.ibm.safe.controller.ISafeSolver;
import com.ibm.safe.internal.exceptions.MaxFindingsException;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.exceptions.SolverTimeoutException;
import com.ibm.safe.internal.runners.SafeTimeoutTask;
import com.ibm.safe.options.CommonOptions;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.perf.SolverPerfTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.ISolverResult;
import com.ibm.safe.runners.IResultObserver;
import com.ibm.safe.runners.ISolverRunner;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractSolverRunner
implements ISolverRunner {
    protected final PropertiesManager propertiesManager;
    private final PerformanceTracker perfoTracker;
    private final IReporter reporter;

    protected AbstractSolverRunner(PropertiesManager thePropertiesManager, PerformanceTracker performanceTracker, IReporter safeReporter) {
        this.propertiesManager = thePropertiesManager;
        this.perfoTracker = performanceTracker;
        this.reporter = safeReporter;
    }

    protected final CommonOptions getCommonOptions() throws PropertiesException {
        return new CommonOptions(this.propertiesManager);
    }

    private int getTimeoutSecs() throws PropertiesException {
        return this.getManager().getIntValue(CommonProperties.Props.TIMEOUT_SECS);
    }

    protected PropertiesManager getManager() {
        return this.propertiesManager;
    }

    protected final IReporter getReporter() {
        return this.reporter;
    }

    protected final CodeKind getModulesCodeKind(CommonOptions commonOptions) throws PropertiesException, IOException, CoreException {
        if (this.propertiesManager.getBooleanValue(CommonProperties.Props.J2EE)) {
            return CodeKind.J2EE;
        }
        CodeKind codeKind = null;
        codeKind = CodeKind.J2SE;
        return codeKind;
    }

    protected final PerformanceTracker getPerformanceTracker() {
        return this.perfoTracker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void runSolvers(ISafeSolver[] solvers, IResultObserver observer, AnalysisKind analysisNature, PerformanceTracker.Stages timerName, IProgressMonitor monitor) throws PropertiesException, SetUpException, CancelException {
        this.getReporter().startAnalysis(analysisNature);
        this.startTracking(timerName.toString());
        SolverPerfTracker solverPerfoTracker = this.perfoTracker == null || solvers.length == 1 ? null : new SolverPerfTracker("Solvers tracking report\n", PerformanceTracker.Kind.SOLVERS);
        TimerTask timeout = null;
        Timer timeoutTimer = null;
        try {
            monitor.beginTask(null, solvers.length);
            int i = 0;
            while (i < solvers.length) {
                block21: {
                    block20: {
                        if (this.getTimeoutSecs() > 0) {
                            if (Thread.interrupted()) {
                                Trace.print("*** Interrupt Carried Over ***");
                            }
                            timeoutTimer = new Timer(true);
                            timeout = new SafeTimeoutTask(Thread.currentThread());
                            long timeoutMillis = 1000 * this.getTimeoutSecs();
                            timeoutTimer.schedule(timeout, timeoutMillis);
                        }
                        if (!monitor.isCanceled()) break block20;
                        if (timeout == null) return;
                        timeout.cancel();
                        return;
                    }
                    try {
                        this.runSolver(solvers[i], solverPerfoTracker, observer, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (WalaException exception) {
                        SafeLogger.severe("Error occured during SAFE solver running.", exception);
                        if (timeout != null) {
                            timeout.cancel();
                        }
                        break block21;
                    }
                    catch (SolverTimeoutException exception) {
                        try {
                            if (solverPerfoTracker != null) {
                                solverPerfoTracker.timeout(solvers[i].toString(), exception.getResult());
                            }
                            observer.notify(exception.getResult(), AnalysisStatus.ABORT_TIMEOUT);
                            SafeLogger.warning("SAFE Solver timed out.");
                            break block21;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (timeout != null) {
                                timeout.cancel();
                            }
                        }
                    }
                    if (timeout == null) break block21;
                    timeout.cancel();
                }
                ++i;
            }
            return;
        }
        finally {
            monitor.done();
            this.stopTracking(timerName.toString());
            if (timeout != null) {
                timeout.cancel();
            }
            if (timeoutTimer != null) {
                timeoutTimer.cancel();
            }
            this.getReporter().stopAnalysis(analysisNature);
            if (solverPerfoTracker != null) {
                this.getReporter().reportPerformanceTracking(solverPerfoTracker);
            }
        }
    }

    protected final boolean shouldCollectStatistics() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.COLLECT_STATISTICS);
    }

    protected final boolean shouldMineDFA() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.MINE_DFA);
    }

    private void runSolver(ISafeSolver solver, SolverPerfTracker solverPerfoTracker, IResultObserver observer, IProgressMonitor monitor) throws WalaException, SolverTimeoutException, PropertiesException, SetUpException, CancelException {
        Assertions.productionAssertion((solver != null ? 1 : 0) != 0);
        if (solverPerfoTracker != null) {
            solverPerfoTracker.startTracking(solver.toString());
        }
        ISolverResult results = null;
        try {
            try {
                results = solver.perform(monitor);
                if (results != null) {
                    observer.notify(results, AnalysisStatus.NORMAL);
                }
            }
            catch (MaxFindingsException e) {
                observer.notify(e.getResult(), AnalysisStatus.ABORT_MAX_FIND);
                if (solverPerfoTracker != null) {
                    solverPerfoTracker.stopTracking(solver.toString(), results);
                }
            }
        }
        finally {
            if (solverPerfoTracker != null) {
                solverPerfoTracker.stopTracking(solver.toString(), results);
            }
        }
    }

    private void startTracking(String timerName) {
        if (this.perfoTracker != null) {
            this.perfoTracker.startTracking(timerName);
        }
    }

    private void stopTracking(String timerName) {
        if (this.perfoTracker != null) {
            this.perfoTracker.stopTracking(timerName);
        }
    }

    public static enum AnalysisKind {
        STRUCTURAL,
        NULLDEREF,
        TYPESTATE,
        SYMBOLIC;

    }

    public static enum AnalysisStatus {
        INCOMPLETE,
        NORMAL,
        ABORT_TIMEOUT,
        ABORT_MAX_FIND;

    }

    public static enum CodeKind {
        J2SE,
        J2EE,
        J2SE_J2EE_MIX;

    }
}

