/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.reporting;

import com.ibm.safe.internal.runners.AbstractSolverRunner;
import com.ibm.safe.metrics.ClassStatistics;
import com.ibm.safe.metrics.IMetrics;
import com.ibm.safe.metrics.ProgramStatistics;
import com.ibm.safe.perf.NamedTimer;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.reporting.message.Message;
import com.ibm.safe.reporting.message.SignatureUtils;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.TypestateRule;
import com.ibm.wala.classLoader.IClass;
import java.io.PrintWriter;
import java.io.StringWriter;

abstract class AbstractBasicOutputReporter
implements IReporter {
    private static final String EMPTY_STRING = "";

    AbstractBasicOutputReporter() {
    }

    protected abstract void errorWrite(String var1);

    protected abstract void write(String var1);

    @Override
    public final void process(IClass clazz) {
        this.write("Processing class " + this.getClassName(clazz));
    }

    @Override
    public final void reportException(Throwable exception) {
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        this.errorWrite(strWriter.toString());
    }

    @Override
    public final void reportMessage(Message message) {
        StringBuilder msgBuilder = new StringBuilder("    - ");
        if (message.getRule() != null) {
            msgBuilder.append(message.getRule().getSeverity().toString()).append(": ");
        }
        msgBuilder.append(message.getText()).append(" (").append(SignatureUtils.getClassName(message.getLocation()));
        if (message.getLocation().getByteCodeLocation().startsWith("<init>")) {
            int parenIndex = message.getLocation().getSourceLocation().indexOf(40);
            msgBuilder.append(message.getLocation().getSourceLocation().substring(parenIndex));
        } else {
            msgBuilder.append('.').append(message.getLocation().getSourceLocation());
        }
        if (message.getLocation().getLocationLineNumber() != -1) {
            msgBuilder.append(':').append(message.getLocation().getLocationLineNumber());
        }
        if (message.getLocation().getByteCodeIndex() != -1) {
            msgBuilder.append(";bci:").append(message.getLocation().getByteCodeIndex());
        }
        msgBuilder.append(')');
        this.write(msgBuilder.toString());
    }

    @Override
    public final void reportAnalysisStatus(AbstractSolverRunner.AnalysisStatus status) {
        if (status == AbstractSolverRunner.AnalysisStatus.NORMAL) {
            this.write("All analyses terminated normally");
        } else {
            this.write("Done. Some analyses terminated with status: " + (Object)((Object)status));
        }
    }

    @Override
    public final void reportNumberOfFindings(int numberOfFindings) {
        this.write("Done with " + numberOfFindings + " finding(s).");
    }

    @Override
    public final void reportNumberOfRulesActivated(int numberOfRules) {
        this.write(String.valueOf(numberOfRules) + " rule(s) activated.");
    }

    @Override
    public final void reportRuleLoading(IRule rule) {
        this.write("Rule " + rule.getName() + " loaded");
    }

    @Override
    public final void reportRuleInstances(IRule rule, int instances) {
        if (!(rule instanceof TypestateRule)) {
            return;
        }
        this.write("TypeState rule " + rule.getName() + " has " + instances + " instances.");
    }

    @Override
    public final void reportPerformanceTracking(PerformanceTracker perfoTracker) {
        NamedTimer[] timers = perfoTracker.getTimers();
        if (timers.length == 0) {
            return;
        }
        this.write(EMPTY_STRING);
        this.write(perfoTracker.getTrackerName());
        TotalResultsWrapper totalResultsWrapper = new TotalResultsWrapper();
        int i = 0;
        while (i < timers.length) {
            this.writePerformanceResult(timers[i], totalResultsWrapper);
            ++i;
        }
        this.write("Total time: " + totalResultsWrapper.totalTime + " ms");
    }

    @Override
    public final void reportStatistics(ProgramStatistics programStat) {
        this.write(EMPTY_STRING);
        this.write("Structural Statistics:\n");
        this.write("Number of classes\t\t: " + programStat.getEntry(0));
        this.write("Number of interfaces\t\t: " + programStat.getEntry(1));
        this.write("Number of abstract classes\t\t: " + programStat.getEntry(2));
        long numberOfInstanceFields = 0L;
        long numberOfFinalInstanceFields = 0L;
        long numberOfStaticFields = 0L;
        long numberOfFinalStaticFields = 0L;
        long numberOfMethods = 0L;
        long numberOfSynchronizedMethods = 0L;
        long numberOfStaticMethods = 0L;
        long numberOfByteCodeLocs = 0L;
        for (ClassStatistics classStats : programStat.classStats.values()) {
            numberOfInstanceFields += (long)classStats.numberOfInstanceFields;
            numberOfFinalInstanceFields += (long)classStats.numberOfFinalInstanceFields;
            numberOfStaticFields += (long)classStats.numberOfStaticFields;
            numberOfFinalStaticFields += (long)classStats.numberOfFinalStaticFields;
            numberOfMethods += (long)classStats.numberOfMethods;
            numberOfSynchronizedMethods += (long)classStats.numberOfSynchronizedMethods;
            numberOfStaticMethods += (long)classStats.numberOfStaticMethods;
            numberOfByteCodeLocs += classStats.numberOfByteCodeLocs;
        }
        this.write("Number of Instance Fields: " + numberOfInstanceFields);
        this.write("Number of Final Instance Fields: " + numberOfFinalInstanceFields);
        this.write("Number of Static Fields: " + numberOfStaticFields);
        this.write("Number of Final Static Fields: " + numberOfFinalStaticFields);
        this.write("Number of Methods: " + numberOfMethods);
        this.write("Number of Synchronized Methods: " + numberOfSynchronizedMethods);
        this.write("Number of Static Methods: " + numberOfStaticMethods);
        this.write("Number of ByteCode Locs Fields: " + numberOfByteCodeLocs);
    }

    @Override
    public void reportStatistics(IMetrics metrics) {
    }

    @Override
    public final void startAnalysis(AbstractSolverRunner.AnalysisKind nature) {
        this.write(EMPTY_STRING);
        this.write("***** " + (Object)((Object)nature) + " Analysis *****");
    }

    @Override
    public final void stopAnalysis(AbstractSolverRunner.AnalysisKind nature) {
        this.write(EMPTY_STRING);
    }

    @Override
    public final void version(String versionNumber) {
        this.write(EMPTY_STRING);
        this.write("Version: " + versionNumber);
    }

    private String getClassName(IClass currentClass) {
        return currentClass.getName().toString().substring(1).replace('/', '.');
    }

    private void writePerformanceResult(NamedTimer timer, TotalResultsWrapper totalResultsWrapper) {
        TotalResultsWrapper totalResultsWrapper2 = totalResultsWrapper;
        totalResultsWrapper2.totalTime = totalResultsWrapper2.totalTime + timer.getElapsedMillis();
        this.write(String.valueOf(timer.getName()) + " \t Time = " + timer.getElapsedMillis() + " ms");
    }

    private static class TotalResultsWrapper {
        private long totalTime = 0L;

        private TotalResultsWrapper() {
        }
    }
}

