/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.internal.entrypoints;

import com.ibm.safe.internal.entrypoints.EntryPointDefinition;
import com.ibm.safe.internal.entrypoints.IEntryPointsReader;
import com.ibm.safe.internal.exceptions.SetUpException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jdt.core.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class XMLEntryPointsReader
implements IEntryPointsReader {
    private final Collection<EntryPointDefinition> entryPoints = new ArrayList<EntryPointDefinition>(10);
    private final Collection<String> parametersTypes = new ArrayList<String>(10);
    private String returnType;
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String XML_SCHEMA_FILENAME = "entrypoints_schema.xsd";
    private static final String CLASS_NAME_TAG = "class-name";
    private static final String METHOD_NAME_TAG = "method-name";
    private static final String PARAMETERS_TYPE_TAG = "parameters-type";
    private static final String RETURN_TYPE_TAG = "return-type";

    public XMLEntryPointsReader(File xmlFile) throws ParserConfigurationException, SAXException, Exception, SetUpException {
        this.collectEntryPoints(this.createDocument(xmlFile));
    }

    @Override
    public EntryPointDefinition[] getEntryPointDefinitions() {
        return this.entryPoints.toArray(new EntryPointDefinition[this.entryPoints.size()]);
    }

    private EntryPointDefinition collectEntryPoint(Node entryPointNode) {
        NodeList childNodes = entryPointNode.getChildNodes();
        EntryPointDefinition entryPointDef = new EntryPointDefinition();
        int i = childNodes.getLength();
        while (--i >= 0) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.collectEntryPointElement(entryPointDef, childNode);
        }
        if (entryPointDef.getMethodName() == null) {
            entryPointDef.setMethodName("main");
            entryPointDef.setMethodDescriptor("([Ljava/lang/String;)V");
        } else {
            entryPointDef.setMethodDescriptor(this.createMethodDescriptor());
        }
        return entryPointDef;
    }

    private void collectEntryPointElement(EntryPointDefinition entryPointDef, Node entryPointElement) {
        if (CLASS_NAME_TAG.equals(entryPointElement.getNodeName())) {
            entryPointDef.setClassName(entryPointElement.getFirstChild().getNodeValue().trim());
        } else if (METHOD_NAME_TAG.equals(entryPointElement.getNodeName())) {
            entryPointDef.setMethodName(entryPointElement.getFirstChild().getNodeValue().trim());
        } else if (PARAMETERS_TYPE_TAG.equals(entryPointElement.getNodeName())) {
            NodeList childNodes = entryPointElement.getChildNodes();
            int i = 0;
            int size = childNodes.getLength();
            while (i < size) {
                String value;
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 1 && (value = childNode.getFirstChild().getNodeValue().trim()).length() > 0) {
                    this.parametersTypes.add(Signature.createTypeSignature((String)value, (boolean)true));
                }
                ++i;
            }
        } else if (RETURN_TYPE_TAG.equals(entryPointElement.getNodeName())) {
            this.returnType = Signature.createTypeSignature((String)entryPointElement.getFirstChild().getNodeValue().trim(), (boolean)true);
        }
    }

    private void collectEntryPoints(Document xmlDocument) {
        Element root = xmlDocument.getDocumentElement();
        NodeList childNodes = root.getChildNodes();
        int i = childNodes.getLength();
        while (--i >= 0) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() != 1) continue;
            this.entryPoints.add(this.collectEntryPoint(childNode));
        }
    }

    private Document createDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException, SetUpException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        factory.setAttribute(JAXP_SCHEMA_SOURCE, this.getXMLSchemaFile());
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new BasicHandler());
        return builder.parse(xmlFile);
    }

    private String createMethodDescriptor() {
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        Iterator<String> iter = this.parametersTypes.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next().replace('.', '/'));
        }
        buf.append(')');
        if (this.returnType == null) {
            buf.append('V');
        } else {
            buf.append(this.returnType);
        }
        return buf.toString();
    }

    private File getXMLSchemaFile() throws SetUpException {
        URL url = this.getClass().getClassLoader().getResource(XML_SCHEMA_FILENAME);
        if (url == null) {
            throw new SetUpException("Unable to find XML schema named entrypoints_schema.xsd");
        }
        return new File(url.getFile());
    }

    private static class BasicHandler
    extends DefaultHandler {
        private BasicHandler() {
        }

        @Override
        public void error(SAXParseException except) throws SAXException {
            throw except;
        }
    }
}

