/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.dfa;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.safe.dfa.IDFAStateMerger;
import com.ibm.safe.dfa.IdentityStateFactory;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IndiscriminateFilter;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class DFAStateMerger
implements IDFAStateMerger {
    private static final String ERR_STATE = "err";

    @Override
    public abstract Set<Pair<Object, Object>> computeEquivalence(IDFA var1, Collection<Object> var2, Set<Object> var3);

    protected IDFA mergeStates(IDFA dfa) {
        return this.mergeStates(dfa, dfa.acceptingStates());
    }

    @Override
    public IDFA mergeStates(IDFA dfa, Set<Object> cut) {
        return this.mergeStates(dfa, cut, IdentityStateFactory.getInstance());
    }

    protected IDFA mergeStates(IDFA dfa, Set<Object> cut, IDFAStateFactory stateFactory) {
        HashMap partitionMap = HashMapFactory.make();
        HashSet partition = HashSetFactory.make();
        HashSet accepting = HashSetFactory.make();
        Collection reachable = DFS.getReachableNodes((Graph)dfa, Collections.singleton(dfa.getInitialState()), (Predicate)IndiscriminateFilter.singleton());
        Set<Pair<Object, Object>> equivalence = this.computeEquivalence(dfa, reachable, cut);
        HashSet ignoreSet = HashSetFactory.make();
        for (Object src : reachable) {
            if (ignoreSet.contains(src)) continue;
            HashSet nodeSet = HashSetFactory.make();
            nodeSet.add(src);
            partitionMap.put(src, nodeSet);
            boolean acceptFlag = false;
            if (dfa.isAccepting(src)) {
                acceptFlag = true;
            }
            for (Object dest : reachable) {
                if (!equivalence.contains(Pair.make(src, dest))) continue;
                nodeSet.add(dest);
                ignoreSet.add(dest);
                partitionMap.put(dest, nodeSet);
                if (!dfa.isAccepting(dest)) continue;
                acceptFlag = true;
            }
            partition.add(nodeSet);
            if (!acceptFlag) continue;
            accepting.add(nodeSet);
        }
        return this.constructNewDfA(dfa, partitionMap, partition, accepting, stateFactory);
    }

    protected IDFA constructNewDfA(IDFA dfa, Map<Object, Set<Object>> partitionMap, Set<Set<Object>> partition, Set<Set<Object>> accepting, IDFAStateFactory stateFactory) {
        Object newState;
        HashMap classes2states = HashMapFactory.make();
        Set<Object> initialClass = partitionMap.get(dfa.getInitialState());
        Object newInitState = stateFactory.createState(initialClass);
        classes2states.put(initialClass, newInitState);
        DFA result = new DFA(newInitState);
        for (Set<Object> stateClass : partition) {
            if (stateClass == initialClass) continue;
            newState = stateFactory.createState(stateClass);
            result.addNode(newState, accepting.contains(stateClass));
            classes2states.put(stateClass, newState);
        }
        for (Set<Object> stateClass : partition) {
            newState = classes2states.get(stateClass);
            for (Object state : stateClass) {
                for (Object label : dfa.alphabet()) {
                    Object successor = dfa.successor(state, label);
                    if (successor == null) continue;
                    Set<Object> succStateClass = partitionMap.get(successor);
                    Object succNewState = classes2states.get(succStateClass);
                    result.addLabeledEdge(newState, succNewState, label);
                }
            }
        }
        return result;
    }

    public IDFA completeDFA(IDFA dfa) {
        IDFA result = (IDFA)dfa.clone();
        if (result.acceptingStates().isEmpty()) {
            result.addNode(ERR_STATE, true);
        }
        Iterator nodeIt = result.iterator();
        while (nodeIt.hasNext()) {
            Object src = nodeIt.next();
            for (Object label : result.alphabet()) {
                if (result.successor(src, label) != null) continue;
                result.addLabeledEdge(src, ERR_STATE, label);
            }
        }
        return result;
    }

    public void inPlaceCompleteDFA(IDFA dfa) {
        if (dfa.acceptingStates().isEmpty()) {
            dfa.addNode(ERR_STATE, true);
        }
        Iterator nodeIt = dfa.iterator();
        while (nodeIt.hasNext()) {
            Object src = nodeIt.next();
            for (Object label : dfa.alphabet()) {
                if (dfa.successor(src, label) != null) continue;
                dfa.addLabeledEdge(src, ERR_STATE, label);
            }
        }
    }
}

