/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.dfa;

import com.ibm.safe.dfa.DFA;
import com.ibm.safe.dfa.DFAStateMerger;
import com.ibm.safe.dfa.IDFA;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DFAMinimizer
extends DFAStateMerger {
    private static final int DEBUG_LEVEL = 0;
    private static DFAMinimizer theInstance;

    public static DFAMinimizer getInstance() {
        if (theInstance == null) {
            theInstance = new DFAMinimizer();
        }
        return theInstance;
    }

    private DFAMinimizer() {
    }

    public IDFA minimize(IDFA dfa) {
        return this.mergeStates(dfa);
    }

    @Override
    public Set<Pair<Object, Object>> computeEquivalence(IDFA dfa, Collection<Object> reachable, Set<Object> cut) {
        HashSet unmarked = HashSetFactory.make();
        HashSet marked = HashSetFactory.make();
        assert (!cut.isEmpty()) : "cannot minimize automaton with empty cut";
        for (Object src : reachable) {
            for (Object dst : reachable) {
                if (src.equals(dst)) continue;
                Pair pair = Pair.make((Object)src, (Object)dst);
                if (cut.contains(src) && !cut.contains(dst) || !cut.contains(src) && cut.contains(dst)) {
                    marked.add(pair);
                    continue;
                }
                unmarked.add(pair);
            }
        }
        boolean changed = false;
        do {
            changed = false;
            for (Pair pair : unmarked) {
                for (Object label : dfa.alphabet()) {
                    Pair nextPair;
                    Object nextSrc = dfa.successor(pair.fst, label);
                    Object nextDest = dfa.successor(pair.snd, label);
                    if (nextSrc == null || nextDest == null || !marked.contains(nextPair = Pair.make((Object)nextSrc, (Object)nextDest))) continue;
                    marked.add(pair);
                    changed = true;
                }
            }
            unmarked.removeAll(marked);
        } while (changed);
        return unmarked;
    }

    public IDFA removeAccepting(IDFA dfa) {
        DFA res = new DFA(dfa.getInitialState());
        Iterator it = dfa.iterator();
        while (it.hasNext()) {
            Object node = it.next();
            if (dfa.isAccepting(node)) continue;
            res.addNode(node);
        }
        it = dfa.iterator();
        while (it.hasNext()) {
            Object x = it.next();
            if (dfa.isAccepting(x)) continue;
            Iterator s = dfa.getSuccNodes(x);
            while (s.hasNext()) {
                Object y = s.next();
                if (dfa.isAccepting(y)) continue;
                res.addLabeledEdges(x, y, dfa.getLabels(x, y));
            }
        }
        return res;
    }
}

