/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.dfa;

import com.ibm.safe.dfa.DFAStateMerger;
import com.ibm.safe.dfa.IDFA;
import com.ibm.safe.dfa.IDFAStateFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class DFAFlattening
extends DFAStateMerger {
    private static DFAFlattening theInstance;

    public static DFAFlattening getInstance() {
        if (theInstance == null) {
            theInstance = new DFAFlattening();
        }
        return theInstance;
    }

    private DFAFlattening() {
    }

    public IDFA flatten(IDFA dfa, Set<Object> cut) {
        return this.mergeStates(dfa, cut);
    }

    public IDFA flatten(IDFA dfa, Set<Object> cut, IDFAStateFactory stateFactory) {
        return this.mergeStates(dfa, cut, stateFactory);
    }

    @Override
    public Set<Pair<Object, Object>> computeEquivalence(IDFA dfa, Collection<Object> reachable, Set<Object> toMerge) {
        IntegerUnionFind equivUF = new IntegerUnionFind();
        MutableMapping states = MutableMapping.make();
        boolean first = true;
        int mergeRep = 0;
        for (Object state : reachable) {
            int i = states.add(state);
            if (!toMerge.contains(state)) continue;
            if (first) {
                first = false;
                mergeRep = i;
                continue;
            }
            equivUF.union(mergeRep, i);
        }
        boolean changedUF = false;
        do {
            changedUF = false;
            for (Object state1 : reachable) {
                for (Object state2 : reachable) {
                    if (state1 == state2 || equivUF.find(states.getMappedIndex(state1)) != equivUF.find(states.getMappedIndex(state2))) continue;
                    for (Object label : dfa.alphabet()) {
                        int class2;
                        int class1;
                        Object nextDest1 = dfa.successor(state1, label);
                        Object nextDest2 = dfa.successor(state2, label);
                        if (nextDest1 == null || nextDest2 == null || (class1 = equivUF.find(states.getMappedIndex(nextDest1))) == (class2 = equivUF.find(states.getMappedIndex(nextDest2)))) continue;
                        equivUF.union(class1, class2);
                        changedUF = true;
                    }
                }
            }
        } while (changedUF);
        HashSet equivPairs = HashSetFactory.make();
        for (Object state1 : reachable) {
            for (Object state2 : reachable) {
                if (state1 == state2 || equivUF.find(states.getMappedIndex(state1)) != equivUF.find(states.getMappedIndex(state2))) continue;
                equivPairs.add(Pair.make((Object)state1, (Object)state2));
            }
        }
        return equivPairs;
    }
}

