/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.controller.AbstractSafeController;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.reporting.ReporterFactory;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.utils.SafeLogger;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public abstract class AbstractSafeJavaApplication {
    protected static final String LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    protected static final String SAFE_LOG_FILE = "safelog.properties";

    protected abstract void displaySpecificLauncherOptions();

    protected void run(String[] args) {
        if (this.requiresHelp(args)) {
            this.displayUsage();
        }
        this.initLoggerProperty();
        try {
            PropertiesManager propertiesManager = PropertiesManager.initFromCommandLine(args);
            AbstractSafeController runner = this.createController(propertiesManager);
            IRule[] rules = runner.getRules();
            String analysisResultFile = String.valueOf(propertiesManager.getPathValue(CommonProperties.Props.OUTPUT_DIR)) + File.separator + propertiesManager.getStringValue(CommonProperties.Props.RESULT_FILENAME);
            runner.execute(rules, ReporterFactory.createDefaultReporter(analysisResultFile), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (SafeException except) {
            SafeLogger.severe(except.getMessage());
            System.err.println(except.getMessage());
            if (except.getCause() != null) {
                SafeLogger.severe(except.getCause().getMessage());
            }
            System.exit(-1);
        }
        catch (Exception except) {
            SafeLogger.severe(this.getStackStrace(except));
            except.printStackTrace();
            if (except.getCause() != null) {
                SafeLogger.severe(this.getStackStrace(except.getCause()));
            }
            System.exit(-1);
        }
    }

    protected String getStackStrace(Throwable exception) {
        StringWriter strWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(strWriter);
        exception.printStackTrace(printWriter);
        printWriter.close();
        return strWriter.toString();
    }

    protected void initLoggerProperty() {
        String loggingConfigFile = System.getProperty(LOGGING_CONFIG_FILE);
        if (loggingConfigFile == null) {
            URL resource = AbstractSafeJavaApplication.class.getClassLoader().getResource(SAFE_LOG_FILE);
            assert (resource != null);
            System.setProperty(LOGGING_CONFIG_FILE, resource.getFile());
        }
    }

    protected boolean requiresHelp(String[] javaAppArguments) {
        return javaAppArguments.length == 0 || javaAppArguments.length == 1 && (javaAppArguments[0].equals("-h") || javaAppArguments[0].equals("--help") || javaAppArguments[0].equals("/?"));
    }

    protected final void displayUsage(String optionsGroupingName, PropertiesManager.IPropertyDescriptor[] propertyDescriptors) {
        System.out.println(optionsGroupingName);
        PropertiesManager.IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors;
        int n = propertyDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesManager.IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            if (descriptor.isCommandLineOption()) {
                StringBuilder lineBuilder = new StringBuilder();
                lineBuilder.append("  - ").append(descriptor.getName()).append('=');
                switch (descriptor.getType()) {
                    case BOOLEAN: {
                        lineBuilder.append("[true,false]");
                        break;
                    }
                    case INT: {
                        lineBuilder.append("[integer]");
                        break;
                    }
                    case STRING: {
                        lineBuilder.append("[string]");
                        break;
                    }
                    case PATH: {
                        lineBuilder.append("[path]");
                    }
                }
                lineBuilder.append('\t').append(descriptor.getDescription());
                System.out.println(lineBuilder.toString());
            }
            ++n2;
        }
    }

    protected final void displayUsage() {
        System.out.println("Usage: safe [options]\n");
        this.displayUsage("Common Options:", CommonProperties.Props.values());
        this.displaySpecificLauncherOptions();
        System.exit(0);
    }

    protected abstract AbstractSafeController createController(PropertiesManager var1);
}

