/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.controller;

import com.ibm.safe.controller.BasicResultObserver;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.internal.exceptions.SetUpException;
import com.ibm.safe.internal.runners.CompositeSolverRunner;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.properties.CommonProperties;
import com.ibm.safe.properties.PropertiesManager;
import com.ibm.safe.reporting.IReporter;
import com.ibm.safe.rules.CommandLineRulesReader;
import com.ibm.safe.rules.DummyRule;
import com.ibm.safe.rules.IRule;
import com.ibm.safe.rules.IRulesReader;
import com.ibm.safe.utils.SafeLogger;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.util.CancelException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractSafeController {
    protected static final String VERSION_PROPERTIES_FILE = "com/ibm/safe/version.properties";
    protected final PropertiesManager propertiesManager;

    protected AbstractSafeController(PropertiesManager thePropertiesManager) {
        this.propertiesManager = thePropertiesManager;
    }

    protected boolean isMining() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.MINE_DFA);
    }

    public abstract void execute(IRule[] var1, IReporter var2, IProgressMonitor var3) throws SafeException, CancelException, IllegalArgumentException, CoreException;

    public IRule[] getRules() throws PropertiesException {
        return this.createRulesReader().getRules();
    }

    protected IRulesReader createRulesReader() throws PropertiesException {
        String rulesDirsProperty = this.propertiesManager.getPathValue(CommonProperties.Props.RULES_DIRS);
        assert (rulesDirsProperty != null);
        CommandLineRulesReader rulesReader = new CommandLineRulesReader(rulesDirsProperty.split("[,;]\\s*"));
        try {
            rulesReader.load(this.getClass().getClassLoader());
        }
        catch (IOException except) {
            throw new PropertiesException("Unable to read rules in directory " + rulesDirsProperty, except);
        }
        return rulesReader;
    }

    protected void displaySafeVersion(IReporter reporter) {
        block5: {
            Properties versionProperties = new Properties();
            InputStream inStream = this.getClass().getClassLoader().getResourceAsStream(VERSION_PROPERTIES_FILE);
            if (inStream != null) {
                try {
                    versionProperties.load(inStream);
                    String version = versionProperties.getProperty("version");
                    if (version != null) {
                        reporter.version(version);
                        break block5;
                    }
                    reporter.version("Unknown (Property 'version' in 'version.properties' is not set)");
                }
                catch (IOException iOException) {
                    reporter.version("Unknown (Properties loading of 'version.properties' failed)");
                }
            } else {
                reporter.version("Unknown (Reading of 'version.properties' failed)");
            }
        }
    }

    protected void execute(CompositeSolverRunner solverRunner, PerformanceTracker perfoTracker, IReporter originalReporter, IReporter realReporter, IProgressMonitor monitor) throws SafeException, CancelException, IllegalArgumentException, CoreException {
        try {
            try {
                if (this.shouldCreateDomoReport()) {
                    Trace.setTraceFile(this.propertiesManager.getStringValue(CommonProperties.Props.DOMO_REPORT));
                }
                if (this.isVerboseMode()) {
                    this.displaySafeVersion(realReporter);
                }
                BasicResultObserver resultObserver = new BasicResultObserver(realReporter);
                monitor.beginTask(null, 1);
                solverRunner.run(resultObserver, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                originalReporter.reportNumberOfFindings(resultObserver.getNumberOfFindings());
            }
            catch (SafeException except) {
                realReporter.reportException(except);
                throw except;
            }
        }
        finally {
            if (perfoTracker != null) {
                realReporter.reportPerformanceTracking(perfoTracker);
                if (this.shouldCreateDomoReport()) {
                    Trace.print(perfoTracker.reportPerformanceTracking());
                }
            }
            try {
                realReporter.produceFinalReport();
            }
            catch (Exception except) {
                except.printStackTrace();
                SafeLogger.severe("Unable to create XML report.");
            }
        }
    }

    protected boolean hasStructuralOptionsActivated() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.STRUCTURAL);
    }

    protected boolean hasTypeStateOptionsActivated() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.TYPESTATE);
    }

    protected boolean hasNullDerefOptionsActivated() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.NULLDEREF);
    }

    protected boolean isVerboseMode() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.VERBOSE);
    }

    protected void reportRulesActivated(IReporter reporter, IRule[] structuralRules, IRule[] typeStateRules) throws PropertiesException, SetUpException {
        if (!this.isMining() && structuralRules.length == 0 && typeStateRules.length == 0) {
            throw new SetUpException("No SAFE rules have been activated after the selection of the ones loaded.");
        }
        this.reportRulesActivated(reporter, structuralRules);
        this.reportRulesActivated(reporter, typeStateRules);
    }

    protected void reportRulesActivated(IReporter reporter, IRule[] rules) throws PropertiesException {
        if (this.isMining()) {
            DummyRule miningRule = new DummyRule("mining");
            reporter.reportRuleLoading(miningRule);
            reporter.reportNumberOfRulesActivated(1);
        } else {
            int i = 0;
            while (i < rules.length) {
                reporter.reportRuleLoading(rules[i]);
                ++i;
            }
            if (rules.length > 0) {
                reporter.reportNumberOfRulesActivated(rules.length);
            }
        }
    }

    protected boolean shouldCreateDomoReport() throws PropertiesException {
        return this.propertiesManager.getStringValue(CommonProperties.Props.DOMO_REPORT) != null;
    }

    protected boolean shouldUsePerfomanceTracker() throws PropertiesException {
        return this.propertiesManager.getBooleanValue(CommonProperties.Props.PERFORMANCE_TRACKING);
    }
}

