/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.callgraph;

import com.ibm.safe.callgraph.AllMainEntryPoints;
import com.ibm.safe.callgraph.CHABasedCFABuilder;
import com.ibm.safe.callgraph.CHABasedCallGraph;
import com.ibm.safe.callgraph.CustomCFABuilder;
import com.ibm.safe.callgraph.CustomCICFABuilder;
import com.ibm.safe.callgraph.SelectiveEntryPoints;
import com.ibm.safe.cha.J2SEClassHierarchyEngine;
import com.ibm.safe.internal.exceptions.PropertiesException;
import com.ibm.safe.internal.exceptions.SafeException;
import com.ibm.safe.options.WholeProgramOptions;
import com.ibm.safe.perf.PerformanceTracker;
import com.ibm.safe.utils.Trace;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ide.util.ProgressMonitorDelegate;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Util;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.JavaModelException;

public class CallGraphEngine
extends AbstractAnalysisEngine {
    private final CallGraphKind callGraphKind;
    private AbstractAnalysisEngine chaEngine;
    private final AnalysisOptions domoOptions = new AnalysisOptions();
    private final WholeProgramOptions wholeProgramOptions;
    private final IProgressMonitor monitor;
    private final PerformanceTracker perfoTracker;
    private String[] interestingTypes;

    public CallGraphEngine(CallGraphKind callGraphKind, WholeProgramOptions wpOptions, PerformanceTracker domoPerfoTracker, IProgressMonitor monitor, boolean isJ2EE) throws PropertiesException {
        this.callGraphKind = callGraphKind;
        this.perfoTracker = domoPerfoTracker;
        this.wholeProgramOptions = wpOptions;
        this.monitor = monitor;
        if (!isJ2EE) {
            this.chaEngine = new J2SEClassHierarchyEngine(wpOptions, this.perfoTracker, monitor);
        }
    }

    public void computeCallGraph() throws SafeException, IllegalArgumentException, CancelException {
        try {
            this.scope = this.wholeProgramOptions.getOrCreateAnalysisScope();
            if (this.chaEngine.getClassHierarchy() == null) {
                this.chaEngine.buildClassHierarchy();
            }
            super.setClassHierarchy(this.chaEngine.getClassHierarchy());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        Iterable<Entrypoint> entrypoints = this.wholeProgramOptions.allMainClassesEntrypoints() ? new AllMainEntryPoints(this.getScope(), this.getClassHierarchy(), this.wholeProgramOptions.getMainClassesSelector(), this.wholeProgramOptions.isVerboseMode()) : new SelectiveEntryPoints(this.getScope(), this.getClassHierarchy(), this.wholeProgramOptions.getEntryPointDefinitions());
        this.domoOptions.setAnalysisScope(this.getScope());
        this.domoOptions.setEntrypoints((Iterable)entrypoints);
        try {
            if (this.perfoTracker != null) {
                this.perfoTracker.startTracking(PerformanceTracker.Stages.CALLGRAPH.toString());
            }
            this.buildCallGraph(this.getClassHierarchy(), this.domoOptions, true, (MonitorUtil.IProgressMonitor)ProgressMonitorDelegate.createProgressMonitorDelegate((IProgressMonitor)this.monitor));
        }
        finally {
            if (this.perfoTracker != null) {
                this.perfoTracker.stopTracking(PerformanceTracker.Stages.CALLGRAPH.toString());
            }
        }
    }

    public void setInterestingTypes(String[] interestingTypes) throws PropertiesException {
        this.interestingTypes = interestingTypes;
    }

    public CallGraphBuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        CallGraphBuilder builder = null;
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        switch (this.callGraphKind) {
            case RTA: {
                builder = Util.makeRTABuilder((AnalysisOptions)options, (IAnalysisCacheView)cache, (IClassHierarchy)cha, (AnalysisScope)this.getScope());
                Trace.println("Using RTA Builder");
                break;
            }
            case ZERO_CFA: {
                builder = Util.makeZeroCFABuilder((AnalysisOptions)options, (IAnalysisCacheView)cache, (IClassHierarchy)cha, (AnalysisScope)this.getScope());
                Trace.println("Using 0-CFA Builder");
                break;
            }
            case ZERO_ONE_CFA: {
                builder = CallGraphEngine.makeZeroOneCFABuilder(options, cache, cha, cl, this.getScope(), true);
                Trace.println("Using 0-1-CFA Builder");
                break;
            }
            case ZERO_CONTAINER_CFA: {
                builder = Util.makeZeroContainerCFABuilder((AnalysisOptions)options, (IAnalysisCacheView)cache, (IClassHierarchy)cha, (AnalysisScope)this.getScope());
                Trace.println("Using 0-Container-CFA Builder");
                break;
            }
            case ZERO_ONE_CONTAINER_CFA: {
                builder = Util.makeZeroOneContainerCFABuilder((AnalysisOptions)options, (IAnalysisCacheView)cache, (IClassHierarchy)cha, (AnalysisScope)this.getScope());
                Trace.println("Using 0-1-Container-CFA Builder");
                break;
            }
            case ZERO_ONE_CUSTOM: {
                builder = CallGraphEngine.makeCustomCFABuilder(options, cache, cha, cl, this.getScope(), CallGraphEngine.toIClassCollection(this.interestingTypes, cha));
                Trace.println("Using 0-1-Custom-CFA Builder");
                break;
            }
            case CHA: {
                builder = CallGraphEngine.makeCHABasedCFABuilder(options, cache, cha, cl, this.getScope());
                Trace.println("Using CHA-Based-CFA Builder");
                break;
            }
            default: {
                Assertions.UNREACHABLE();
            }
        }
        return builder;
    }

    public static CallGraphBuilder makeZeroOneCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ClassLoader cl, AnalysisScope scope, boolean keepPointsTo) {
        Util.addDefaultSelectors((AnalysisOptions)options, (IClassHierarchy)cha);
        Util.addDefaultBypassLogic((AnalysisOptions)options, (AnalysisScope)scope, (ClassLoader)cl, (IClassHierarchy)cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new CustomCICFABuilder(cha, options, cache, appSelector, appInterpreter);
    }

    public static CallGraphBuilder makeCustomCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ClassLoader cl, AnalysisScope scope, Collection<IClass> interestingTypes) {
        assert (interestingTypes != null);
        Util.addDefaultSelectors((AnalysisOptions)options, (IClassHierarchy)cha);
        Util.addDefaultBypassLogic((AnalysisOptions)options, (AnalysisScope)scope, (ClassLoader)cl, (IClassHierarchy)cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new CustomCFABuilder(cha, options, cache, appSelector, appInterpreter, interestingTypes);
    }

    public static CallGraphBuilder makeCHABasedCFABuilder(AnalysisOptions options, IAnalysisCacheView cache, IClassHierarchy cha, ClassLoader cl, AnalysisScope scope) {
        Util.addDefaultSelectors((AnalysisOptions)options, (IClassHierarchy)cha);
        Util.addDefaultBypassLogic((AnalysisOptions)options, (AnalysisScope)scope, (ClassLoader)cl, (IClassHierarchy)cha);
        ContextSelector appSelector = null;
        SSAContextInterpreter appInterpreter = null;
        return new CHABasedCFABuilder(cha, options, cache, appSelector, appInterpreter);
    }

    public CallGraph getCallGraph() {
        return super.getCallGraph();
    }

    public PointerAnalysis getPointerAnalysis() {
        return super.getPointerAnalysis();
    }

    public AnalysisOptions getAnalysisOptions() {
        return this.domoOptions;
    }

    public void computeClassHierarchy() {
        if (this.getClassHierarchy() == null) {
            try {
                this.scope = this.wholeProgramOptions.getOrCreateAnalysisScope();
            }
            catch (PropertiesException propertiesException) {
                throw new RuntimeException("Arrgghh.");
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IClassHierarchy builtCha = this.buildClassHierarchy();
            super.setClassHierarchy(builtCha);
            this.cg = new CHABasedCallGraph(builtCha, this.domoOptions, this.makeDefaultCache());
        }
    }

    public IClassHierarchy classHierarchy() {
        IClassHierarchy result = super.getClassHierarchy();
        assert (result != null);
        return result;
    }

    private static Collection<IClass> toIClassCollection(String[] propertyTypes, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        int i = 0;
        while (i < propertyTypes.length) {
            String t = propertyTypes[i];
            IClass klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)t));
            if (klass != null) {
                result.add(klass);
                if (klass.isInterface()) {
                    result.addAll(cha.getImplementors(klass.getReference()));
                } else {
                    result.addAll(cha.computeSubClasses(klass.getReference()));
                }
            }
            ++i;
        }
        return result;
    }

    public static enum CallGraphKind {
        CHA,
        RTA,
        ZERO_CFA,
        ZERO_ONE_CFA,
        XTA,
        ZERO_CONTAINER_CFA,
        ZERO_ONE_CONTAINER_CFA,
        ZERO_ONE_CUSTOM,
        ONE_ONE_CFA;

    }
}

