/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.safe.callgraph;

import com.ibm.safe.utils.ReceiverTypeInference;
import com.ibm.wala.analysis.typeInference.ConeType;
import com.ibm.wala.analysis.typeInference.PointType;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.ExplicitCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.cfa.ContextInsensitiveSSAInterpreter;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CHABasedCallGraph
extends ExplicitCallGraph {
    protected static final Context CONTEXT = Everywhere.EVERYWHERE;

    public CHABasedCallGraph(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        super(cha, options, cache);
        this.setInterpreter(new ContextInsensitiveSSAInterpreter(options, cache));
        for (IClass klass : cha) {
            for (IMethod method : klass.getDeclaredMethods()) {
                if (method.isAbstract() && !method.isSynthetic()) continue;
                try {
                    this.findOrCreateNode(method, CONTEXT);
                }
                catch (CancelException e) {
                    System.err.println("WARNING: findOrCreateNode cancelled for " + method);
                    e.printStackTrace();
                }
            }
        }
    }

    public class CHABasedNode
    extends ExplicitCallGraph.ExplicitNode {
        protected CHABasedNode(IMethod method, Context C) {
            super((ExplicitCallGraph)CHABasedCallGraph.this, method, C);
            assert (C == CONTEXT);
        }

        protected Set<CGNode> getPossibleTargets(CallSiteReference site) {
            TypeInference ti = TypeInference.make((IR)this.getIR(), (boolean)false);
            ReceiverTypeInference rti = new ReceiverTypeInference(ti);
            TypeAbstraction t = rti.getReceiverType(site);
            HashSet result = HashSetFactory.make();
            if (t instanceof ConeType) {
                ConeType cone = (ConeType)t;
                if (cone.getType().isInterface()) {
                    Set implementors = CHABasedCallGraph.this.cha.getImplementors(cone.getType().getReference());
                    for (IClass klass : implementors) {
                        this.addTarget(result, klass, site);
                    }
                } else {
                    Collection subTypes = CHABasedCallGraph.this.cha.computeSubClasses(t.getType().getReference());
                    for (IClass klass : subTypes) {
                        this.addTarget(result, klass, site);
                    }
                }
            } else if (t instanceof PointType) {
                this.addTarget(result, t.getType(), site);
            } else {
                if (t.equals((Object)TypeAbstraction.TOP)) {
                    return Collections.emptySet();
                }
                Assertions.UNREACHABLE((String)("internal error: " + t.getClass()));
            }
            return result;
        }

        protected void addTarget(Collection<CGNode> nodes, IClass klass, CallSiteReference site) {
            IMethod target = CHABasedCallGraph.this.cha.resolveMethod(klass, site.getDeclaredTarget().getSelector());
            try {
                nodes.add(this.getCallGraph().findOrCreateNode(target, CONTEXT));
            }
            catch (CancelException e) {
                System.err.println("WARNING: The addition of the following node was cancelled: " + target);
                e.printStackTrace();
            }
        }

        protected IntSet getPossibleTargetNumbers(CallSiteReference site) {
            MutableSharedBitVectorIntSet result = new MutableSharedBitVectorIntSet();
            for (CGNode target : this.getPossibleTargets(site)) {
                result.add(this.getCallGraph().getNumber(target));
            }
            return result;
        }

        protected int getNumberOfTargets(CallSiteReference site) {
            return this.getPossibleTargets(site).size();
        }

        public boolean addTarget(CallSiteReference site, CGNode tNode) {
            Assertions.UNREACHABLE();
            return false;
        }

        public void removeTarget(CGNode target) {
            Assertions.UNREACHABLE();
        }

        public void clearAllTargets() {
            Assertions.UNREACHABLE();
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.getMethod().hashCode();
        }

        public CHABasedCallGraph getCallGraph() {
            return CHABasedCallGraph.this;
        }
    }
}

