/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.sourcepos.CRTable;
import com.ibm.wala.sourcepos.MethodPositions;
import com.ibm.wala.sourcepos.Range;
import java.io.IOException;

public final class SourcePositionTableReader
extends AttributeReader {
    private static final int ATTRIBUTE_HEADER_SIZE = 6;

    protected SourcePositionTableReader(ClassReader.AttrIterator attr) throws InvalidClassFileException {
        super(attr, "CharacterRangeTable");
    }

    public static Position findParameterPosition(int methodNr, CodeReader code) throws InvalidClassFileException, IOException {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        Position params = null;
        ClassReader.AttrIterator cIter = new ClassReader.AttrIterator();
        ClassReader cr = code.getClassReader();
        cr.initMethodAttributeIterator(methodNr, cIter);
        while (cIter.isValid()) {
            if ("joana.sourceinfo.MethodPositions".equals(cIter.getName())) {
                byte[] data = SourcePositionTableReader.getData(cr, cIter.getRawOffset(), cIter.getRawSize());
                MethodPositions mPos = new MethodPositions(data);
                Range r = mPos.getMethodInfo();
                params = SourcePositionTableReader.convert(r);
            }
            cIter.advance();
        }
        return params;
    }

    public static Position[] makeBytecodeToPositionMap(CodeReader code) throws InvalidClassFileException, IOException {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        Position[] pos = null;
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        code.initAttributeIterator(iter);
        while (iter.isValid()) {
            if ("CharacterRangeTable".equals(iter.getName())) {
                if (pos == null) {
                    pos = new Position[code.getBytecodeLength()];
                }
                SourcePositionTableReader spRead = new SourcePositionTableReader(iter);
                spRead.fillBytecodeToPositionMap(pos);
            }
            iter.advance();
        }
        if (pos != null) {
            Position last = new Position(0, 0, 0, 0);
            int i = 0;
            while (i < pos.length) {
                Position cur = pos[i];
                if (cur == null) {
                    pos[i] = last;
                } else {
                    last = cur;
                }
                ++i;
            }
        }
        return pos;
    }

    private static final byte[] getData(ClassReader cr, int rawOffset, int rawSize) {
        byte[] klass = cr.getBytes();
        int size = rawSize - 6;
        byte[] data = new byte[size];
        System.arraycopy(klass, rawOffset + 6, data, 0, size);
        return data;
    }

    private void fillBytecodeToPositionMap(Position[] pos) throws IOException {
        byte[] tableData = SourcePositionTableReader.getData(this.getClassReader(), this.getRawOffset(), this.getRawSize());
        CRTable crTable = new CRTable(tableData);
        int pc = 0;
        while (pc < pos.length) {
            Position p;
            Range r = crTable.getSourceInfo(pc);
            pos[pc] = p = SourcePositionTableReader.convert(r);
            ++pc;
        }
    }

    private static final Position convert(Range r) {
        Position pos = null;
        if (r != null) {
            com.ibm.wala.sourcepos.Position start = r.getStartPosition();
            com.ibm.wala.sourcepos.Position end = r.getEndPosition();
            if (start != null && !start.isUndefined()) {
                pos = end != null && !end.isUndefined() ? new Position(start.getLine(), end.getLine(), start.getColumn(), end.getColumn()) : new Position(start.getLine(), start.getLine(), -1, -1);
            }
        }
        return pos;
    }

    public static Position[] makeLineNumberToPositionMap(int[] lineNumberMap) {
        Position[] pos = new Position[lineNumberMap.length];
        int i = 0;
        while (i < pos.length) {
            int line = lineNumberMap[i];
            pos[i] = new Position(line, line, -1, -1);
            ++i;
        }
        return pos;
    }

    public static final class Position
    implements Comparable<Object> {
        public final int firstLine;
        public final int lastLine;
        public final int firstCol;
        public final int lastCol;

        private Position(int firstLine, int lastLine, int firstCol, int lastCol) {
            this.firstLine = firstLine;
            this.lastLine = lastLine;
            this.firstCol = firstCol;
            this.lastCol = lastCol;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof Position) {
                Position p = (Position)o;
                if (this.firstLine != p.firstLine) {
                    return this.firstLine - p.firstLine;
                }
                if (this.firstCol != p.firstCol) {
                    return this.firstCol - p.firstCol;
                }
                if (this.lastLine != p.lastLine) {
                    return this.lastLine - p.lastLine;
                }
                if (this.lastCol != p.lastCol) {
                    return this.lastCol - p.lastCol;
                }
                return 0;
            }
            return -1;
        }
    }
}

