/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.util.Arrays;

public final class LocalVariableTableWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] rawTable = emptyTable;
    private static final int[] emptyTable = new int[0];

    public LocalVariableTableWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("LocalVariableTable");
    }

    public void setRawTable(int[] table) {
        if (table == null) {
            table = emptyTable;
        }
        if (table.length % 5 != 0) {
            throw new IllegalArgumentException("Local variable table has bad length: " + table.length);
        }
        if (table.length / 5 > 65535) {
            throw new IllegalArgumentException("Too many local variable table entries: " + table.length / 5);
        }
        int i = 0;
        while (i < table.length) {
            int v = table[i];
            if (v < 0 || v > 65535) {
                throw new IllegalArgumentException("Bad local variable table entry at " + i + ": " + v);
            }
            ++i;
        }
        this.rawTable = table;
    }

    @Override
    public int getSize() {
        return 8 + this.rawTable.length * 2;
    }

    @Override
    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, 2 + this.rawTable.length * 2);
        ClassWriter.setUShort(buf, offset + 6, this.rawTable.length / 5);
        offset += 8;
        int i = 0;
        while (i < this.rawTable.length) {
            ClassWriter.setUShort(buf, offset, this.rawTable[i]);
            offset += 2;
            ++i;
        }
        return offset;
    }

    public static int[] makeRawTable(int[][] varMap, Compiler.Output output) throws IllegalArgumentException {
        int entryCount;
        int[] entries;
        block12: {
            if (varMap == null) {
                throw new IllegalArgumentException("varMap == null");
            }
            try {
                int varCount = 0;
                int i = 0;
                while (i < varMap.length) {
                    if (varMap[i] != null) {
                        varCount = Math.max(varCount, varMap[i].length);
                    }
                    ++i;
                }
                entries = new int[20];
                int[] varEnd = new int[varCount /= 2];
                Arrays.fill(varEnd, -1);
                int[] lastVector = null;
                entryCount = 0;
                int i2 = 0;
                while (i2 < varMap.length) {
                    if (varMap[i2] != lastVector && (lastVector = varMap[i2]) != null) {
                        int k = 0;
                        while (k < lastVector.length / 2 && k < output.getMaxLocals()) {
                            if (lastVector[k * 2] > 0 && i2 >= varEnd[k]) {
                                int entryOffset = entryCount * 5;
                                if (++entryCount * 5 > entries.length) {
                                    int[] newEntries = new int[entries.length * 2];
                                    System.arraycopy(entries, 0, newEntries, 0, entries.length);
                                    entries = newEntries;
                                }
                                int nameIndex = lastVector[k * 2];
                                int typeIndex = lastVector[k * 2 + 1];
                                int end = i2 + 1;
                                while (end < varMap.length) {
                                    if (varMap[end] == null || k * 2 >= varMap[end].length || varMap[end][k * 2] != nameIndex || varMap[end][k * 2 + 1] != typeIndex) break;
                                    ++end;
                                }
                                varEnd[k] = end;
                                entries[entryOffset] = i2;
                                entries[entryOffset + 1] = end - i2;
                                entries[entryOffset + 2] = nameIndex;
                                entries[entryOffset + 3] = typeIndex;
                                entries[entryOffset + 4] = k;
                            }
                            ++k;
                        }
                    }
                    ++i2;
                }
                if (entryCount != 0) break block12;
                return null;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("malformed varMap");
            }
        }
        int[] r = new int[entryCount * 5];
        System.arraycopy(entries, 0, r, 0, r.length);
        return r;
    }
}

