/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.ConstantValueWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

public class AddSerialVersion {
    private AddSerialVersion() {
    }

    public static void addSerialVersionUID(ClassReader r, ClassWriter w) throws InvalidClassFileException {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        int numFields = r.getFieldCount();
        int i = 0;
        while (i < numFields) {
            if (r.getFieldName(i).equals("serialVersionUID")) {
                return;
            }
            ++i;
        }
        long UID = AddSerialVersion.computeSerialVersionUID(r);
        w.addField(25, "serialVersionUID", "J", new ClassWriter.Element[]{new ConstantValueWriter(w, UID)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long computeSerialVersionUID(ClassReader r) throws InvalidClassFileException {
        MessageDigest digest;
        block28: {
            if (r == null) {
                throw new IllegalArgumentException("r is null");
            }
            try {
                digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("SHA algorithm not supported: " + e.getMessage());
            }
            try {
                Throwable e = null;
                Object var3_5 = null;
                try {
                    SinkOutputStream sink = new SinkOutputStream();
                    try {
                        try (DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink, digest));){
                            try {
                                int i;
                                out.writeUTF(r.getName());
                                out.writeInt(r.getAccessFlags());
                                Object[] interfaces = r.getInterfaceNames();
                                Arrays.sort(interfaces);
                                int i2 = 0;
                                while (true) {
                                    if (i2 >= interfaces.length) break;
                                    out.writeUTF((String)interfaces[i2]);
                                    ++i2;
                                }
                                Integer[] fields = new Integer[r.getFieldCount()];
                                final String[] fieldNames = new String[fields.length];
                                int fieldCount = 0;
                                int f = 0;
                                while (true) {
                                    if (f >= fields.length) break;
                                    int flags = r.getFieldAccessFlags(f);
                                    if ((flags & 2) == 0 || (flags & 0x88) == 0) {
                                        fields[fieldCount] = new Integer(f);
                                        fieldNames[f] = r.getFieldName(f);
                                        ++fieldCount;
                                    }
                                    ++f;
                                }
                                Arrays.sort(fields, 0, fieldCount, new Comparator<Integer>(){

                                    @Override
                                    public int compare(Integer o1, Integer o2) {
                                        String name1 = fieldNames[o1];
                                        String name2 = fieldNames[o2];
                                        return name1.compareTo(name2);
                                    }
                                });
                                int i3 = 0;
                                while (true) {
                                    if (i3 >= fieldCount) break;
                                    int f2 = fields[i3];
                                    out.writeUTF(fieldNames[f2]);
                                    out.writeInt(r.getFieldAccessFlags(f2));
                                    out.writeUTF(r.getFieldType(f2));
                                    ++i3;
                                }
                                Integer[] methods = new Integer[r.getMethodCount()];
                                final int[] methodKinds = new int[methods.length];
                                final String[] methodSigs = new String[methods.length];
                                int methodCount = 0;
                                int m = 0;
                                while (true) {
                                    if (m >= methodSigs.length) {
                                        Arrays.sort(methods, 0, methodCount, new Comparator<Integer>(){

                                            @Override
                                            public int compare(Integer o1, Integer o2) {
                                                int m2;
                                                int m1 = o1;
                                                if (methodKinds[m1] != methodKinds[m2 = o2.intValue()]) {
                                                    return methodKinds[m1] - methodKinds[m2];
                                                }
                                                String name1 = methodSigs[m1];
                                                String name2 = methodSigs[m2];
                                                return name1.compareTo(name2);
                                            }
                                        });
                                        i = 0;
                                        break;
                                    }
                                    String name = r.getMethodName(m);
                                    int flags = r.getMethodAccessFlags(m);
                                    if (name.equals("<clinit>") || (flags & 2) == 0) {
                                        methods[methodCount] = new Integer(m);
                                        methodSigs[m] = String.valueOf(name) + r.getMethodType(m);
                                        methodKinds[m] = name.equals("<clinit>") ? 0 : (name.equals("<init>") ? 1 : 2);
                                        ++methodCount;
                                    }
                                    ++m;
                                }
                                while (i < methodCount) {
                                    int m2 = methods[i];
                                    out.writeUTF(r.getMethodName(m2));
                                    out.writeInt(r.getMethodAccessFlags(m2));
                                    out.writeUTF(r.getMethodType(m2));
                                    ++i;
                                }
                            }
                            catch (IOException e1) {
                                throw new Error("Unexpected IOException: " + e1.getMessage());
                            }
                        }
                        if (sink == null) break block28;
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        if (sink == null) throw e;
                        sink.close();
                        throw e;
                    }
                    sink.close();
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                        throw e;
                    }
                    if (e == throwable) throw e;
                    e.addSuppressed(throwable);
                    throw e;
                }
            }
            catch (IOException iOException) {}
        }
        byte[] hash = digest.digest();
        return hash[0] & 0xFF | (hash[1] & 0xFF) << 8 | (hash[2] & 0xFF) << 16 | hash[3] << 24 | (hash[4] & 0xFF) << 32 | (hash[5] & 0xFF) << 40 | (hash[6] & 0xFF) << 48 | (hash[7] & 0xFF) << 56;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                throw new IllegalArgumentException("args[" + i + "] is null");
            }
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream in = new FileInputStream(args[i]);){
                    byte[] data = Util.readFully(in);
                    ClassReader r = new ClassReader(data);
                    System.out.println(String.valueOf(Util.makeClass(r.getName())) + ": serialVersionUID = " + AddSerialVersion.computeSerialVersionUID(r));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + args[i]);
            }
            catch (IOException iOException) {
                System.err.println("Error reading file: " + args[i]);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                System.err.println("Invalid class file: " + args[i]);
            }
            ++i;
        }
    }

    public static final class SinkOutputStream
    extends OutputStream {
        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }
}

