/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import java.util.Arrays;

public final class SwitchInstruction
extends Instruction {
    private final int[] casesAndLabels;
    private final int defaultLabel;

    protected SwitchInstruction(short opcode, int[] casesAndLabels, int defaultLabel) {
        super(opcode);
        this.casesAndLabels = casesAndLabels;
        this.defaultLabel = defaultLabel;
    }

    public int getDefaultLabel() {
        return this.defaultLabel;
    }

    public int[] getCasesAndLabels() {
        return this.casesAndLabels;
    }

    public static SwitchInstruction make(int[] casesAndLabels, int defaultLabel) {
        if (casesAndLabels == null) {
            throw new IllegalArgumentException("casesAndLabels is null");
        }
        int opcode = 170;
        int i = 2;
        while (i < casesAndLabels.length) {
            int curCase = casesAndLabels[i];
            int lastCase = casesAndLabels[i - 2];
            if (curCase <= lastCase) {
                throw new IllegalArgumentException("Cases and labels array must be sorted by case");
            }
            if (curCase != lastCase + 1) {
                opcode = 171;
            }
            i += 2;
        }
        if (casesAndLabels.length == 0) {
            opcode = 171;
        }
        return new SwitchInstruction((short)opcode, casesAndLabels, defaultLabel);
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }

    @Override
    public int[] getBranchTargets() {
        int[] r = new int[this.casesAndLabels.length / 2 + 1];
        r[0] = this.defaultLabel;
        int i = 1;
        while (i < r.length) {
            r[i] = this.casesAndLabels[(i - 1) * 2 + 1];
            ++i;
        }
        return r;
    }

    @Override
    public IInstruction redirectTargets(int[] targetMap) throws IllegalArgumentException {
        if (targetMap == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            int[] cs = new int[this.casesAndLabels.length];
            int i = 0;
            while (i < cs.length) {
                cs[i] = this.casesAndLabels[i];
                cs[i + 1] = targetMap[this.casesAndLabels[i + 1]];
                i += 2;
            }
            return SwitchInstruction.make(cs, targetMap[this.defaultLabel]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Illegal target map", e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SwitchInstruction) {
            SwitchInstruction i = (SwitchInstruction)o;
            return i.defaultLabel == this.defaultLabel && Arrays.equals(i.casesAndLabels, this.casesAndLabels);
        }
        return false;
    }

    public int hashCode() {
        int h = this.defaultLabel * 1348091 + 111311;
        int i = 0;
        while (i < this.casesAndLabels.length) {
            h += (i * 9301 + 38101) * this.casesAndLabels[i];
            ++i;
        }
        return h;
    }

    @Override
    public int getPoppedCount() {
        return 1;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer("Switch(");
        b.append(this.defaultLabel);
        int i = 0;
        while (i < this.casesAndLabels.length) {
            b.append(',');
            b.append(this.casesAndLabels[i]);
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public void visit(IInstruction.Visitor v) throws IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        v.visitSwitch(this);
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

