/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class InvokeDynamicInstruction
extends Instruction
implements IInvokeInstruction {
    protected BootstrapMethodsReader.BootstrapMethod bootstrap;
    protected String methodName;
    protected String methodType;

    private InvokeDynamicInstruction(short opcode, BootstrapMethodsReader.BootstrapMethod bootstrap, String methodName, String methodType) {
        super(opcode);
        this.bootstrap = bootstrap;
        this.methodName = methodName;
        this.methodType = methodType;
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    @Override
    public boolean isPEI() {
        return true;
    }

    @Override
    public IInvokeInstruction.Dispatch getInvocationCode() {
        int invokeType = this.getBootstrap().invokeType();
        switch (invokeType) {
            case 5: {
                return IInvokeInstruction.Dispatch.VIRTUAL;
            }
            case 6: {
                return IInvokeInstruction.Dispatch.STATIC;
            }
            case 7: {
                return IInvokeInstruction.Dispatch.SPECIAL;
            }
            case 9: {
                return IInvokeInstruction.Dispatch.INTERFACE;
            }
        }
        throw new Error("unexpected dynamic invoke type " + invokeType);
    }

    @Override
    public final int getPoppedCount() {
        return (this.getInvocationCode().equals(IInvokeInstruction.Dispatch.STATIC) ? 0 : 1) + Util.getParamsCount(this.getMethodSignature());
    }

    @Override
    public final String getPushedType(String[] types) {
        String t = Util.getReturnType(this.getMethodSignature());
        if (t.equals("V")) {
            return null;
        }
        return t;
    }

    @Override
    public final byte getPushedWordSize() {
        String t = this.getMethodSignature();
        int index = t.lastIndexOf(41);
        return Util.getWordSize(t, index + 1);
    }

    public BootstrapMethodsReader.BootstrapMethod getBootstrap() {
        return this.bootstrap;
    }

    @Override
    public String getMethodSignature() {
        return this.methodType;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getClassType() {
        return "L" + this.getBootstrap().methodClass();
    }

    @Override
    public void visit(IInstruction.Visitor v) {
        v.visitInvoke(this);
    }

    @Override
    public String toString() {
        return "InvokeDynamic [" + this.getBootstrap() + "] " + this.getMethodName() + this.getMethodSignature();
    }

    public CallSite bootstrap(Class cl) throws ClassNotFoundException, NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException {
        ClassLoader classLoader;
        ClassLoader bootstrapCL = classLoader = cl.getClassLoader();
        Class<?> bootstrapClass = Class.forName(this.getBootstrap().methodClass().replace('/', '.'), false, bootstrapCL);
        MethodType bt = InvokeDynamicInstruction.makeMethodType(bootstrapCL, this.bootstrap.methodType());
        Method bootstrap = bootstrapClass.getMethod(this.bootstrap.methodName(), bt.parameterList().toArray(new Class[bt.parameterCount()]));
        Object[] args = new Object[bt.parameterCount()];
        MethodHandles.Lookup myLookup = MethodHandles.lookup().in(cl);
        Field impl_lookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
        impl_lookup.setAccessible(true);
        MethodHandles.Lookup lutrusted = (MethodHandles.Lookup)impl_lookup.get(myLookup);
        args[0] = lutrusted;
        args[1] = this.getMethodName();
        args[2] = InvokeDynamicInstruction.makeMethodType(classLoader, this.getMethodSignature());
        int i = 3;
        while (i < bt.parameterCount()) {
            args[i] = this.getBootstrap().callArgument(bootstrapCL, i - 3);
            ++i;
        }
        bootstrap.setAccessible(true);
        System.err.println(cl + " : " + bootstrap);
        return (CallSite)bootstrap.invoke(null, args);
    }

    public static MethodType makeMethodType(ClassLoader classLoader, String descriptor) throws ClassNotFoundException {
        String returnType = Util.makeClass(Util.getReturnType(descriptor));
        Class<?> returnClass = Class.forName(returnType, false, classLoader);
        String[] paramTypes = Util.getParamsTypes(null, descriptor);
        Class[] paramClasses = new Class[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramClasses[i] = Class.forName(Util.makeClass(paramTypes[i]), false, classLoader);
            ++i;
        }
        MethodType mt = MethodType.methodType(returnClass, paramClasses);
        return mt;
    }

    static InvokeDynamicInstruction make(ConstantPoolReader cp, int index, int mode) {
        if (mode != 186) {
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
        return new Lazy((short)mode, cp, index);
    }

    /* synthetic */ InvokeDynamicInstruction(short s, BootstrapMethodsReader.BootstrapMethod bootstrapMethod, String string, String string2, InvokeDynamicInstruction invokeDynamicInstruction) {
        this(s, bootstrapMethod, string, string2);
    }

    static final class Lazy
    extends InvokeDynamicInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null, null, null, null);
            this.index = index;
            this.cp = cp;
        }

        int getCPIndex() {
            return this.index;
        }

        @Override
        public BootstrapMethodsReader.BootstrapMethod getBootstrap() {
            if (this.bootstrap == null) {
                this.bootstrap = this.cp.getConstantPoolDynamicBootstrap(this.index);
            }
            return this.bootstrap;
        }

        @Override
        public String getMethodName() {
            if (this.methodName == null) {
                this.methodName = this.cp.getConstantPoolDynamicName(this.index);
            }
            return this.methodName;
        }

        @Override
        public String getMethodSignature() {
            if (this.methodType == null) {
                this.methodType = this.cp.getConstantPoolDynamicType(this.index);
            }
            return this.methodType;
        }

        @Override
        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }
    }
}

