/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;

public final class DupInstruction
extends Instruction {
    private final int size;
    private final byte delta;
    private static final DupInstruction[] preallocated = DupInstruction.preallocate();

    protected DupInstruction(byte size, byte delta) {
        super((short)-1);
        this.size = size;
        this.delta = delta;
    }

    private static DupInstruction[] preallocate() {
        DupInstruction[] r = new DupInstruction[9];
        int i = 0;
        while (i < r.length) {
            r[i] = new DupInstruction((byte)(i / 3), (byte)(i % 3));
            ++i;
        }
        return r;
    }

    static DupInstruction make(int size, int delta) {
        if (size < 0 || size > 2) {
            throw new IllegalArgumentException("Invalid dup size: " + size);
        }
        if (delta < 0 || delta > 2) {
            throw new IllegalArgumentException("Invalid dup delta: " + delta);
        }
        return preallocated[size * 3 + delta];
    }

    public static DupInstruction make(int delta) {
        if (delta < 0 || delta > 1) {
            throw new IllegalArgumentException("Invalid dup delta: " + delta);
        }
        return DupInstruction.make(1, delta);
    }

    public boolean equals(Object o) {
        if (o instanceof DupInstruction) {
            DupInstruction i = (DupInstruction)o;
            return i.size == this.size && i.delta == this.delta;
        }
        return false;
    }

    public int getSize() {
        return this.size;
    }

    public int getDelta() {
        return this.delta;
    }

    public int hashCode() {
        return this.size + 8431890 + 10 * this.delta;
    }

    @Override
    public int getPoppedCount() {
        return this.size + this.delta;
    }

    @Override
    public String toString() {
        return "Dup(" + this.size + "," + this.delta + ")";
    }

    @Override
    public void visit(IInstruction.Visitor v) {
        if (v == null) {
            throw new IllegalArgumentException("illegal null visitor");
        }
        v.visitDup(this);
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

