/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrike.bench.Slots;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IGetInstruction;
import com.ibm.wala.shrikeBT.IPutInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Random;

public class Mangler {
    private static OfflineInstrumenter instrumenter;
    private static final boolean verify = true;
    private static final boolean disasm = true;

    public static void main(String[] args) throws Exception {
        int i = 0;
        while (i < 1) {
            block15: {
                instrumenter = new OfflineInstrumenter(true);
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    ClassInstrumenter ci;
                    int seed;
                    BufferedWriter w = new BufferedWriter(new FileWriter("report", false));
                    args = instrumenter.parseStandardArgs(args);
                    try {
                        seed = Integer.parseInt(args[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("Invalid number: " + args[0]);
                        if (w != null) {
                            ((Writer)w).close();
                        }
                        return;
                    }
                    Random r = new Random(seed);
                    instrumenter.setPassUnmodifiedClasses(true);
                    instrumenter.beginTraversal();
                    instrumenter.setOutputJar(new File("output.jar"));
                    while ((ci = instrumenter.nextClass()) != null) {
                        Mangler.doClass(ci, w, r);
                    }
                    break block15;
                    finally {
                        if (w != null) {
                            ((Writer)w).close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            instrumenter.close();
            ++i;
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w, Random r) throws Exception {
        String className = ci.getReader().getName();
        w.write("Class: " + className + "\n");
        w.flush();
        int m = 0;
        while (m < ci.getReader().getMethodCount()) {
            MethodData d = ci.visitMethod(m);
            if (d != null) {
                w.write("Instrumenting " + ci.getReader().getMethodName(m) + " " + ci.getReader().getMethodType(m) + ":\n");
                w.flush();
                w.write("Initial ShrikeBT code:\n");
                new Disassembler(d).disassembleTo(w);
                w.flush();
                Verifier v = new Verifier(d);
                v.verify();
                int passes = r.nextInt(4) + 1;
                int i = 0;
                while (i < passes) {
                    final int tmpInt = LocalAllocator.allocate(d, "I");
                    final int tmpAny = LocalAllocator.allocate(d);
                    final MethodEditor me = new MethodEditor(d);
                    me.beginPass();
                    me.visitInstructions(new MethodEditor.Visitor(){

                        @Override
                        public void visitGet(IGetInstruction instruction) {
                            if (!instruction.isStatic()) {
                                this.insertBefore(new MethodEditor.Patch(){

                                    @Override
                                    public void emitTo(MethodEditor.Output w) {
                                        w.emit(DupInstruction.make(0));
                                    }
                                });
                                this.insertAfter(new MethodEditor.Patch(){

                                    @Override
                                    public void emitTo(MethodEditor.Output w) {
                                        w.emit(SwapInstruction.make());
                                        w.emit(Util.makePut(Slots.class, "o"));
                                    }
                                });
                            }
                        }

                        @Override
                        public void visitPut(IPutInstruction instruction) {
                            if (!instruction.isStatic()) {
                                this.insertBefore(new MethodEditor.Patch(){

                                    @Override
                                    public void emitTo(MethodEditor.Output w) {
                                        w.emit(SwapInstruction.make());
                                        w.emit(DupInstruction.make(1));
                                        w.emit(SwapInstruction.make());
                                    }
                                });
                                this.insertAfter(new MethodEditor.Patch(){

                                    @Override
                                    public void emitTo(MethodEditor.Output w) {
                                        w.emit(Util.makePut(Slots.class, "o"));
                                    }
                                });
                            }
                        }

                        @Override
                        public void visitArrayStore(final IArrayStoreInstruction instruction) {
                            final int label = me.allocateLabel();
                            this.insertBefore(new MethodEditor.Patch(){

                                @Override
                                public void emitTo(MethodEditor.Output w) {
                                    String t = Util.getStackType(instruction.getType());
                                    w.emit(StoreInstruction.make(t, tmpAny));
                                    w.emit(StoreInstruction.make("I", tmpInt));
                                    w.emit(DupInstruction.make(0));
                                    w.emit(LoadInstruction.make("I", tmpInt));
                                    w.emit(LoadInstruction.make(t, tmpAny));
                                    if (t.equals("I")) {
                                        w.emit(DupInstruction.make(0));
                                        w.emit(ConstantInstruction.make(0));
                                        w.emit(ConditionalBranchInstruction.make(t, IConditionalBranchInstruction.Operator.EQ, label));
                                        w.emit(DupInstruction.make(0));
                                        w.emit(Util.makePut(Slots.class, "i"));
                                        w.emitLabel(label);
                                    }
                                }
                            });
                            this.insertAfter(new MethodEditor.Patch(){

                                @Override
                                public void emitTo(MethodEditor.Output w) {
                                    w.emit(Util.makePut(Slots.class, "o"));
                                    w.emit(LoadInstruction.make("I", tmpInt));
                                    w.emit(Util.makePut(Slots.class, "i"));
                                }
                            });
                        }
                    });
                    me.applyPatches();
                    ++i;
                }
                w.write("Final ShrikeBT code:\n");
                new Disassembler(d).disassembleTo(w);
                w.flush();
            }
            ++m;
        }
        if (ci.isChanged()) {
            ClassWriter cw = ci.emitClass();
            instrumenter.outputModifiedClass(ci, cw);
        }
    }
}

