/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.cast.java.translator.jdt.JDT2CAstUtils;
import com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper;
import com.ibm.wala.cast.java.types.JavaPrimitiveTypeMap;
import com.ibm.wala.cast.java.types.JavaType;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstTypeDictionaryImpl;
import com.ibm.wala.util.debug.Assertions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class JDTTypeDictionary
extends CAstTypeDictionaryImpl {
    protected final AST fAst;
    protected final JDTIdentityMapper fIdentityMapper;

    public JDTTypeDictionary(AST ast, JDTIdentityMapper identityMapper) {
        this.fAst = ast;
        this.fIdentityMapper = identityMapper;
    }

    public CAstType getCAstTypeFor(Object astType) {
        ITypeBinding jdtType = JDT2CAstUtils.getErasedType((ITypeBinding)astType, this.fAst);
        Object type = super.getCAstTypeFor(astType);
        if (type == null) {
            if (jdtType.isClass() || jdtType.isEnum() || jdtType.isInterface()) {
                type = new JdtJavaType(jdtType);
            } else if (jdtType.isPrimitive()) {
                type = JavaPrimitiveTypeMap.lookupType((String)jdtType.getName());
            } else if (jdtType.isArray()) {
                type = new JdtJavaArrayType(jdtType);
            } else {
                Assertions.UNREACHABLE((String)"getCAstTypeFor() passed type that is not primitive, array, or class?");
            }
            super.map(astType, type);
        }
        return type;
    }

    private final class JdtJavaArrayType
    implements CAstType.Array {
        private final ITypeBinding fEltJdtType;
        private final CAstType fEltCAstType;

        private JdtJavaArrayType(ITypeBinding arrayType) {
            this.fEltJdtType = arrayType.getComponentType();
            this.fEltCAstType = JDTTypeDictionary.this.getCAstTypeFor(this.fEltJdtType);
        }

        public int getNumDimensions() {
            return 1;
        }

        public CAstType getElementType() {
            return this.fEltCAstType;
        }

        public String getName() {
            return "[" + this.fEltCAstType.getName();
        }

        public Collection<CAstType> getSupertypes() {
            if (this.fEltJdtType.isPrimitive()) {
                return Collections.singleton(JDTTypeDictionary.this.getCAstTypeFor(JDTTypeDictionary.this.fAst.resolveWellKnownType("java.lang.Object")));
            }
            assert (this.fEltJdtType.isArray() || this.fEltJdtType.isClass()) : "Non-primitive, non-reference array element type!";
            ArrayList<CAstType> supers = new ArrayList<CAstType>();
            ITypeBinding[] iTypeBindingArray = this.fEltJdtType.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding type = iTypeBindingArray[n2];
                supers.add(JDTTypeDictionary.this.getCAstTypeFor(type));
                ++n2;
            }
            if (this.fEltJdtType.getSuperclass() != null) {
                supers.add(JDTTypeDictionary.this.getCAstTypeFor(this.fEltJdtType.getSuperclass()));
            }
            return supers;
        }
    }

    public final class JdtJavaType
    implements JavaType {
        private final ITypeBinding fType;
        private Collection<CAstType> fSuperTypes = null;

        public String toString() {
            return String.valueOf(super.toString()) + ":" + this.getName();
        }

        public JdtJavaType(ITypeBinding type) {
            this.fType = type;
        }

        public String getName() {
            return JDTTypeDictionary.this.fIdentityMapper.getTypeRef(this.fType).getName().toString();
        }

        public Collection getSupertypes() {
            if (this.fSuperTypes == null) {
                this.buildSuperTypes();
            }
            return this.fSuperTypes;
        }

        private void buildSuperTypes() {
            ITypeBinding superType = this.fType.getSuperclass() == null ? JDTTypeDictionary.this.fAst.resolveWellKnownType("java.lang.Object") : this.fType.getSuperclass();
            int N = this.fType.getInterfaces().length + 1;
            this.fSuperTypes = new ArrayList<CAstType>(N);
            this.fSuperTypes.add(JDTTypeDictionary.this.getCAstTypeFor(superType));
            ITypeBinding[] iTypeBindingArray = this.fType.getInterfaces();
            int n = iTypeBindingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeBinding t = iTypeBindingArray[n2];
                this.fSuperTypes.add(JDTTypeDictionary.this.getCAstTypeFor(t));
                ++n2;
            }
        }

        public Collection<CAstQualifier> getQualifiers() {
            return JDT2CAstUtils.mapModifiersToQualifiers(this.fType.getModifiers(), this.fType.isInterface(), this.fType.isAnnotation());
        }

        public boolean isInterface() {
            return this.fType.isInterface();
        }
    }
}

