/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator.jdt;

import com.ibm.wala.analysis.typeInference.JavaPrimitiveType;
import com.ibm.wala.cast.ir.translator.AstTranslator;
import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.loader.Util;
import com.ibm.wala.cast.java.translator.JavaProcedureEntity;
import com.ibm.wala.cast.java.translator.jdt.FakeExceptionTypeBinding;
import com.ibm.wala.cast.java.translator.jdt.JDT2CAstUtils;
import com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper;
import com.ibm.wala.cast.java.translator.jdt.JDTTypeDictionary;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstAnnotation;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstNodeTypeMap;
import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.CAstType;
import com.ibm.wala.cast.tree.impl.CAstControlFlowRecorder;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.impl.CAstNodeTypeMapRecorder;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.impl.CAstSourcePositionRecorder;
import com.ibm.wala.cast.tree.impl.CAstSymbolImpl;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;

public abstract class JDTJava2CAstTranslator<T extends CAstSourcePositionMap.Position> {
    protected boolean dump = false;
    protected final CAst fFactory = new CAstImpl();
    protected final AST ast;
    protected final JDTIdentityMapper fIdentityMapper;
    protected final JDTTypeDictionary fTypeDict;
    protected final JavaSourceLoaderImpl fSourceLoader;
    protected final ITypeBinding fDivByZeroExcType = FakeExceptionTypeBinding.arithmetic;
    protected final ITypeBinding fNullPointerExcType = FakeExceptionTypeBinding.nullPointer;
    protected final ITypeBinding fClassCastExcType = FakeExceptionTypeBinding.classCast;
    protected final ITypeBinding fRuntimeExcType;
    protected final ITypeBinding NoClassDefFoundError = FakeExceptionTypeBinding.noClassDef;
    protected final ITypeBinding ExceptionInInitializerError = FakeExceptionTypeBinding.initException;
    protected final ITypeBinding OutOfMemoryError = FakeExceptionTypeBinding.outOfMemory;
    protected final TranslatorToCAst.DoLoopTranslator doLoopTranslator;
    protected final String fullPath;
    protected final CompilationUnit cu;
    private static final ArrayList<CAstQualifier> enumQuals = new ArrayList(3);

    static {
        enumQuals.add(CAstQualifier.PUBLIC);
        enumQuals.add(CAstQualifier.STATIC);
        enumQuals.add(CAstQualifier.FINAL);
    }

    public JDTJava2CAstTranslator(JavaSourceLoaderImpl sourceLoader, CompilationUnit astRoot, String fullPath, boolean replicateForDoLoops) {
        this(sourceLoader, astRoot, fullPath, replicateForDoLoops, false);
    }

    public JDTJava2CAstTranslator(JavaSourceLoaderImpl sourceLoader, CompilationUnit astRoot, String fullPath, boolean replicateForDoLoops, boolean dump) {
        this.fSourceLoader = sourceLoader;
        this.cu = astRoot;
        this.fullPath = fullPath;
        this.ast = astRoot.getAST();
        this.doLoopTranslator = new TranslatorToCAst.DoLoopTranslator(replicateForDoLoops, this.fFactory);
        this.dump = dump;
        this.fIdentityMapper = new JDTIdentityMapper(this.fSourceLoader.getReference(), this.ast);
        this.fTypeDict = new JDTTypeDictionary(this.ast, this.fIdentityMapper);
        this.fRuntimeExcType = this.ast.resolveWellKnownType("java.lang.RuntimeException");
        assert (this.fRuntimeExcType != null);
    }

    public CAstEntity translateToCAst() {
        ArrayList<CAstEntity> declEntities = new ArrayList<CAstEntity>();
        for (AbstractTypeDeclaration decl : this.cu.types()) {
            declEntities.add(this.visit(decl, (WalkContext)new RootContext()));
        }
        if (this.dump) {
            for (CAstEntity d : declEntities) {
                CAstPrinter.printTo((CAstEntity)d, (Writer)new PrintWriter(System.err));
            }
        }
        return new CompilationUnitEntity(this.cu.getPackage(), declEntities);
    }

    private boolean isInterface(AbstractTypeDeclaration decl) {
        return decl instanceof AnnotationTypeDeclaration || decl instanceof TypeDeclaration && ((TypeDeclaration)decl).isInterface();
    }

    private CAstEntity visitTypeDecl(AbstractTypeDeclaration n, WalkContext context) {
        return this.createClassDeclaration((ASTNode)n, n.bodyDeclarations(), null, n.resolveBinding(), n.getName().getIdentifier(), n.getModifiers(), this.isInterface(n), n instanceof AnnotationTypeDeclaration, context);
    }

    private CAstEntity createClassDeclaration(ASTNode n, List bodyDecls, List enumConstants, ITypeBinding typeBinding, String name, int modifiers, boolean isInterface, boolean isAnnotation, WalkContext context) {
        ArrayList<CAstEntity> memberEntities = new ArrayList<CAstEntity>();
        ArrayList<ASTNode> inits = new ArrayList<ASTNode>();
        ArrayList<ASTNode> staticInits = new ArrayList<ASTNode>();
        if (enumConstants != null) {
            for (Object decl : enumConstants) {
                EnumConstantDeclaration ecd = (EnumConstantDeclaration)decl;
                staticInits.add((ASTNode)ecd);
            }
        }
        for (Object decl : bodyDecls) {
            if (decl instanceof Initializer) {
                Initializer initializer = (Initializer)decl;
                boolean isStatic = (initializer.getModifiers() & 8) != 0;
                (isStatic ? staticInits : inits).add((ASTNode)initializer);
                continue;
            }
            if (!(decl instanceof FieldDeclaration)) continue;
            FieldDeclaration fd = (FieldDeclaration)decl;
            for (Object f : fd.fragments()) {
                VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
                if (frag.getInitializer() == null) continue;
                boolean isStatic = (fd.getModifiers() & 8) != 0;
                (isStatic ? staticInits : inits).add((ASTNode)frag);
            }
        }
        if (enumConstants != null) {
            for (Object decl : enumConstants) {
                memberEntities.add(this.visit((EnumConstantDeclaration)decl, context));
            }
        }
        for (Object d : bodyDecls) {
            BodyDeclaration decl = (BodyDeclaration)d;
            if (decl instanceof FieldDeclaration) {
                FieldDeclaration fieldDecl = (FieldDeclaration)decl;
                Collection<CAstQualifier> quals = JDT2CAstUtils.mapModifiersToQualifiers(fieldDecl.getModifiers(), false, false);
                for (Object f : fieldDecl.fragments()) {
                    VariableDeclarationFragment fieldFrag = (VariableDeclarationFragment)f;
                    IVariableBinding fieldBinding = fieldFrag.resolveBinding();
                    memberEntities.add(new FieldEntity(this, fieldFrag.getName().getIdentifier(), fieldBinding.getType(), quals, (CAstSourcePositionMap.Position)this.makePosition(fieldFrag.getStartPosition(), fieldFrag.getStartPosition() + fieldFrag.getLength()), this.handleAnnotations((IBinding)fieldBinding)));
                }
                continue;
            }
            if (decl instanceof Initializer) continue;
            if (decl instanceof MethodDeclaration) {
                MethodDeclaration metDecl = (MethodDeclaration)decl;
                if (typeBinding.isEnum() && metDecl.isConstructor()) {
                    memberEntities.add(this.createEnumConstructorWithParameters(metDecl.resolveBinding(), (ASTNode)metDecl, context, inits, metDecl));
                    continue;
                }
                memberEntities.add(this.visit(metDecl, typeBinding, context, inits));
                Collection<IMethodBinding> overriddenMets = JDT2CAstUtils.getOverriddenMethod(metDecl.resolveBinding());
                if (overriddenMets == null) continue;
                for (IMethodBinding overridden : overriddenMets) {
                    if (JDT2CAstUtils.sameErasedSignatureAndReturnType(metDecl.resolveBinding(), overridden)) continue;
                    memberEntities.add(this.makeSyntheticCovariantRedirect(metDecl, metDecl.resolveBinding(), overridden, context));
                }
                continue;
            }
            if (decl instanceof AbstractTypeDeclaration) {
                memberEntities.add(this.visit((AbstractTypeDeclaration)decl, context));
                continue;
            }
            if (decl instanceof AnnotationTypeMemberDeclaration) continue;
            Assertions.UNREACHABLE((String)"BodyDeclaration not Field, Initializer, or Method");
        }
        IMethodBinding[] metDecl = typeBinding.getDeclaredMethods();
        int decl = metDecl.length;
        int n2 = 0;
        while (n2 < decl) {
            IMethodBinding m = metDecl[n2];
            IMethodBinding met = m;
            if (met.isDefaultConstructor()) {
                if (typeBinding.isEnum()) {
                    memberEntities.add(this.createEnumConstructorWithParameters(met, n, context, inits, null));
                } else if (met.getParameterTypes().length > 0) {
                    memberEntities.add(this.createDefaultConstructorWithParameters(met, n, context, inits));
                } else {
                    memberEntities.add(this.createDefaultConstructor(name, typeBinding, context, inits, n));
                }
            }
            ++n2;
        }
        if (typeBinding.isEnum() && !typeBinding.isAnonymous()) {
            this.doEnumHiddenEntities(typeBinding, staticInits, memberEntities, context);
        }
        if (!staticInits.isEmpty()) {
            HashMap childEntities = HashMapFactory.make();
            MethodContext newContext = new MethodContext(context, childEntities);
            CAstNode[] bodyNodes = new CAstNode[staticInits.size()];
            int i = 0;
            while (i < staticInits.size()) {
                bodyNodes[i] = this.visitFieldInitNode(staticInits.get(i), newContext);
                ++i;
            }
            CAstNode staticInitAst = this.makeNode((WalkContext)newContext, this.fFactory, n, 3, bodyNodes);
            memberEntities.add((CAstEntity)new ProcedureEntity(staticInitAst, typeBinding, childEntities, newContext, null));
        }
        Collection<CAstQualifier> quals = JDT2CAstUtils.mapModifiersToQualifiers(modifiers, isInterface, isAnnotation);
        Set<CAstAnnotation> annotations = this.handleAnnotations((IBinding)typeBinding);
        return new ClassEntity(this, typeBinding, name, quals, memberEntities, this.makePosition(n), annotations);
    }

    private CAstEntity visit(AnonymousClassDeclaration n, WalkContext context) {
        return this.createClassDeclaration((ASTNode)n, n.bodyDeclarations(), null, n.resolveBinding(), JDT2CAstUtils.anonTypeName(n.resolveBinding()), 0, false, false, context);
    }

    private CAstNode visit(TypeDeclarationStatement n, WalkContext context) {
        AbstractTypeDeclaration decl = n.getDeclaration();
        assert (decl instanceof TypeDeclaration) : "Local enum declaration not yet supported";
        CAstEntity classEntity = this.visitTypeDecl((AbstractTypeDeclaration)((TypeDeclaration)decl), context);
        CAstNode lcdNode = this.makeNode(context, this.fFactory, (ASTNode)n, 19);
        context.addScopedEntity(lcdNode, classEntity);
        return lcdNode;
    }

    private CAstEntity createDefaultConstructorWithParameters(IMethodBinding ctor, ASTNode n, WalkContext oldContext, ArrayList<ASTNode> inits) {
        ITypeBinding newType = ctor.getDeclaringClass();
        ITypeBinding superType = newType.getSuperclass();
        IMethodBinding superCtor = null;
        IMethodBinding[] iMethodBindingArray = superType.getDeclaredMethods();
        int n2 = iMethodBindingArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IMethodBinding m = iMethodBindingArray[n3];
            if (m.isConstructor() && Arrays.equals(m.getParameterTypes(), ctor.getParameterTypes())) {
                superCtor = m;
            }
            ++n3;
        }
        assert (superCtor != null) : "couldn't find constructor for anonymous class";
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        MethodDeclaration fakeCtor = this.ast.newMethodDeclaration();
        fakeCtor.setConstructor(true);
        fakeCtor.setSourceRange(n.getStartPosition(), n.getLength());
        fakeCtor.setBody(this.ast.newBlock());
        String[] fakeArguments = new String[superCtor.getParameterTypes().length + 1];
        ArrayList<CAstType> paramTypes = new ArrayList<CAstType>(superCtor.getParameterTypes().length);
        int i = 0;
        while (i < fakeArguments.length) {
            fakeArguments[i] = i == 0 ? "this" : "argument" + i;
            ++i;
        }
        i = 1;
        while (i < fakeArguments.length) {
            SingleVariableDeclaration svd = this.ast.newSingleVariableDeclaration();
            svd.setName(this.ast.newSimpleName(fakeArguments[i]));
            fakeCtor.parameters().add(svd);
            paramTypes.add(this.fTypeDict.getCAstTypeFor(ctor.getParameterTypes()[i - 1]));
            ++i;
        }
        CAstNode[] bodyNodes = new CAstNode[inits.size() + 1];
        CAstNode[] children = new CAstNode[fakeArguments.length + 1];
        children[0] = this.makeNode(context, this.fFactory, n, 115);
        CallSiteReference callSiteRef = CallSiteReference.make((int)0, (MethodReference)this.fIdentityMapper.getMethodRef(superCtor), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        children[1] = this.fFactory.makeConstant((Object)callSiteRef);
        int i2 = 1;
        while (i2 < fakeArguments.length) {
            CAstNode argName = this.fFactory.makeConstant((Object)fakeArguments[i2]);
            CAstNode argType = this.fFactory.makeConstant(paramTypes.get(i2 - 1));
            children[i2 + 1] = this.makeNode(context, this.fFactory, n, 111, argName, argType);
            ++i2;
        }
        bodyNodes[0] = this.makeNode((WalkContext)context, this.fFactory, n, 102, children);
        i2 = 0;
        while (i2 < inits.size()) {
            bodyNodes[i2 + 1] = this.visitFieldInitNode(inits.get(i2), context);
            ++i2;
        }
        CAstNode ast = this.makeNode((WalkContext)context, this.fFactory, n, 3, bodyNodes);
        return new ProcedureEntity(ast, fakeCtor, newType, memberEntities, context, paramTypes, null, null);
    }

    private CAstEntity createDefaultConstructor(String className, ITypeBinding classBinding, WalkContext oldContext, ArrayList<ASTNode> inits, ASTNode positioningNode) {
        MethodDeclaration fakeCtor = this.ast.newMethodDeclaration();
        fakeCtor.setConstructor(true);
        fakeCtor.setSourceRange(positioningNode.getStartPosition(), positioningNode.getLength());
        fakeCtor.setBody(this.ast.newBlock());
        return this.visit(fakeCtor, classBinding, oldContext, inits);
    }

    private IMethodBinding findDefaultCtor(ITypeBinding superClass) {
        IMethodBinding[] iMethodBindingArray = superClass.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding met = iMethodBindingArray[n2];
            if (met.isConstructor() && met.getParameterTypes().length == 0) {
                return met;
            }
            ++n2;
        }
        Assertions.UNREACHABLE((String)"Couldn't find default ctor");
        return null;
    }

    private CAstNode createConstructorBody(MethodDeclaration n, ITypeBinding classBinding, WalkContext context, ArrayList<ASTNode> inits) {
        Statement firstStatement = null;
        if (!n.getBody().statements().isEmpty()) {
            firstStatement = (Statement)n.getBody().statements().get(0);
        }
        if (firstStatement instanceof SuperConstructorInvocation) {
            ArrayList<CAstNode> origStatements = this.createBlock(n.getBody(), context);
            CAstNode[] bodyNodes = new CAstNode[inits.size() + origStatements.size()];
            int idx = 0;
            bodyNodes[idx++] = origStatements.get(0);
            for (ASTNode init : inits) {
                bodyNodes[idx++] = this.visitFieldInitNode(init, context);
            }
            int i = 1;
            while (i < origStatements.size()) {
                bodyNodes[idx++] = origStatements.get(i);
                ++i;
            }
            return this.makeNode(context, this.fFactory, (ASTNode)n.getBody(), 3, bodyNodes);
        }
        if (firstStatement instanceof ConstructorInvocation) {
            return this.visitNode((ASTNode)n.getBody(), context);
        }
        ITypeBinding superType = classBinding.getSuperclass();
        IMethodBinding defaultSuperCtor = this.findDefaultCtor(superType);
        CallSiteReference callSiteRef = CallSiteReference.make((int)0, (MethodReference)this.fIdentityMapper.getMethodRef(defaultSuperCtor), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        CAstNode superCall = this.makeNode(context, this.fFactory, (ASTNode)n.getBody(), 102, this.makeNode(context, this.fFactory, (ASTNode)n.getBody(), 115), this.fFactory.makeConstant((Object)callSiteRef));
        Object mapper = new Object();
        this.handleThrowsFromCall(defaultSuperCtor, mapper, context);
        context.cfg().map(mapper, superCall);
        ArrayList<CAstNode> origStatements = this.createBlock(n.getBody(), context);
        CAstNode[] bodyNodes = new CAstNode[inits.size() + origStatements.size() + 1];
        int idx = 0;
        bodyNodes[idx++] = superCall;
        for (ASTNode init : inits) {
            bodyNodes[idx++] = this.visitFieldInitNode(init, context);
        }
        int i = 0;
        while (i < origStatements.size()) {
            bodyNodes[idx++] = origStatements.get(i);
            ++i;
        }
        return this.makeNode(context, this.fFactory, (ASTNode)n.getBody(), 3, bodyNodes);
    }

    private CAstEntity makeSyntheticCovariantRedirect(MethodDeclaration overriding, IMethodBinding overridingBinding, IMethodBinding overridden, WalkContext oldContext) {
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        CAstNode calltarget = (overridingBinding.getModifiers() & 8) == 0 ? this.makeNode(context, this.fFactory, null, 115) : this.makeNode(context, this.fFactory, null, 402);
        ITypeBinding[] paramTypes = overridden.getParameterTypes();
        ArrayList<CAstNode> arguments = new ArrayList<CAstNode>();
        int i = 0;
        for (Object o : overriding.parameters()) {
            ITypeBinding toType;
            SingleVariableDeclaration svd = (SingleVariableDeclaration)o;
            CAstNode varNode = this.makeNode((WalkContext)context, this.fFactory, null, 111, this.fFactory.makeConstant((Object)svd.getName().getIdentifier()));
            ITypeBinding fromType = JDT2CAstUtils.getErasedType(paramTypes[i], this.ast);
            if (fromType.equals((Object)(toType = JDT2CAstUtils.getErasedType(overridingBinding.getParameterTypes()[i], this.ast)))) {
                arguments.add(varNode);
            } else {
                arguments.add(this.createCast(null, varNode, fromType, toType, context));
            }
            ++i;
        }
        CAstNode callnode = this.createMethodInvocation(null, overridingBinding, calltarget, arguments, context);
        CAstNode mdast = this.makeNode((WalkContext)context, this.fFactory, null, 200, this.makeNode((WalkContext)context, this.fFactory, null, 3, this.makeNode((WalkContext)context, this.fFactory, null, 7, callnode)));
        ArrayList<CAstType> paramCAstTypes = new ArrayList<CAstType>(overridden.getParameterTypes().length);
        ITypeBinding[] iTypeBindingArray = overridden.getParameterTypes();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding paramType = iTypeBindingArray[n2];
            paramCAstTypes.add(this.fTypeDict.getCAstTypeFor(paramType));
            ++n2;
        }
        return new ProcedureEntity(mdast, overriding, overridingBinding.getDeclaringClass(), memberEntities, context, paramCAstTypes, overridden.getReturnType(), null);
    }

    private CAstEntity visit(MethodDeclaration n, ITypeBinding classBinding, WalkContext oldContext, ArrayList<ASTNode> inits) {
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        Object mdast = n.isConstructor() ? this.createConstructorBody(n, classBinding, context, inits) : ((n.getModifiers() & 0x400) != 0 ? null : (n.getBody() == null || n.getBody().statements().size() == 0 ? this.makeNode(context, this.fFactory, (ASTNode)n, 7) : this.visitNode((ASTNode)n.getBody(), context)));
        Set<CAstAnnotation> annotations = null;
        if (n.resolveBinding() != null) {
            annotations = this.handleAnnotations((IBinding)n.resolveBinding());
        }
        return new ProcedureEntity((CAstNode)mdast, n, classBinding, memberEntities, context, annotations);
    }

    private Set<CAstAnnotation> handleAnnotations(IBinding binding) {
        IAnnotationBinding[] annotations = binding.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        HashSet castAnnotations = HashSetFactory.make();
        IAnnotationBinding[] iAnnotationBindingArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotation = iAnnotationBindingArray[n2];
            ITypeBinding annotationTypeBinding = annotation.getAnnotationType();
            final CAstType annotationType = this.fTypeDict.getCAstTypeFor(annotationTypeBinding);
            final HashMap args = HashMapFactory.make();
            IMemberValuePairBinding[] iMemberValuePairBindingArray = annotation.getAllMemberValuePairs();
            int n3 = iMemberValuePairBindingArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemberValuePairBinding mvpb = iMemberValuePairBindingArray[n4];
                String name = mvpb.getName();
                Object value = mvpb.getValue();
                args.put(name, value);
                ++n4;
            }
            castAnnotations.add(new CAstAnnotation(){

                public CAstType getType() {
                    return annotationType;
                }

                public Map<String, Object> getArguments() {
                    return args;
                }

                public String toString() {
                    return String.valueOf(annotationType.getName()) + args;
                }
            });
            ++n2;
        }
        return castAnnotations;
    }

    private CAstNode visitFieldInitNode(ASTNode node, WalkContext context) {
        if (node instanceof Initializer) {
            return this.visitNode((ASTNode)((Initializer)node).getBody(), context);
        }
        if (node instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment f = (VariableDeclarationFragment)node;
            FieldReference fieldRef = this.fIdentityMapper.getFieldRef(f.resolveBinding());
            boolean isStatic = (f.resolveBinding().getModifiers() & 8) != 0;
            CAstNode thisNode = isStatic ? this.makeNode(context, this.fFactory, null, 402) : this.makeNode(context, this.fFactory, (ASTNode)f, 116);
            CAstNode lhsNode = this.makeNode(context, this.fFactory, (ASTNode)f, 112, thisNode, this.fFactory.makeConstant((Object)fieldRef));
            Expression init = f.getInitializer();
            CAstNode rhsNode = this.visitNode((ASTNode)init, context);
            CAstNode assNode = this.makeNode(context, this.fFactory, (ASTNode)f, 14, lhsNode, rhsNode);
            return assNode;
        }
        if (node instanceof EnumConstantDeclaration) {
            return this.createEnumConstantDeclarationInit((EnumConstantDeclaration)node, context);
        }
        Assertions.UNREACHABLE((String)"invalid init node gathered by createClassDeclaration");
        return null;
    }

    private ArrayList<CAstNode> createBlock(Block n, WalkContext context) {
        ArrayList<CAstNode> stmtNodes = new ArrayList<CAstNode>();
        for (Object s : n.statements()) {
            this.visitNodeOrNodes((ASTNode)s, context, stmtNodes);
        }
        return stmtNodes;
    }

    private CAstNode visit(Block n, WalkContext context) {
        ArrayList<CAstNode> stmtNodes = this.createBlock(n, context);
        CAstNode[] stmtNodesArray = stmtNodes.toArray(new CAstNode[stmtNodes.size()]);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, stmtNodesArray));
    }

    private CAstNode visit(VariableDeclarationFragment n, WalkContext context) {
        boolean isFinal;
        int modifiers = n.getParent() instanceof VariableDeclarationStatement ? ((VariableDeclarationStatement)n.getParent()).getModifiers() : (n.getParent() instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)n.getParent()).getModifiers() : ((FieldDeclaration)n.getParent()).getModifiers());
        boolean bl = isFinal = (modifiers & 0x10) != 0;
        assert (n.resolveBinding() != null) : n;
        ITypeBinding type = n.resolveBinding().getType();
        Expression init = n.getInitializer();
        String t = type.getBinaryName();
        CAstNode initNode = init == null ? (JDT2CAstUtils.isLongOrLess(type) ? this.fFactory.makeConstant(0) : (t.equals("D") || t.equals("F") ? this.fFactory.makeConstant(0.0) : this.fFactory.makeConstant(null))) : this.visitNode((ASTNode)init, context);
        Object defaultValue = JDT2CAstUtils.defaultValueForType(type);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new CAstSymbolImpl(n.getName().getIdentifier(), this.fTypeDict.getCAstTypeFor(type), isFinal, defaultValue)), initNode);
    }

    private ArrayList<CAstNode> visit(VariableDeclarationStatement n, WalkContext context) {
        ArrayList<CAstNode> result = new ArrayList<CAstNode>();
        for (Object o : n.fragments()) {
            result.add(this.visit((VariableDeclarationFragment)o, context));
        }
        return result;
    }

    private CAstNode visit(ArrayInitializer n, WalkContext context) {
        ITypeBinding type = n.resolveTypeBinding();
        assert (type != null) : "Could not determine type of ArrayInitializer";
        TypeReference newTypeRef = this.fIdentityMapper.getTypeRef(type);
        CAstNode[] eltNodes = new CAstNode[n.expressions().size() + 1];
        int idx = 0;
        eltNodes[idx++] = this.makeNode(context, this.fFactory, (ASTNode)n, 109, this.fFactory.makeConstant((Object)newTypeRef), this.fFactory.makeConstant(n.expressions().size()));
        for (Expression element : n.expressions()) {
            eltNodes[idx] = this.visitNode((ASTNode)element, context);
            if (eltNodes[idx] == null) assert (eltNodes[idx] != null) : element.toString();
            ++idx;
        }
        return this.makeNode(context, this.fFactory, (ASTNode)n, 117, eltNodes);
    }

    private CAstNode visit(ClassInstanceCreation n, WalkContext context) {
        return this.createClassInstanceCreation((ASTNode)n, n.arguments(), n.resolveConstructorBinding(), n.getExpression(), n.getAnonymousClassDeclaration(), context);
    }

    private CAstNode createClassInstanceCreation(ASTNode nn, List arguments, IMethodBinding ctorBinding, Expression qual, AnonymousClassDeclaration anonDecl, WalkContext context) {
        ctorBinding = ctorBinding.getMethodDeclaration();
        MethodReference ctorRef = this.fIdentityMapper.getMethodRef(ctorBinding);
        ITypeBinding newType = ctorBinding.getDeclaringClass();
        TypeReference newTypeRef = this.fIdentityMapper.getTypeRef(newType);
        CAstNode qualNode = null;
        if (qual == null && newType.getDeclaringClass() != null && (newType.getModifiers() & 8) == 0 && !newType.isLocal()) {
            ITypeBinding plainThisType = JDT2CAstUtils.getDeclaringClassOfNode(nn);
            ITypeBinding implicitThisType = this.findClosestEnclosingClassSubclassOf(plainThisType, newType.getDeclaringClass(), (newType.getModifiers() & 2) != 0);
            qualNode = implicitThisType.isEqualTo((IBinding)plainThisType) ? this.makeNode(context, this.fFactory, nn, 116) : this.makeNode(context, this.fFactory, nn, 116, this.fFactory.makeConstant((Object)this.fIdentityMapper.getTypeRef(implicitThisType)));
        } else if (qual != null) {
            qualNode = this.visitNode((ASTNode)qual, context);
        }
        CAstNode newNode = qualNode != null ? this.makeNode(context, this.fFactory, nn, 131, this.fFactory.makeConstant((Object)newTypeRef), qualNode) : this.makeNode(context, this.fFactory, nn, 109, this.fFactory.makeConstant((Object)newTypeRef));
        ITypeBinding[] newExceptions = new ITypeBinding[]{this.NoClassDefFoundError, this.ExceptionInInitializerError, this.OutOfMemoryError};
        context.cfg().map((Object)newNode, newNode);
        ITypeBinding[] iTypeBindingArray = newExceptions;
        int n = newExceptions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding exp = iTypeBindingArray[n2];
            for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(exp)) {
                context.cfg().add((Object)newNode, catchTarget.snd, catchTarget.fst);
            }
            ++n2;
        }
        if (anonDecl != null) {
            context.addScopedEntity(newNode, this.visit(anonDecl, context));
        }
        CAstNode[] argNodes = new CAstNode[arguments.size() + 2];
        int idx = 0;
        argNodes[idx++] = this.makeNode(context, this.fFactory, nn, 111, this.fFactory.makeConstant((Object)"ctor temp"), this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(newType)));
        int dummyPC = 0;
        CallSiteReference callSiteRef = CallSiteReference.make((int)dummyPC, (MethodReference)ctorRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        argNodes[idx++] = this.fFactory.makeConstant((Object)callSiteRef);
        for (Object arg : arguments) {
            CAstNode cAstNode = argNodes[idx++] = arg instanceof CAstNode ? (CAstNode)arg : this.visitNode((ASTNode)((Expression)arg), context);
        }
        CAstNode callNode = this.makeNode(context, this.fFactory, nn, 102, argNodes);
        context.cfg().map((Object)nn, callNode);
        this.handleThrowsFromCall(ctorBinding, nn, context);
        return this.makeNode(context, this.fFactory, nn, 200, this.makeNode(context, this.fFactory, nn, 104, this.makeNode(context, this.fFactory, nn, 6, this.fFactory.makeConstant((Object)new AstTranslator.InternalCAstSymbol("ctor temp", this.fTypeDict.getCAstTypeFor(newType), true)), newNode), callNode, this.makeNode(context, this.fFactory, nn, 111, this.fFactory.makeConstant((Object)"ctor temp"))));
    }

    private void handleThrowsFromCall(IMethodBinding met, Object mappedAstNode, WalkContext context) {
        ITypeBinding[] throwTypes;
        ITypeBinding[] iTypeBindingArray = throwTypes = met.getExceptionTypes();
        int n = throwTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding thrownType = iTypeBindingArray[n2];
            Collection<Pair<ITypeBinding, Object>> catchTargets = context.getCatchTargets(thrownType);
            for (Pair<ITypeBinding, Object> catchTarget : catchTargets) {
                context.cfg().add(mappedAstNode, catchTarget.snd, catchTarget.fst);
            }
            ++n2;
        }
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fRuntimeExcType)) {
            context.cfg().add(mappedAstNode, catchTarget.snd, catchTarget.fst);
        }
    }

    private CAstNode visit(ExpressionStatement n, WalkContext context) {
        return this.visitNode((ASTNode)n.getExpression(), context);
    }

    private CAstNode visit(SuperMethodInvocation n, WalkContext context) {
        CAstNode target;
        if (n.getQualifier() == null) {
            target = this.makeNode(context, this.fFactory, (ASTNode)n, 115);
        } else {
            TypeReference owningTypeRef = this.fIdentityMapper.getTypeRef(n.getQualifier().resolveTypeBinding());
            target = this.makeNode(context, this.fFactory, (ASTNode)n, 115, this.fFactory.makeConstant((Object)owningTypeRef));
        }
        return this.createMethodInvocation((ASTNode)n, n.resolveMethodBinding().getMethodDeclaration(), target, n.arguments(), context);
    }

    private CAstNode visit(MethodInvocation n, WalkContext context) {
        ITypeBinding fromtype;
        ITypeBinding realtype;
        CAstNode target;
        IMethodBinding binding = n.resolveMethodBinding().getMethodDeclaration();
        if ((binding.getModifiers() & 8) != 0) {
            CAstNode target2 = this.visitNode((ASTNode)n.getExpression(), context);
            if (target2.getKind() == 19 || target2.getKind() == 116) {
                return this.createMethodInvocation((ASTNode)n, binding, this.makeNode(context, this.fFactory, null, 402), n.arguments(), context);
            }
            return this.makeNode(context, this.fFactory, (ASTNode)n, 104, target2, this.createMethodInvocation((ASTNode)n, binding, this.makeNode(context, this.fFactory, null, 402), n.arguments(), context));
        }
        if (n.getExpression() != null) {
            target = this.visitNode((ASTNode)n.getExpression(), context);
        } else {
            ITypeBinding typeOfThis = JDT2CAstUtils.getDeclaringClassOfNode((ASTNode)n);
            boolean methodIsPrivate = (binding.getModifiers() & 2) != 0;
            ITypeBinding implicitThisClass = this.findClosestEnclosingClassSubclassOf(typeOfThis, binding.getDeclaringClass(), methodIsPrivate);
            target = typeOfThis.isEqualTo((IBinding)implicitThisClass) ? this.makeNode(context, this.fFactory, (ASTNode)n, 116) : this.makeNode(context, this.fFactory, (ASTNode)n, 116, this.fFactory.makeConstant((Object)this.fIdentityMapper.getTypeRef(implicitThisClass)));
        }
        CAstNode node = this.createMethodInvocation((ASTNode)n, binding, target, n.arguments(), context);
        if (binding.getReturnType().isTypeVariable() && !(realtype = JDT2CAstUtils.getErasedType(n.resolveMethodBinding().getReturnType(), this.ast)).isEqualTo((IBinding)(fromtype = JDT2CAstUtils.getTypesVariablesBase(binding.getReturnType(), this.ast)))) {
            return this.createCast((ASTNode)n, node, fromtype, realtype, context);
        }
        return node;
    }

    private CAstNode createMethodInvocation(ASTNode pos, IMethodBinding methodBinding, CAstNode target, List arguments, WalkContext context) {
        boolean isStatic = (methodBinding.getModifiers() & 8) != 0;
        ITypeBinding methodOwner = methodBinding.getDeclaringClass();
        if (!methodOwner.isInterface() && !methodOwner.isClass() && !methodOwner.isEnum()) assert (false) : "owner " + methodOwner + " of " + methodBinding + " is not a class";
        int nFormals = methodBinding.getParameterTypes().length;
        CAstNode[] children = new CAstNode[2 + nFormals];
        assert (target != null) : "no receiver for " + methodBinding;
        children[0] = target;
        IInvokeInstruction.Dispatch dispatchType = isStatic ? IInvokeInstruction.Dispatch.STATIC : (methodOwner.isInterface() ? IInvokeInstruction.Dispatch.INTERFACE : ((methodBinding.getModifiers() & 2) != 0 || target.getKind() == 115 ? IInvokeInstruction.Dispatch.SPECIAL : IInvokeInstruction.Dispatch.VIRTUAL));
        CallSiteReference callSiteRef = CallSiteReference.make((int)0, (MethodReference)this.fIdentityMapper.getMethodRef(methodBinding), (IInvokeInstruction.IDispatch)dispatchType);
        children[1] = this.fFactory.makeConstant((Object)callSiteRef);
        this.populateArguments(children, methodBinding, arguments, context);
        Object fakeCfgMap = new Object();
        this.handleThrowsFromCall(methodBinding, fakeCfgMap, context);
        CAstNode result = this.makeNode(context, this.fFactory, pos, 102, children);
        context.cfg().map(fakeCfgMap, result);
        return result;
    }

    private void populateArguments(CAstNode[] children, IMethodBinding methodBinding, List arguments, WalkContext context) {
        int nFormals = methodBinding.getParameterTypes().length;
        assert (children.length == nFormals + 2);
        int nActuals = arguments.size();
        ITypeBinding lastArgType = null;
        if (nActuals > 0 && arguments.get(nActuals - 1) instanceof Expression) {
            lastArgType = ((Expression)arguments.get(nActuals - 1)).resolveTypeBinding();
        }
        if (nActuals == nFormals && (!methodBinding.isVarargs() || lastArgType == null || lastArgType.isSubTypeCompatible(methodBinding.getParameterTypes()[nFormals - 1]))) {
            int i = 2;
            for (Object arg : arguments) {
                CAstNode cAstNode = children[i++] = arg instanceof CAstNode ? (CAstNode)arg : this.visitNode((ASTNode)((Expression)arg), context);
            }
        } else {
            assert (nActuals >= nFormals - 1 && methodBinding.isVarargs()) : "Invalid number of parameters for constructor call";
            int i = 0;
            while (i < nFormals - 1) {
                Object arg = arguments.get(i);
                children[i + 2] = arg instanceof CAstNode ? (CAstNode)arg : this.visitNode((ASTNode)((Expression)arg), context);
                ++i;
            }
            CAstNode[] subargs = new CAstNode[nActuals - nFormals + 2];
            TypeReference newTypeRef = this.fIdentityMapper.getTypeRef(methodBinding.getParameterTypes()[nFormals - 1]);
            subargs[0] = this.makeNode(context, this.fFactory, null, 109, this.fFactory.makeConstant((Object)newTypeRef), this.fFactory.makeConstant(subargs.length - 1));
            int j = 1;
            while (j < subargs.length) {
                Object arg = arguments.get(j + nFormals - 2);
                subargs[j] = arg instanceof CAstNode ? (CAstNode)arg : this.visitNode((ASTNode)((Expression)arg), context);
                ++j;
            }
            children[nFormals + 1] = this.makeNode(context, this.fFactory, null, 117, subargs);
        }
    }

    private CAstNode visit(ReturnStatement r, WalkContext context) {
        Expression retExpr = r.getExpression();
        if (retExpr == null) {
            return this.makeNode(context, this.fFactory, (ASTNode)r, 7);
        }
        return this.makeNode(context, this.fFactory, (ASTNode)r, 7, this.visitNode((ASTNode)retExpr, context));
    }

    private CAstNode visit(Assignment n, WalkContext context) {
        if (n.getOperator() == Assignment.Operator.ASSIGN) {
            return this.makeNode(context, this.fFactory, (ASTNode)n, 14, this.visitNode((ASTNode)n.getLeftHandSide(), new AssignmentContext(context)), this.visitNode((ASTNode)n.getRightHandSide(), context));
        }
        CAstNode left = this.visitNode((ASTNode)n.getLeftHandSide(), context);
        if (left.getKind() == 118) {
            return this.doFunkyGenericAssignPreOpHack(n, context);
        }
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)n, 15, left, this.visitNode((ASTNode)n.getRightHandSide(), context), (CAstNode)JDT2CAstUtils.mapAssignOperator(n.getOperator()));
        if (JDT2CAstUtils.isLongOrLess(n.resolveTypeBinding()) && (n.getOperator() == Assignment.Operator.DIVIDE_ASSIGN || n.getOperator() == Assignment.Operator.REMAINDER_ASSIGN)) {
            Collection<Pair<ITypeBinding, Object>> excTargets = context.getCatchTargets(this.fDivByZeroExcType);
            if (!excTargets.isEmpty()) {
                for (Pair<ITypeBinding, Object> catchPair : excTargets) {
                    context.cfg().add((Object)result, catchPair.snd, (Object)this.fDivByZeroExcType);
                }
            } else {
                context.cfg().add((Object)result, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)this.fDivByZeroExcType);
            }
        }
        return result;
    }

    private CAstNode doFunkyGenericAssignPreOpHack(Assignment assign, WalkContext context) {
        Expression left = assign.getLeftHandSide();
        Expression right = assign.getRightHandSide();
        while (left instanceof ParenthesizedExpression) {
            left = ((ParenthesizedExpression)left).getExpression();
        }
        assert (left instanceof FieldAccess) : "Cast in assign pre-op but no field access?!";
        FieldAccess field = (FieldAccess)left;
        InfixExpression.Operator infixop = JDT2CAstUtils.mapAssignOperatorToInfixOperator(assign.getOperator());
        CAstNode exprNode = this.visitNode((ASTNode)field.getExpression(), context);
        CAstNode tmpDeclNode = this.makeNode(context, this.fFactory, (ASTNode)left, 6, this.fFactory.makeConstant((Object)new AstTranslator.InternalCAstSymbol("temp generic preop hack", this.fTypeDict.getCAstTypeFor(field.getExpression().resolveTypeBinding()), true)), exprNode);
        CAstNode obref1 = this.createFieldAccess(this.makeNode(context, this.fFactory, (ASTNode)left, 111, this.fFactory.makeConstant((Object)"temp generic preop hack"), this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(field.resolveFieldBinding().getType()))), field.getName().getIdentifier(), field.resolveFieldBinding(), (ASTNode)left, new AssignmentContext(context));
        CAstNode obref2 = this.createFieldAccess(this.makeNode(context, this.fFactory, (ASTNode)left, 111, this.fFactory.makeConstant((Object)"temp generic preop hack"), this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(field.resolveFieldBinding().getType()))), field.getName().getIdentifier(), field.resolveFieldBinding(), (ASTNode)left, context);
        ITypeBinding realtype = JDT2CAstUtils.getErasedType(field.resolveFieldBinding().getType(), this.ast);
        ITypeBinding fromtype = JDT2CAstUtils.getTypesVariablesBase(field.resolveFieldBinding().getVariableDeclaration().getType(), this.ast);
        CAstNode castedObref = obref2;
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)assign, 200, this.makeNode(context, this.fFactory, (ASTNode)assign, 104, tmpDeclNode, this.makeNode(context, this.fFactory, (ASTNode)assign, 14, obref1, this.createInfixExpression(infixop, realtype, left.getStartPosition(), left.getLength(), castedObref, right, context))));
        return this.createCast((ASTNode)assign, result, fromtype, realtype, context);
    }

    private CAstNode visit(ParenthesizedExpression n, WalkContext context) {
        return this.visitNode((ASTNode)n.getExpression(), context);
    }

    private CAstNode visit(BooleanLiteral n, WalkContext context) {
        return this.fFactory.makeConstant(n.booleanValue());
    }

    private CAstNode visit(CharacterLiteral n, WalkContext context) {
        return this.fFactory.makeConstant(n.charValue());
    }

    private CAstNode visit(NullLiteral n, WalkContext context) {
        return this.fFactory.makeConstant(null);
    }

    private CAstNode visit(StringLiteral n, WalkContext context) {
        return this.fFactory.makeConstant((Object)n.getLiteralValue());
    }

    private CAstNode visit(TypeLiteral n, WalkContext context) {
        String typeName = this.fIdentityMapper.typeToTypeID(n.resolveTypeBinding());
        return this.makeNode(context, this.fFactory, (ASTNode)n, 127, this.fFactory.makeConstant((Object)typeName));
    }

    private CAstNode visit(NumberLiteral n, WalkContext context) {
        return this.fFactory.makeConstant(n.resolveConstantExpressionValue());
    }

    private CAstNode visit(SimpleName n, WalkContext context) {
        if (n.resolveBinding() instanceof ITypeBinding) {
            return this.makeNode(context, this.fFactory, null, 19);
        }
        assert (n.resolveBinding() instanceof IVariableBinding) : "SimpleName's binding, " + n.resolveBinding() + ", is not a variable or a type binding!";
        IVariableBinding binding = (IVariableBinding)n.resolveBinding();
        if ((binding = binding.getVariableDeclaration()).isField()) {
            CAstNode targetNode;
            if ((binding.getModifiers() & 8) != 0) {
                targetNode = this.makeNode(context, this.fFactory, null, 19);
            } else {
                ITypeBinding typeOfThis = JDT2CAstUtils.getDeclaringClassOfNode((ASTNode)n);
                boolean fieldIsPrivate = (binding.getModifiers() & 2) != 0;
                ITypeBinding implicitThisClass = this.findClosestEnclosingClassSubclassOf(typeOfThis, binding.getDeclaringClass(), fieldIsPrivate);
                targetNode = typeOfThis.isEqualTo((IBinding)implicitThisClass) ? this.makeNode(context, this.fFactory, (ASTNode)n, 116) : this.makeNode(context, this.fFactory, (ASTNode)n, 116, this.fFactory.makeConstant((Object)this.fIdentityMapper.getTypeRef(implicitThisClass)));
            }
            return this.createFieldAccess(targetNode, n.getIdentifier(), binding, (ASTNode)n, context);
        }
        CAstType t = this.fTypeDict.getCAstTypeFor(((IVariableBinding)n.resolveBinding()).getType());
        return this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)n.getIdentifier()), this.fFactory.makeConstant((Object)t));
    }

    private ITypeBinding findClosestEnclosingClassSubclassOf(ITypeBinding typeOfThis, ITypeBinding owningType, boolean isPrivate) {
        owningType = owningType.getErasure();
        ITypeBinding current = typeOfThis;
        while (current != null) {
            current = current.getErasure();
            boolean isInSubtype = false;
            ITypeBinding supertp = current;
            while (supertp != null) {
                if ((supertp = supertp.getErasure()).isSubTypeCompatible(owningType)) {
                    isInSubtype = true;
                    break;
                }
                supertp = supertp.getSuperclass();
            }
            if (current.isEqualTo((IBinding)owningType) || isInSubtype && !isPrivate) {
                return current;
            }
            current = current.getDeclaringClass();
        }
        Assertions.UNREACHABLE((String)"Couldn't find field in class or enclosing class or superclasses of these");
        return null;
    }

    private CAstNode visit(FieldAccess n, WalkContext context) {
        CAstNode targetNode = this.visitNode((ASTNode)n.getExpression(), context);
        return this.createFieldAccess(targetNode, n.getName().getIdentifier(), n.resolveFieldBinding(), (ASTNode)n, context);
    }

    private CAstNode createFieldAccess(CAstNode targetNode, String fieldName, IVariableBinding possiblyParameterizedBinding, ASTNode positioningNode, WalkContext context) {
        ITypeBinding fromtype;
        ITypeBinding realtype;
        IVariableBinding fieldBinding = possiblyParameterizedBinding.getVariableDeclaration();
        ITypeBinding targetType = fieldBinding.getDeclaringClass();
        if (targetType == null) {
            assert (fieldName.equals("length")) : "null targetType but not aray length access";
            return this.makeNode(context, this.fFactory, positioningNode, 121, targetNode);
        }
        assert (fieldBinding.isField()) : "Field binding is not a field?!";
        FieldReference fieldRef = this.fIdentityMapper.getFieldRef(fieldBinding);
        if ((fieldBinding.getModifiers() & 8) != 0) {
            if (fieldBinding.getConstantValue() != null) {
                return this.makeNode(context, this.fFactory, positioningNode, 104, targetNode, this.fFactory.makeConstant(fieldBinding.getConstantValue()));
            }
            return this.makeNode(context, this.fFactory, positioningNode, 104, targetNode, this.makeNode(context, this.fFactory, positioningNode, 112, this.makeNode(context, this.fFactory, null, 402), this.fFactory.makeConstant((Object)fieldRef)));
        }
        CAstNode refNode = this.makeNode(context, this.fFactory, positioningNode, 112, targetNode, this.fFactory.makeConstant((Object)fieldRef));
        if (targetNode.getKind() != 116) {
            Collection<Pair<ITypeBinding, Object>> excTargets = context.getCatchTargets(this.fNullPointerExcType);
            if (!excTargets.isEmpty()) {
                for (Pair<ITypeBinding, Object> catchPair : excTargets) {
                    context.cfg().add((Object)refNode, catchPair.snd, (Object)this.fNullPointerExcType);
                }
            } else {
                context.cfg().add((Object)refNode, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)this.fNullPointerExcType);
            }
            context.cfg().map((Object)refNode, refNode);
        }
        if (fieldBinding.getConstantValue() != null) {
            return this.makeNode(context, this.fFactory, positioningNode, 104, refNode, this.fFactory.makeConstant(fieldBinding.getConstantValue()));
        }
        if (fieldBinding.getType().isTypeVariable() && !context.needLValue() && !(realtype = JDT2CAstUtils.getErasedType(possiblyParameterizedBinding.getType(), this.ast)).isEqualTo((IBinding)(fromtype = JDT2CAstUtils.getTypesVariablesBase(fieldBinding.getType(), this.ast)))) {
            return this.createCast(positioningNode, refNode, fromtype, realtype, context);
        }
        return refNode;
    }

    private CAstNode visit(ThisExpression n, WalkContext context) {
        if (n.getQualifier() != null) {
            ITypeBinding owningType = n.getQualifier().resolveTypeBinding();
            TypeReference owningTypeRef = this.fIdentityMapper.getTypeRef(owningType);
            return this.makeNode(context, this.fFactory, (ASTNode)n, 116, this.fFactory.makeConstant((Object)owningTypeRef));
        }
        return this.makeNode(context, this.fFactory, (ASTNode)n, 116);
    }

    private CAstNode visit(QualifiedName n, WalkContext context) {
        if (n.resolveBinding() instanceof IVariableBinding) {
            IVariableBinding binding = (IVariableBinding)n.resolveBinding();
            assert (binding.isField()) : "Non-field variable QualifiedName!";
            return this.createFieldAccess(this.visitNode((ASTNode)n.getQualifier(), context), n.getName().getIdentifier(), binding, (ASTNode)n, context);
        }
        return this.makeNode(context, this.fFactory, null, 19);
    }

    private CAstNode visit(InfixExpression n, WalkContext context) {
        Expression left = n.getLeftOperand();
        ITypeBinding leftType = left.resolveTypeBinding();
        int leftStartPosition = left.getStartPosition();
        CAstNode leftNode = this.visitNode((ASTNode)left, context);
        int leftLength = n.getLeftOperand().getLength();
        CAstNode result = this.createInfixExpression(n.getOperator(), leftType, leftStartPosition, leftLength, leftNode, n.getRightOperand(), context);
        if (n.hasExtendedOperands()) {
            leftLength = n.getRightOperand().getStartPosition() + n.getRightOperand().getLength() - leftStartPosition;
            for (Object o : n.extendedOperands()) {
                Expression operand = (Expression)o;
                result = this.createInfixExpression(n.getOperator(), leftType, leftStartPosition, leftLength, result, operand, context);
                leftType = leftType.isPrimitive() && operand.resolveTypeBinding().isPrimitive() ? JDT2CAstUtils.promoteTypes(leftType, operand.resolveTypeBinding(), this.ast) : operand.resolveTypeBinding();
                leftLength = operand.getStartPosition() + operand.getLength() - leftStartPosition;
            }
        }
        return result;
    }

    private CAstNode createInfixExpression(InfixExpression.Operator op, ITypeBinding leftType, int leftStartPosition, int leftLength, CAstNode leftNode, Expression right, WalkContext context) {
        CAstNode rightNode = this.visitNode((ASTNode)right, context);
        int start = leftStartPosition;
        int end = right.getStartPosition() + right.getLength();
        T pos = this.makePosition(start, end);
        T rightPos = this.makePosition(leftStartPosition, leftStartPosition + leftLength);
        T leftPos = this.makePosition(right.getStartPosition(), right.getStartPosition() + right.getLength());
        if (op == InfixExpression.Operator.CONDITIONAL_AND) {
            return this.makeNode(context, this.fFactory, pos, 107, leftNode, rightNode, this.fFactory.makeConstant(false));
        }
        if (op == InfixExpression.Operator.CONDITIONAL_OR) {
            return this.makeNode(context, this.fFactory, pos, 107, leftNode, this.fFactory.makeConstant(true), rightNode);
        }
        ITypeBinding rightType = right.resolveTypeBinding();
        if (leftType.isPrimitive() && rightType.isPrimitive()) {
            ITypeBinding result = JDT2CAstUtils.promoteTypes(leftType, rightType, this.ast);
            if (!result.isEqualTo((IBinding)leftType)) {
                leftNode = this.makeNode(context, this.fFactory, leftPos, 118, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(result)), leftNode, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(leftType)));
            }
            if (!result.isEqualTo((IBinding)rightType)) {
                rightNode = this.makeNode(context, this.fFactory, rightPos, 118, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(result)), rightNode, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(rightType)));
            }
            CAstNode opNode = this.makeNode(context, this.fFactory, pos, 105, (CAstNode)JDT2CAstUtils.mapBinaryOpcode(op), leftNode, rightNode);
            if (JDT2CAstUtils.isLongOrLess(leftType) && JDT2CAstUtils.isLongOrLess(rightType) && (JDT2CAstUtils.mapBinaryOpcode(op) == CAstOperator.OP_DIV || JDT2CAstUtils.mapBinaryOpcode(op) == CAstOperator.OP_MOD)) {
                Collection<Pair<ITypeBinding, Object>> excTargets = context.getCatchTargets(this.fDivByZeroExcType);
                if (!excTargets.isEmpty()) {
                    for (Pair<ITypeBinding, Object> catchPair : excTargets) {
                        context.cfg().add((Object)op, catchPair.snd, (Object)this.fDivByZeroExcType);
                    }
                } else {
                    context.cfg().add((Object)op, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)this.fDivByZeroExcType);
                }
            }
            return opNode;
        }
        return this.makeNode(context, this.fFactory, pos, 105, (CAstNode)JDT2CAstUtils.mapBinaryOpcode(op), leftNode, rightNode);
    }

    private CAstNode visit(ConstructorInvocation n, WalkContext context) {
        return this.createConstructorInvocation(n.resolveConstructorBinding().getMethodDeclaration(), n.arguments(), (ASTNode)n, context, false);
    }

    private CAstNode visit(SuperConstructorInvocation n, WalkContext context) {
        return this.createConstructorInvocation(n.resolveConstructorBinding().getMethodDeclaration(), n.arguments(), (ASTNode)n, context, true);
    }

    private CAstNode visit(SuperFieldAccess n, WalkContext context) {
        CAstNode targetNode;
        if (n.getQualifier() == null) {
            targetNode = this.makeNode(context, this.fFactory, (ASTNode)n, 115);
        } else {
            TypeReference owningTypeRef = this.fIdentityMapper.getTypeRef(n.getQualifier().resolveTypeBinding());
            targetNode = this.makeNode(context, this.fFactory, (ASTNode)n, 115, this.fFactory.makeConstant((Object)owningTypeRef));
        }
        return this.createFieldAccess(targetNode, n.getName().getIdentifier(), n.resolveFieldBinding(), (ASTNode)n, context);
    }

    private CAstNode createConstructorInvocation(IMethodBinding ctorBinding, List arguments, ASTNode callerNode, WalkContext context, boolean isSuper) {
        CAstNode targetNode;
        ITypeBinding ctorType = ctorBinding.getDeclaringClass();
        assert (ctorType.isClass());
        CallSiteReference callSiteRef = CallSiteReference.make((int)0, (MethodReference)this.fIdentityMapper.getMethodRef(ctorBinding), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        int nFormals = ctorBinding.getParameterTypes().length;
        CAstNode[] children = new CAstNode[2 + nFormals];
        children[0] = targetNode = this.makeNode(context, this.fFactory, callerNode, isSuper ? 115 : 116);
        children[1] = this.fFactory.makeConstant((Object)callSiteRef);
        this.populateArguments(children, ctorBinding, arguments, context);
        this.handleThrowsFromCall(ctorBinding, callerNode, context);
        CAstNode result = this.makeNode(context, this.fFactory, callerNode, 102, children);
        context.cfg().map((Object)context, result);
        return result;
    }

    private CAstNode visit(IfStatement n, WalkContext context) {
        return this.makeNode(context, this.fFactory, (ASTNode)n, 11, this.visitNode((ASTNode)n.getExpression(), context), this.visitNode((ASTNode)n.getThenStatement(), context), this.visitNode((ASTNode)n.getElseStatement(), context));
    }

    private CAstNode visit(InstanceofExpression n, WalkContext context) {
        return this.makeNode(context, this.fFactory, (ASTNode)n, 119, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(n.getRightOperand().resolveBinding())), this.visitNode((ASTNode)n.getLeftOperand(), context));
    }

    private CAstNode visit(CastExpression n, WalkContext context) {
        Expression arg = n.getExpression();
        ITypeBinding castedFrom = arg.resolveTypeBinding();
        ITypeBinding castedTo = n.getType().resolveBinding();
        return this.createCast((ASTNode)n, this.visitNode((ASTNode)arg, context), castedFrom, castedTo, context);
    }

    private CAstNode createCast(ASTNode pos, CAstNode argNode, ITypeBinding castedFrom, ITypeBinding castedTo, WalkContext context) {
        Object cfgMapDummy = new Object();
        if (castedFrom.isNullType()) {
            castedFrom = castedTo;
        }
        CAstNode ast = this.makeNode(context, this.fFactory, pos, 118, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(castedTo)), argNode, this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(castedFrom)));
        Collection<Pair<ITypeBinding, Object>> excTargets = context.getCatchTargets(this.fClassCastExcType);
        if (!excTargets.isEmpty()) {
            for (Pair<ITypeBinding, Object> catchPair : excTargets) {
                context.cfg().add(cfgMapDummy, catchPair.snd, (Object)this.fClassCastExcType);
            }
        } else {
            context.cfg().add(cfgMapDummy, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)this.fClassCastExcType);
        }
        context.cfg().map(cfgMapDummy, ast);
        return ast;
    }

    private CAstNode visit(ConditionalExpression n, WalkContext context) {
        return this.makeNode(context, this.fFactory, (ASTNode)n, 107, this.visitNode((ASTNode)n.getExpression(), context), this.visitNode((ASTNode)n.getThenExpression(), context), this.visitNode((ASTNode)n.getElseExpression(), context));
    }

    private CAstNode visit(PostfixExpression n, WalkContext context) {
        CAstOperator op = n.getOperator() == PostfixExpression.Operator.DECREMENT ? CAstOperator.OP_SUB : CAstOperator.OP_ADD;
        return this.makeNode(context, this.fFactory, (ASTNode)n, 16, this.visitNode((ASTNode)n.getOperand(), context), this.fFactory.makeConstant(1), (CAstNode)op);
    }

    private CAstNode visit(PrefixExpression n, WalkContext context) {
        PrefixExpression.Operator op = n.getOperator();
        if (op == PrefixExpression.Operator.DECREMENT || op == PrefixExpression.Operator.INCREMENT) {
            CAstOperator castOp = n.getOperator() == PrefixExpression.Operator.DECREMENT ? CAstOperator.OP_SUB : CAstOperator.OP_ADD;
            return this.makeNode(context, this.fFactory, (ASTNode)n, 15, this.visitNode((ASTNode)n.getOperand(), context), this.fFactory.makeConstant(1), (CAstNode)castOp);
        }
        if (op == PrefixExpression.Operator.PLUS) {
            return this.visitNode((ASTNode)n.getOperand(), context);
        }
        if (op == PrefixExpression.Operator.MINUS) {
            CAstNode zero = JDT2CAstUtils.isLongOrLess(n.getOperand().resolveTypeBinding()) ? this.fFactory.makeConstant(0L) : this.fFactory.makeConstant(0.0);
            return this.makeNode(context, this.fFactory, (ASTNode)n, 105, (CAstNode)CAstOperator.OP_SUB, zero, this.visitNode((ASTNode)n.getOperand(), context));
        }
        CAstOperator castOp = n.getOperator() == PrefixExpression.Operator.NOT ? CAstOperator.OP_NOT : CAstOperator.OP_BITNOT;
        return this.makeNode(context, this.fFactory, (ASTNode)n, 106, (CAstNode)castOp, this.visitNode((ASTNode)n.getOperand(), context));
    }

    private CAstNode visit(EmptyStatement n, WalkContext context) {
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)n, 19);
        context.cfg().map((Object)n, result);
        return result;
    }

    private CAstNode visit(AssertStatement n, WalkContext context) {
        return this.makeNode(context, this.fFactory, (ASTNode)n, 403, this.visitNode((ASTNode)n.getExpression(), context));
    }

    private CAstNode visit(LabeledStatement n, WalkContext context) {
        CAstNode result;
        Statement stmt = n.getBody();
        while (stmt instanceof Block) {
            stmt = (ASTNode)((Block)stmt).statements().iterator().next();
        }
        if (n.getParent() != null) {
            context.getLabelMap().put((ASTNode)stmt, n.getLabel().getIdentifier());
        }
        if (!(n.getBody() instanceof EmptyStatement)) {
            ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, n.getLabel().getIdentifier());
            CAstNode breakNode = this.visitNode(breakTarget, context);
            BreakContext child = new BreakContext(context, n.getLabel().getIdentifier(), breakTarget);
            result = this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.makeNode(context, this.fFactory, (ASTNode)n, 17, this.fFactory.makeConstant((Object)n.getLabel().getIdentifier()), this.visitNode((ASTNode)n.getBody(), child)), breakNode);
        } else {
            result = this.makeNode(context, this.fFactory, (ASTNode)n, 17, this.fFactory.makeConstant((Object)n.getLabel().getIdentifier()), this.visitNode((ASTNode)n.getBody(), context));
        }
        context.cfg().map((Object)n, result);
        if (n.getParent() != null) {
            context.getLabelMap().remove(stmt);
        }
        return result;
    }

    private ASTNode makeBreakOrContinueTarget(ASTNode loop, String name) {
        LabeledStatement labeled = this.ast.newLabeledStatement();
        labeled.setBody((Statement)this.ast.newEmptyStatement());
        labeled.setSourceRange(loop.getStartPosition(), loop.getLength());
        labeled.setLabel(this.ast.newSimpleName(name));
        return labeled;
    }

    private CAstNode visit(BreakStatement n, WalkContext context) {
        String label = n.getLabel() == null ? null : n.getLabel().getIdentifier();
        ASTNode target = (ASTNode)context.getBreakFor(label);
        assert (target != null);
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)n, 8);
        context.cfg().map((Object)n, result);
        context.cfg().add((Object)n, (Object)target, null);
        return result;
    }

    private CAstNode visit(ContinueStatement n, WalkContext context) {
        String label = n.getLabel() == null ? null : n.getLabel().getIdentifier();
        ASTNode target = (ASTNode)context.getContinueFor(label);
        assert (target != null);
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)n, 8);
        context.cfg().map((Object)n, result);
        context.cfg().add((Object)n, (Object)target, null);
        return result;
    }

    private CAstNode visit(WhileStatement n, WalkContext context) {
        Expression cond = n.getExpression();
        Statement body = n.getBody();
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel" + n.getStartPosition());
        CAstNode breakNode = this.visitNode(breakTarget, context);
        ASTNode continueTarget = this.makeBreakOrContinueTarget((ASTNode)n, "continueLabel" + n.getStartPosition());
        CAstNode continueNode = this.visitNode(continueTarget, context);
        String loopLabel = context.getLabelMap().get(n);
        LoopContext lc = new LoopContext(context, loopLabel, breakTarget, continueTarget);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.makeNode(context, this.fFactory, (ASTNode)n, 2, this.visitNode((ASTNode)cond, context), this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.visitNode((ASTNode)body, lc), continueNode)), breakNode);
    }

    private CAstNode getSwitchCaseConstant(SwitchCase n, WalkContext context) {
        Object constant;
        Expression expr = n.getExpression();
        Object object = constant = expr == null ? new Integer(0) : expr.resolveConstantExpressionValue();
        if (constant instanceof Character) {
            constant = new Long(((Character)constant).charValue());
        } else if (constant instanceof Byte) {
            constant = new Long(((Byte)constant).longValue());
        } else if (constant instanceof Integer) {
            constant = new Long(((Integer)constant).longValue());
        } else if (constant instanceof Short) {
            constant = new Long(((Short)constant).longValue());
        }
        if (constant != null) {
            return this.fFactory.makeConstant(constant);
        }
        if (expr instanceof SimpleName) {
            return this.visit((SimpleName)expr, context);
        }
        Assertions.UNREACHABLE((String)"null constant for non-enum switch case!");
        return null;
    }

    private CAstNode visit(SwitchCase n, WalkContext context) {
        CAstNode label = this.makeNode(context, this.fFactory, (ASTNode)n, 17, this.getSwitchCaseConstant(n, context));
        context.cfg().map((Object)n, label);
        return label;
    }

    private CAstNode visit(SwitchStatement n, WalkContext context) {
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel" + n.getStartPosition());
        CAstNode breakAst = this.visitNode(breakTarget, context);
        String loopLabel = context.getLabelMap().get(n);
        BreakContext childContext = new BreakContext(context, loopLabel, breakTarget);
        Expression cond = n.getExpression();
        List cases = n.statements();
        int i = 0;
        while (i < cases.size()) {
            Statement se = (Statement)cases.get(i);
            if (se instanceof SwitchCase) {
                SwitchCase c = (SwitchCase)se;
                if (c.isDefault()) {
                    context.cfg().add((Object)n, (Object)c, CAstControlFlowMap.SWITCH_DEFAULT);
                } else {
                    context.cfg().add((Object)n, (Object)c, (Object)this.getSwitchCaseConstant(c, context));
                }
            }
            ++i;
        }
        ArrayList<CAstNode> caseNodes = new ArrayList<CAstNode>();
        ArrayList<CAstNode> currentBlock = new ArrayList<CAstNode>();
        for (Object o : cases) {
            Statement s = (Statement)o;
            if (s instanceof SwitchCase) {
                if (!currentBlock.isEmpty()) {
                    CAstNode[] stmtNodes = currentBlock.toArray(new CAstNode[currentBlock.size()]);
                    T positionOfAll = this.makePosition(childContext.pos().getPosition(stmtNodes[0]).getFirstOffset(), childContext.pos().getPosition(stmtNodes[stmtNodes.length - 1]).getLastOffset());
                    caseNodes.add(this.makeNode((WalkContext)childContext, this.fFactory, positionOfAll, 3, stmtNodes));
                    currentBlock.clear();
                }
                caseNodes.add(this.visitNode((ASTNode)s, childContext));
                continue;
            }
            this.visitNodeOrNodes((ASTNode)s, childContext, currentBlock);
        }
        if (!currentBlock.isEmpty()) {
            CAstNode[] stmtNodes = currentBlock.toArray(new CAstNode[currentBlock.size()]);
            T positionOfAll = this.makePosition(childContext.pos().getPosition(stmtNodes[0]).getFirstOffset(), childContext.pos().getPosition(stmtNodes[stmtNodes.length - 1]).getLastOffset());
            caseNodes.add(this.makeNode((WalkContext)childContext, this.fFactory, positionOfAll, 3, stmtNodes));
        }
        CAstNode switchAst = this.makeNode(context, this.fFactory, (ASTNode)n, 1, this.visitNode((ASTNode)cond, context), this.makeNode(context, this.fFactory, (ASTNode)n, 3, caseNodes.toArray(new CAstNode[caseNodes.size()])));
        context.cfg().map((Object)n, switchAst);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 3, switchAst, breakAst);
    }

    private CAstNode visit(DoStatement n, WalkContext context) {
        String loopLabel = context.getLabelMap().get(n);
        String token = loopLabel == null ? "at_" + n.getStartPosition() : loopLabel;
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel_" + token);
        CAstNode breakNode = this.visitNode(breakTarget, context);
        ASTNode continueTarget = this.makeBreakOrContinueTarget((ASTNode)n, "continueLabel_" + token);
        CAstNode continueNode = this.visitNode(continueTarget, context);
        CAstNode loopTest = this.visitNode((ASTNode)n.getExpression(), context);
        LoopContext loopContext = new LoopContext(context, loopLabel, breakTarget, continueTarget);
        CAstNode loopBody = this.visitNode((ASTNode)n.getBody(), loopContext);
        return this.doLoopTranslator.translateDoLoop(loopTest, loopBody, continueNode, breakNode, (TranslatorToCAst.WalkContext)context);
    }

    private CAstNode visit(EnhancedForStatement n, WalkContext context) {
        if (n.getExpression().resolveTypeBinding().isArray()) {
            return this.makeArrayEnhancedForLoop(n, context);
        }
        return this.makeIteratorEnhancedForLoop(n, context);
    }

    private CAstNode makeIteratorEnhancedForLoop(EnhancedForStatement n, WalkContext context) {
        CAstNode exprNode = this.visitNode((ASTNode)n.getExpression(), context);
        SingleVariableDeclaration svd = n.getParameter();
        Statement body = n.getBody();
        MethodReference iterMethodRef = this.fIdentityMapper.fakeMethodRefNoArgs("Ljava/lang/Iterable;.iterator()Ljava/util/Iterator<TT;>;", "Ljava/lang/Iterable", "iterator", "Ljava/util/Iterator");
        CAstNode iterCallSiteRef = this.fFactory.makeConstant((Object)CallSiteReference.make((int)0, (MethodReference)iterMethodRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE));
        CAstNode iterCallNode = this.makeNode(context, this.fFactory, (ASTNode)n, 102, exprNode, iterCallSiteRef);
        Object o1 = new Object();
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fRuntimeExcType)) {
            context.cfg().add(o1, catchTarget.snd, catchTarget.fst);
        }
        context.cfg().map(o1, iterCallNode);
        CAstNode iterAssignNode = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new AstTranslator.InternalCAstSymbol("iter tmp", this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("int")), true)), iterCallNode);
        iterAssignNode = this.makeNode(context, this.fFactory, (ASTNode)n, 3, iterAssignNode);
        MethodReference hasNextMethodRef = this.fIdentityMapper.fakeMethodRefNoArgs("Ljava/util/Iterator;.hasNext()Z", "Ljava/util/Iterator", "hasNext", "Z");
        CAstNode iterVar = this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"iter tmp"));
        CAstNode hasNextCallSiteRef = this.fFactory.makeConstant((Object)CallSiteReference.make((int)0, (MethodReference)hasNextMethodRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE));
        CAstNode hasNextCallNode = this.makeNode(context, this.fFactory, (ASTNode)n, 102, iterVar, hasNextCallSiteRef);
        Object o2 = new Object();
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fRuntimeExcType)) {
            context.cfg().add(o2, catchTarget.snd, catchTarget.fst);
        }
        context.cfg().map(o2, hasNextCallNode);
        MethodReference nextMethodRef = this.fIdentityMapper.fakeMethodRefNoArgs("Ljava/util/Iterator;.next()TE;", "Ljava/util/Iterator", "next", "Ljava/lang/Object");
        CAstNode nextCallSiteRef = this.fFactory.makeConstant((Object)CallSiteReference.make((int)0, (MethodReference)nextMethodRef, (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.INTERFACE));
        CAstNode iterVar2 = this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"iter tmp"));
        CAstNode nextCallNode = this.makeNode(context, this.fFactory, (ASTNode)n, 102, iterVar2, nextCallSiteRef);
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fRuntimeExcType)) {
            context.cfg().add((Object)svd, catchTarget.snd, catchTarget.fst);
        }
        context.cfg().map((Object)svd, nextCallNode);
        CAstNode castedNode = this.createCast((ASTNode)svd, nextCallNode, this.ast.resolveWellKnownType("java.lang.Object"), svd.resolveBinding().getType(), context);
        Object defaultValue = JDT2CAstUtils.defaultValueForType(svd.resolveBinding().getType());
        CAstNode nextAssignNode = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new CAstSymbolImpl(svd.getName().getIdentifier(), this.fTypeDict.getCAstTypeFor(svd.resolveBinding().getType()), (svd.getModifiers() & 0x10) != 0, defaultValue)), castedNode);
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel" + n.getStartPosition());
        ASTNode continueTarget = this.makeBreakOrContinueTarget((ASTNode)n, "continueLabel" + n.getStartPosition());
        String loopLabel = context.getLabelMap().get(n);
        LoopContext loopContext = new LoopContext(context, loopLabel, breakTarget, continueTarget);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, iterAssignNode, this.makeNode(context, this.fFactory, (ASTNode)n, 2, hasNextCallNode, this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, nextAssignNode, this.visitNode((ASTNode)body, loopContext))), this.visitNode(continueTarget, context), this.makeNode(context, this.fFactory, (ASTNode)n, 3))), this.visitNode(breakTarget, context)));
    }

    private CAstNode makeArrayEnhancedForLoop(EnhancedForStatement n, WalkContext context) {
        CAstNode exprNode = this.visitNode((ASTNode)n.getExpression(), context);
        CAstNode arrayDeclNode = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new AstTranslator.InternalCAstSymbol("for temp array", this.fTypeDict.getCAstTypeFor(n.getExpression().resolveTypeBinding()), true)), exprNode);
        CAstNode indexDeclNode = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new AstTranslator.InternalCAstSymbol("for temp index", this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("int")), true)), this.fFactory.makeConstant((Object)new Integer(0)));
        CAstNode tmpArrayLengthNode = this.makeNode(context, this.fFactory, (ASTNode)n, 121, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"for temp array"), this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(n.getExpression().resolveTypeBinding()))));
        CAstNode condNode = this.makeNode(context, this.fFactory, (ASTNode)n, 105, (CAstNode)CAstOperator.OP_LT, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"for temp index"), this.fFactory.makeConstant((Object)JavaPrimitiveType.INT)), tmpArrayLengthNode);
        CAstNode tmpArrayIncNode = this.makeNode(context, this.fFactory, (ASTNode)n, 16, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"for temp index")), this.fFactory.makeConstant(1), (CAstNode)CAstOperator.OP_ADD);
        CAstNode tmpArrayAccessNode = this.makeNode(context, this.fFactory, (ASTNode)n, 120, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"for temp array")), this.fFactory.makeConstant((Object)this.fIdentityMapper.getTypeRef(n.getExpression().resolveTypeBinding().getComponentType())), this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)"for temp index")));
        SingleVariableDeclaration svd = n.getParameter();
        Object defaultValue = JDT2CAstUtils.defaultValueForType(svd.resolveBinding().getType());
        CAstNode nextAssignNode = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new CAstSymbolImpl(svd.getName().getIdentifier(), this.fTypeDict.getCAstTypeFor(n.getExpression().resolveTypeBinding().getComponentType()), (svd.getModifiers() & 0x10) != 0, defaultValue)), tmpArrayAccessNode);
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel" + n.getStartPosition());
        ASTNode continueTarget = this.makeBreakOrContinueTarget((ASTNode)n, "continueLabel" + n.getStartPosition());
        String loopLabel = context.getLabelMap().get(n);
        LoopContext loopContext = new LoopContext(context, loopLabel, breakTarget, continueTarget);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, arrayDeclNode, this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.makeNode(context, this.fFactory, (ASTNode)n, 3, indexDeclNode), this.makeNode(context, this.fFactory, (ASTNode)n, 2, condNode, this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, nextAssignNode, this.visitNode((ASTNode)n.getBody(), loopContext))), this.visitNode(continueTarget, context), this.makeNode(context, this.fFactory, (ASTNode)n, 3, tmpArrayIncNode))), this.visitNode(breakTarget, context)))));
    }

    private CAstNode visit(ForStatement n, WalkContext context) {
        ASTNode breakTarget = this.makeBreakOrContinueTarget((ASTNode)n, "breakLabel" + n.getStartPosition());
        ASTNode continueTarget = this.makeBreakOrContinueTarget((ASTNode)n, "continueLabel" + n.getStartPosition());
        String loopLabel = context.getLabelMap().get(n);
        LoopContext loopContext = new LoopContext(context, loopLabel, breakTarget, continueTarget);
        ArrayList<CAstNode> inits = new ArrayList<CAstNode>();
        int i = 0;
        while (i < n.initializers().size()) {
            ASTNode init = (ASTNode)n.initializers().get(i);
            if (init instanceof VariableDeclarationExpression) {
                for (Object o : ((VariableDeclarationExpression)init).fragments()) {
                    inits.add(this.visitNode((ASTNode)o, context));
                }
            } else {
                inits.add(this.visitNode(init, context));
            }
            ++i;
        }
        CAstNode[] iters = new CAstNode[n.updaters().size()];
        int i2 = 0;
        while (i2 < iters.length) {
            iters[i2] = this.visitNode((ASTNode)n.updaters().get(i2), context);
            ++i2;
        }
        CAstNode initsBlock = this.makeNode(context, this.fFactory, (ASTNode)n, 3, inits.toArray(new CAstNode[inits.size()]));
        CAstNode itersBlock = this.makeNode(context, this.fFactory, (ASTNode)n, 3, iters);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 200, this.makeNode(context, this.fFactory, (ASTNode)n, 3, initsBlock, this.makeNode(context, this.fFactory, (ASTNode)n, 2, this.visitNode((ASTNode)n.getExpression(), context), this.makeNode(context, this.fFactory, (ASTNode)n, 3, this.visitNode((ASTNode)n.getBody(), loopContext), this.visitNode(continueTarget, context), itersBlock)), this.visitNode(breakTarget, context)));
    }

    private CAstNode visit(TryStatement n, WalkContext context) {
        List catchBlocks = n.catchClauses();
        Block finallyBlock = n.getFinally();
        Block tryBlock = n.getBody();
        if (catchBlocks.isEmpty()) {
            return this.makeNode(context, this.fFactory, (ASTNode)n, 22, this.visitNode((ASTNode)tryBlock, context), this.visitNode((ASTNode)finallyBlock, context));
        }
        TryCatchContext tc = new TryCatchContext(context, n);
        CAstNode tryNode = this.visitNode((ASTNode)tryBlock, tc);
        Iterator iter = catchBlocks.iterator();
        while (iter.hasNext()) {
            tryNode = this.makeNode(context, this.fFactory, (ASTNode)n, 4, tryNode, this.visitNode((ASTNode)((CatchClause)iter.next()), context));
        }
        if (finallyBlock == null) {
            return tryNode;
        }
        return this.makeNode(context, this.fFactory, (ASTNode)n, 22, tryNode, this.visitNode((ASTNode)finallyBlock, context));
    }

    private CAstNode visit(CatchClause n, WalkContext context) {
        Block body = n.getBody();
        SingleVariableDeclaration formal = n.getException();
        CAstNode excDecl = this.makeNode(context, this.fFactory, (ASTNode)n, 21, this.fFactory.makeConstant((Object)formal.getName().getIdentifier()), this.visitNode((ASTNode)body, context));
        CAstNode localScope = this.makeNode(context, this.fFactory, (ASTNode)n, 200, excDecl);
        context.cfg().map((Object)n, excDecl);
        context.getNodeTypeMap().add(excDecl, this.fTypeDict.getCAstTypeFor(n.getException().resolveBinding().getType()));
        return localScope;
    }

    private CAstNode visit(ThrowStatement n, WalkContext context) {
        CAstNode result = this.makeNode(context, this.fFactory, (ASTNode)n, 12, this.visitNode((ASTNode)n.getExpression(), context));
        ITypeBinding label = n.getExpression().resolveTypeBinding();
        context.cfg().map((Object)n, result);
        Collection<Pair<ITypeBinding, Object>> catchNodes = context.getCatchTargets(label);
        for (Pair<ITypeBinding, Object> catchNode : catchNodes) {
            context.cfg().add((Object)n, catchNode.snd, catchNode.fst);
        }
        return result;
    }

    private void hookUpNPETargets(ASTNode n, WalkContext wc) {
        Collection<Pair<ITypeBinding, Object>> excTargets = wc.getCatchTargets(this.fNullPointerExcType);
        if (!excTargets.isEmpty()) {
            for (Pair<ITypeBinding, Object> catchPair : excTargets) {
                wc.cfg().add((Object)n, catchPair.snd, (Object)this.fNullPointerExcType);
            }
        } else {
            wc.cfg().add((Object)n, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT, (Object)this.fNullPointerExcType);
        }
    }

    private CAstNode visit(ArrayAccess n, WalkContext context) {
        TypeReference eltTypeRef = this.fIdentityMapper.getTypeRef(n.resolveTypeBinding());
        CAstNode cast = this.makeNode(context, this.fFactory, (ASTNode)n, 120, this.visitNode((ASTNode)n.getArray(), context), this.fFactory.makeConstant((Object)eltTypeRef), this.visitNode((ASTNode)n.getIndex(), context));
        this.hookUpNPETargets((ASTNode)n, context);
        context.cfg().map((Object)n, cast);
        return cast;
    }

    private CAstNode visit(ArrayCreation n, WalkContext context) {
        ITypeBinding newType = n.resolveTypeBinding();
        ArrayInitializer ai = n.getInitializer();
        assert (newType.isArray());
        if (ai != null) {
            return this.visitNode((ASTNode)ai, context);
        }
        TypeReference arrayTypeRef = this.fIdentityMapper.getTypeRef(newType);
        List dims = n.dimensions();
        CAstNode[] args = new CAstNode[dims.size() + 1];
        int idx = 0;
        args[idx++] = this.fFactory.makeConstant((Object)arrayTypeRef);
        for (Expression dimExpr : dims) {
            args[idx++] = this.visitNode((ASTNode)dimExpr, context);
        }
        return this.makeNode(context, this.fFactory, (ASTNode)n, 109, args);
    }

    private CAstNode visit(SynchronizedStatement n, WalkContext context) {
        CAstNode exprNode = this.visitNode((ASTNode)n.getExpression(), context);
        String exprName = this.fFactory.makeUnique();
        CAstNode declStmt = this.makeNode(context, this.fFactory, (ASTNode)n, 6, this.fFactory.makeConstant((Object)new CAstSymbolImpl(exprName, this.fTypeDict.getCAstTypeFor(n.getExpression().resolveTypeBinding()), true)), exprNode);
        CAstNode monitorEnterNode = this.makeNode(context, this.fFactory, (ASTNode)n, 23, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)exprName)));
        context.cfg().map((Object)monitorEnterNode, monitorEnterNode);
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fNullPointerExcType)) {
            context.cfg().add((Object)monitorEnterNode, catchTarget.snd, catchTarget.fst);
        }
        CAstNode bodyNodes = this.visitNode((ASTNode)n.getBody(), context);
        CAstNode monitorExitNode = this.makeNode(context, this.fFactory, (ASTNode)n, 24, this.makeNode(context, this.fFactory, (ASTNode)n, 111, this.fFactory.makeConstant((Object)exprName)));
        context.cfg().map((Object)monitorExitNode, monitorExitNode);
        for (Pair<ITypeBinding, Object> catchTarget : context.getCatchTargets(this.fNullPointerExcType)) {
            context.cfg().add((Object)monitorExitNode, catchTarget.snd, catchTarget.fst);
        }
        CAstNode tryBody = this.makeNode(context, this.fFactory, (ASTNode)n, 3, monitorEnterNode, bodyNodes);
        CAstNode bigBody = this.makeNode(context, this.fFactory, (ASTNode)n, 22, tryBody, monitorExitNode);
        return this.makeNode(context, this.fFactory, (ASTNode)n, 3, declStmt, bigBody);
    }

    private CAstEntity visit(AbstractTypeDeclaration n, WalkContext context) {
        if (n instanceof TypeDeclaration) {
            return this.visitTypeDecl(n, context);
        }
        if (n instanceof EnumDeclaration) {
            return this.visit((EnumDeclaration)n, context);
        }
        if (n instanceof AnnotationTypeDeclaration) {
            return this.visitTypeDecl(n, context);
        }
        Assertions.UNREACHABLE((String)"Unhandled type declaration type");
        return null;
    }

    private CAstNode visitNode(ASTNode n, WalkContext context) {
        if (n == null) {
            return this.makeNode(context, this.fFactory, null, 19);
        }
        if (n instanceof ArrayAccess) {
            return this.visit((ArrayAccess)n, context);
        }
        if (n instanceof ArrayCreation) {
            return this.visit((ArrayCreation)n, context);
        }
        if (n instanceof ArrayInitializer) {
            return this.visit((ArrayInitializer)n, context);
        }
        if (n instanceof AssertStatement) {
            return this.visit((AssertStatement)n, context);
        }
        if (n instanceof Assignment) {
            return this.visit((Assignment)n, context);
        }
        if (n instanceof Block) {
            return this.visit((Block)n, context);
        }
        if (n instanceof BooleanLiteral) {
            return this.visit((BooleanLiteral)n, context);
        }
        if (n instanceof BreakStatement) {
            return this.visit((BreakStatement)n, context);
        }
        if (n instanceof CastExpression) {
            return this.visit((CastExpression)n, context);
        }
        if (n instanceof CatchClause) {
            return this.visit((CatchClause)n, context);
        }
        if (n instanceof CharacterLiteral) {
            return this.visit((CharacterLiteral)n, context);
        }
        if (n instanceof ClassInstanceCreation) {
            return this.visit((ClassInstanceCreation)n, context);
        }
        if (n instanceof ConditionalExpression) {
            return this.visit((ConditionalExpression)n, context);
        }
        if (n instanceof ConstructorInvocation) {
            return this.visit((ConstructorInvocation)n, context);
        }
        if (n instanceof ContinueStatement) {
            return this.visit((ContinueStatement)n, context);
        }
        if (n instanceof DoStatement) {
            return this.visit((DoStatement)n, context);
        }
        if (n instanceof EmptyStatement) {
            return this.visit((EmptyStatement)n, context);
        }
        if (n instanceof EnhancedForStatement) {
            return this.visit((EnhancedForStatement)n, context);
        }
        if (n instanceof ExpressionStatement) {
            return this.visit((ExpressionStatement)n, context);
        }
        if (n instanceof FieldAccess) {
            return this.visit((FieldAccess)n, context);
        }
        if (n instanceof ForStatement) {
            return this.visit((ForStatement)n, context);
        }
        if (n instanceof IfStatement) {
            return this.visit((IfStatement)n, context);
        }
        if (n instanceof InfixExpression) {
            return this.visit((InfixExpression)n, context);
        }
        if (n instanceof InstanceofExpression) {
            return this.visit((InstanceofExpression)n, context);
        }
        if (n instanceof LabeledStatement) {
            return this.visit((LabeledStatement)n, context);
        }
        if (n instanceof MethodInvocation) {
            return this.visit((MethodInvocation)n, context);
        }
        if (n instanceof NumberLiteral) {
            return this.visit((NumberLiteral)n, context);
        }
        if (n instanceof NullLiteral) {
            return this.visit((NullLiteral)n, context);
        }
        if (n instanceof ParenthesizedExpression) {
            return this.visit((ParenthesizedExpression)n, context);
        }
        if (n instanceof PostfixExpression) {
            return this.visit((PostfixExpression)n, context);
        }
        if (n instanceof PrefixExpression) {
            return this.visit((PrefixExpression)n, context);
        }
        if (n instanceof QualifiedName) {
            return this.visit((QualifiedName)n, context);
        }
        if (n instanceof ReturnStatement) {
            return this.visit((ReturnStatement)n, context);
        }
        if (n instanceof SimpleName) {
            return this.visit((SimpleName)n, context);
        }
        if (n instanceof StringLiteral) {
            return this.visit((StringLiteral)n, context);
        }
        if (n instanceof SuperConstructorInvocation) {
            return this.visit((SuperConstructorInvocation)n, context);
        }
        if (n instanceof SuperFieldAccess) {
            return this.visit((SuperFieldAccess)n, context);
        }
        if (n instanceof SuperMethodInvocation) {
            return this.visit((SuperMethodInvocation)n, context);
        }
        if (n instanceof SynchronizedStatement) {
            return this.visit((SynchronizedStatement)n, context);
        }
        if (n instanceof SwitchStatement) {
            return this.visit((SwitchStatement)n, context);
        }
        if (n instanceof SwitchCase) {
            return this.visit((SwitchCase)n, context);
        }
        if (n instanceof ThisExpression) {
            return this.visit((ThisExpression)n, context);
        }
        if (n instanceof TypeLiteral) {
            return this.visit((TypeLiteral)n, context);
        }
        if (n instanceof ThrowStatement) {
            return this.visit((ThrowStatement)n, context);
        }
        if (n instanceof TryStatement) {
            return this.visit((TryStatement)n, context);
        }
        if (n instanceof TypeDeclarationStatement) {
            return this.visit((TypeDeclarationStatement)n, context);
        }
        if (n instanceof VariableDeclarationFragment) {
            return this.visit((VariableDeclarationFragment)n, context);
        }
        if (n instanceof WhileStatement) {
            return this.visit((WhileStatement)n, context);
        }
        Assertions.UNREACHABLE((String)("Unhandled JDT node type " + n.getClass().getCanonicalName()));
        return null;
    }

    private void visitNodeOrNodes(ASTNode n, WalkContext context, Collection<CAstNode> coll) {
        if (n instanceof VariableDeclarationStatement) {
            coll.addAll(this.visit((VariableDeclarationStatement)n, context));
        } else {
            coll.add(this.visitNode(n, context));
        }
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind) {
        CAstNode cn = Ast.makeNode(kind);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind, CAstNode[] c) {
        CAstNode cn = Ast.makeNode(kind, c);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, T pos, int kind, CAstNode[] c) {
        CAstNode cn = Ast.makeNode(kind, c);
        wc.pos().setPosition(cn, pos);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind, CAstNode c1, CAstNode c2) {
        CAstNode cn = Ast.makeNode(kind, c1, c2);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind, CAstNode c) {
        CAstNode cn = Ast.makeNode(kind, c);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind, CAstNode c1, CAstNode c2, CAstNode c3) {
        CAstNode cn = Ast.makeNode(kind, c1, c2, c3);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, ASTNode n, int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4) {
        CAstNode cn = Ast.makeNode(kind, c1, c2, c3, c4);
        this.setPos(wc, cn, n);
        return cn;
    }

    protected CAstNode makeNode(WalkContext wc, CAst Ast, T pos, int kind, CAstNode c1, CAstNode c2, CAstNode c3) {
        CAstNode cn = Ast.makeNode(kind, c1, c2, c3);
        wc.pos().setPosition(cn, pos);
        return cn;
    }

    protected void setPos(WalkContext wc, CAstNode cn, ASTNode jdtNode) {
        if (jdtNode != null) {
            wc.pos().setPosition(cn, this.makePosition(jdtNode));
        }
    }

    public T makePosition(ASTNode n) {
        return this.makePosition(n.getStartPosition(), n.getStartPosition() + n.getLength());
    }

    public abstract T makePosition(int var1, int var2);

    private CAstEntity visit(EnumConstantDeclaration decl, WalkContext context) {
        return new FieldEntity(this, decl.getName().getIdentifier(), decl.resolveVariable().getType(), enumQuals, (CAstSourcePositionMap.Position)this.makePosition(decl.getStartPosition(), decl.getStartPosition() + decl.getLength()), null);
    }

    private CAstNode createEnumConstantDeclarationInit(EnumConstantDeclaration node, WalkContext context) {
        String hiddenVariableName = (String)node.getProperty("com.ibm.wala.cast.java.translator.jdt.fakeValuesDeclName");
        if (hiddenVariableName == null) {
            FieldReference fieldRef = this.fIdentityMapper.getFieldRef(node.resolveVariable());
            CAstNode lhsNode = this.makeNode(context, this.fFactory, (ASTNode)node, 112, this.makeNode(context, this.fFactory, null, 402), this.fFactory.makeConstant((Object)fieldRef));
            ArrayList<CAstNode> arguments = new ArrayList<CAstNode>();
            arguments.add(this.fFactory.makeConstant((Object)node.getName().getIdentifier()));
            arguments.add(this.fFactory.makeConstant(node.resolveVariable().getVariableId()));
            arguments.addAll(node.arguments());
            CAstNode rhsNode = this.createClassInstanceCreation((ASTNode)node, arguments, node.resolveConstructorBinding(), null, node.getAnonymousClassDeclaration(), context);
            CAstNode assNode = this.makeNode(context, this.fFactory, (ASTNode)node, 14, lhsNode, rhsNode);
            return assNode;
        }
        return null;
    }

    private CAstEntity createEnumValueOfMethod(ITypeBinding enumType, WalkContext oldContext) {
        IMethodBinding m;
        IMethodBinding met = null;
        IMethodBinding superMet = null;
        IMethodBinding[] iMethodBindingArray = enumType.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMethodBindingArray[n2];
            if (m.getName().equals("valueOf") && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isEqualTo((IBinding)this.ast.resolveWellKnownType("java.lang.String"))) {
                met = m;
            }
            ++n2;
        }
        iMethodBindingArray = enumType.getSuperclass().getTypeDeclaration().getDeclaredMethods();
        n = iMethodBindingArray.length;
        n2 = 0;
        while (n2 < n) {
            m = iMethodBindingArray[n2];
            if (m.getName().equals("valueOf") && m.getParameterTypes().length == 2) {
                superMet = m;
            }
            ++n2;
        }
        assert (met != null && superMet != null) : "Couldn't find enum values() function in JDT bindings!";
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        MethodDeclaration fakeMet = this.ast.newMethodDeclaration();
        fakeMet.setName(this.ast.newSimpleName("valueOf"));
        fakeMet.setSourceRange(-1, 0);
        fakeMet.setBody(this.ast.newBlock());
        SingleVariableDeclaration stringS = this.ast.newSingleVariableDeclaration();
        stringS.setName(this.ast.newSimpleName("s"));
        fakeMet.parameters().add(stringS);
        CAstNode typeLit = this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 127, this.fFactory.makeConstant((Object)this.fIdentityMapper.typeToTypeID(enumType)));
        CAstNode stringSvar = this.makeNode(context, this.fFactory, (ASTNode)fakeMet, 111, this.fFactory.makeConstant((Object)"s"), this.fFactory.makeConstant((Object)this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("java.lang.String"))));
        ArrayList<CAstNode> args = new ArrayList<CAstNode>();
        args.add(typeLit);
        args.add(stringSvar);
        CAstNode call = this.createMethodInvocation((ASTNode)fakeMet, superMet, this.makeNode(context, this.fFactory, (ASTNode)fakeMet, 402), args, context);
        CAstNode cast = this.createCast((ASTNode)fakeMet, call, enumType, superMet.getReturnType(), context);
        CAstNode bodyNode = this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 200, this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 3, this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 7, cast)));
        ArrayList<CAstType> paramTypes = new ArrayList<CAstType>(1);
        paramTypes.add(this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("java.lang.String")));
        return new ProcedureEntity(bodyNode, fakeMet, enumType, memberEntities, context, paramTypes, enumType, met.getModifiers(), this.handleAnnotations((IBinding)met));
    }

    private CAstEntity createEnumValuesMethod(ITypeBinding enumType, ArrayList<IVariableBinding> constants, WalkContext oldContext) {
        IMethodBinding met = null;
        IMethodBinding[] iMethodBindingArray = enumType.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding m = iMethodBindingArray[n2];
            if (m.getName().equals("values") && m.getParameterTypes().length == 0) {
                met = m;
            }
            ++n2;
        }
        assert (met != null) : "Couldn't find enum values() function in JDT bindings!";
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        MethodDeclaration fakeMet = this.ast.newMethodDeclaration();
        fakeMet.setName(this.ast.newSimpleName("values"));
        fakeMet.setSourceRange(-1, 0);
        fakeMet.setBody(this.ast.newBlock());
        CAstNode[] eltNodes = new CAstNode[constants.size() + 1];
        int idx = 0;
        TypeReference arrayTypeRef = this.fIdentityMapper.getTypeRef(enumType.createArrayType(1));
        eltNodes[idx++] = this.makeNode(context, this.fFactory, (ASTNode)fakeMet, 109, this.fFactory.makeConstant((Object)arrayTypeRef), this.fFactory.makeConstant(constants.size()));
        for (IVariableBinding cst : constants) {
            eltNodes[idx++] = this.createFieldAccess(this.makeNode(context, this.fFactory, (ASTNode)fakeMet, 402), cst.getName(), cst, (ASTNode)fakeMet, context);
        }
        CAstNode bodyNode = this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 200, this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 3, this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 7, this.makeNode((WalkContext)context, this.fFactory, (ASTNode)fakeMet, 117, eltNodes))));
        ArrayList paramTypes = new ArrayList(0);
        return new ProcedureEntity(bodyNode, fakeMet, enumType, memberEntities, context, paramTypes, enumType.createArrayType(1), met.getModifiers(), this.handleAnnotations((IBinding)enumType));
    }

    private void doEnumHiddenEntities(ITypeBinding typeBinding, ArrayList<ASTNode> staticInits, List<CAstEntity> memberEntities, WalkContext context) {
        ArrayList<IVariableBinding> constants = new ArrayList<IVariableBinding>();
        IVariableBinding[] iVariableBindingArray = typeBinding.getDeclaredFields();
        int n = iVariableBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariableBinding var = iVariableBindingArray[n2];
            if (var.isEnumConstant()) {
                constants.add(var);
            }
            ++n2;
        }
        Collections.sort(constants, new Comparator<IVariableBinding>(){

            @Override
            public int compare(IVariableBinding arg0, IVariableBinding arg1) {
                return arg0.getVariableId() - arg1.getVariableId();
            }
        });
        memberEntities.add(this.createEnumValuesMethod(typeBinding, constants, context));
        memberEntities.add(this.createEnumValueOfMethod(typeBinding, context));
    }

    private CAstEntity visit(EnumDeclaration n, WalkContext context) {
        return this.createClassDeclaration((ASTNode)n, n.bodyDeclarations(), n.enumConstants(), n.resolveBinding(), n.getName().getIdentifier(), n.resolveBinding().getModifiers(), false, false, context);
    }

    private CAstEntity createEnumConstructorWithParameters(IMethodBinding ctor, ASTNode n, WalkContext oldContext, ArrayList<ASTNode> inits, MethodDeclaration nonDefaultCtor) {
        int i;
        int i2;
        ITypeBinding newType = ctor.getDeclaringClass();
        ITypeBinding javalangenumType = newType.getSuperclass();
        IMethodBinding superCtor = null;
        if (newType.isEnum()) {
            IMethodBinding[] iMethodBindingArray = javalangenumType.getDeclaredMethods();
            int n2 = iMethodBindingArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IMethodBinding met = iMethodBindingArray[n3];
                if (met.isConstructor()) {
                    superCtor = met;
                    break;
                }
                ++n3;
            }
        }
        assert (superCtor != null) : "enum";
        LinkedHashMap<CAstNode, CAstEntity> memberEntities = new LinkedHashMap<CAstNode, CAstEntity>();
        MethodContext context = new MethodContext(oldContext, memberEntities);
        MethodDeclaration fakeCtor = this.ast.newMethodDeclaration();
        fakeCtor.setConstructor(true);
        fakeCtor.setSourceRange(n.getStartPosition(), n.getLength());
        fakeCtor.setBody(this.ast.newBlock());
        String[] fakeArguments = new String[3 + ctor.getParameterTypes().length];
        if (nonDefaultCtor == null) {
            i2 = 3;
            while (i2 < fakeArguments.length) {
                fakeArguments[i2] = "__wala_jdtcast_argument" + i2;
                ++i2;
            }
        } else {
            i2 = 3;
            while (i2 < fakeArguments.length) {
                fakeArguments[i2] = ((SingleVariableDeclaration)nonDefaultCtor.parameters().get(i2 - 3)).getName().getIdentifier();
                ++i2;
            }
        }
        ArrayList<CAstType> paramTypes = new ArrayList<CAstType>(superCtor.getParameterTypes().length);
        fakeArguments[0] = "this";
        fakeArguments[1] = "__wala_jdtcast_argument1";
        fakeArguments[2] = "__wala_jdtcast_argument2";
        int i3 = 1;
        while (i3 < fakeArguments.length) {
            SingleVariableDeclaration svd = this.ast.newSingleVariableDeclaration();
            svd.setName(this.ast.newSimpleName(fakeArguments[i3]));
            fakeCtor.parameters().add(svd);
            if (i3 == 1) {
                paramTypes.add(this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("java.lang.String")));
            } else if (i3 == 2) {
                paramTypes.add(this.fTypeDict.getCAstTypeFor(this.ast.resolveWellKnownType("int")));
            } else {
                paramTypes.add(this.fTypeDict.getCAstTypeFor(ctor.getParameterTypes()[i3 - 3]));
            }
            ++i3;
        }
        CAstNode[] bodyNodes = nonDefaultCtor == null ? new CAstNode[inits.size() + 1] : new CAstNode[inits.size() + 2];
        CAstNode[] children = ctor.isDefaultConstructor() ? new CAstNode[4 + ctor.getParameterTypes().length] : new CAstNode[4];
        children[0] = this.makeNode(context, this.fFactory, n, 115);
        CallSiteReference callSiteRef = CallSiteReference.make((int)0, (MethodReference)this.fIdentityMapper.getMethodRef(superCtor), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.SPECIAL);
        children[1] = this.fFactory.makeConstant((Object)callSiteRef);
        children[2] = this.makeNode(context, this.fFactory, n, 111, this.fFactory.makeConstant((Object)fakeArguments[1]), this.fFactory.makeConstant(paramTypes.get(0)));
        children[3] = this.makeNode(context, this.fFactory, n, 111, this.fFactory.makeConstant((Object)fakeArguments[2]), this.fFactory.makeConstant(paramTypes.get(1)));
        if (ctor.isDefaultConstructor()) {
            i = 0;
            while (i < ctor.getParameterTypes().length) {
                children[i + 4] = this.makeNode(context, this.fFactory, n, 111, this.fFactory.makeConstant((Object)fakeArguments[i + 3]), this.fFactory.makeConstant(paramTypes.get(i + 2)));
                ++i;
            }
        }
        bodyNodes[0] = this.makeNode((WalkContext)context, this.fFactory, n, 102, children);
        i = 0;
        while (i < inits.size()) {
            bodyNodes[i + 1] = this.visitFieldInitNode(inits.get(i), context);
            ++i;
        }
        if (nonDefaultCtor != null) {
            bodyNodes[bodyNodes.length - 1] = this.visitNode((ASTNode)nonDefaultCtor.getBody(), context);
        }
        CAstNode ast = this.makeNode((WalkContext)context, this.fFactory, n, 3, bodyNodes);
        return new ProcedureEntity(ast, fakeCtor, newType, memberEntities, context, paramTypes, null, this.handleAnnotations((IBinding)ctor));
    }

    private class AssignmentContext
    extends DelegatingContext {
        protected AssignmentContext(WalkContext parent) {
            super(parent);
        }

        @Override
        public boolean needLValue() {
            return true;
        }
    }

    private class BreakContext
    extends DelegatingContext {
        protected final String label;
        private final ASTNode breakTo;

        BreakContext(WalkContext parent, String label, ASTNode breakTo) {
            super(parent);
            this.label = label;
            this.breakTo = breakTo;
        }

        public ASTNode getBreakFor(String label) {
            return label == null || label.equals(this.label) ? this.breakTo : (ASTNode)super.getBreakFor(label);
        }
    }

    protected static final class ClassEntity
    implements CAstEntity {
        private final String fName;
        private final Collection<CAstQualifier> fQuals;
        private final Collection<CAstEntity> fEntities;
        private final ITypeBinding fJdtType;
        private final T fSourcePosition;
        private final Set<CAstAnnotation> annotations;
        final /* synthetic */ JDTJava2CAstTranslator this$0;

        public ClassEntity(ITypeBinding jdtType, String name, Collection<CAstQualifier> quals, Collection<CAstEntity> entities, T pos, Set<CAstAnnotation> annotations) {
            this.this$0 = var1_1;
            this.fName = name;
            this.fQuals = quals;
            this.fEntities = entities;
            this.fJdtType = jdtType;
            this.fSourcePosition = pos;
            this.annotations = annotations;
        }

        public Collection<CAstAnnotation> getAnnotations() {
            return null;
        }

        public int getKind() {
            return 3;
        }

        public String getName() {
            return this.fName;
        }

        public String getSignature() {
            return "L" + this.fName.replace('.', '/') + ";";
        }

        public String[] getArgumentNames() {
            return new String[0];
        }

        public CAstNode[] getArgumentDefaults() {
            return new CAstNode[0];
        }

        public int getArgumentCount() {
            return 0;
        }

        public CAstNode getAST() {
            return null;
        }

        public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
            return Collections.singletonMap(null, this.fEntities);
        }

        public Iterator getScopedEntities(CAstNode construct) {
            Assertions.UNREACHABLE((String)"Non-AST-bearing entity (ClassEntity) asked for scoped entities related to a given AST node");
            return null;
        }

        public CAstControlFlowMap getControlFlow() {
            return null;
        }

        public CAstSourcePositionMap getSourceMap() {
            return null;
        }

        public CAstSourcePositionMap.Position getPosition() {
            return this.fSourcePosition;
        }

        public CAstNodeTypeMap getNodeTypeMap() {
            return new CAstNodeTypeMap(){

                public CAstType getNodeType(CAstNode node) {
                    throw new UnsupportedOperationException();
                }

                public Collection<CAstNode> getMappedNodes() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Collection getQualifiers() {
            return this.fQuals;
        }

        public CAstType getType() {
            JDTTypeDictionary jDTTypeDictionary = this.this$0.fTypeDict;
            ((Object)((Object)jDTTypeDictionary)).getClass();
            return new JDTTypeDictionary.JdtJavaType(jDTTypeDictionary, this.fJdtType);
        }
    }

    protected static final class CompilationUnitEntity
    implements CAstEntity {
        private final String fName;
        private final Collection<CAstEntity> fTopLevelDecls;

        public CompilationUnitEntity(PackageDeclaration packageDeclaration, List<CAstEntity> topLevelDecls) {
            this.fName = packageDeclaration == null ? "" : packageDeclaration.getName().getFullyQualifiedName().replace('.', '/');
            this.fTopLevelDecls = topLevelDecls;
        }

        public Collection<CAstAnnotation> getAnnotations() {
            return null;
        }

        public int getKind() {
            return 5;
        }

        public String getName() {
            return this.fName;
        }

        public String getSignature() {
            Assertions.UNREACHABLE();
            return null;
        }

        public String[] getArgumentNames() {
            return new String[0];
        }

        public CAstNode[] getArgumentDefaults() {
            return new CAstNode[0];
        }

        public int getArgumentCount() {
            return 0;
        }

        public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
            return Collections.singletonMap(null, this.fTopLevelDecls);
        }

        public Iterator getScopedEntities(CAstNode construct) {
            Assertions.UNREACHABLE((String)"CompilationUnitEntity asked for AST-related entities, but it has no AST.");
            return null;
        }

        public CAstNode getAST() {
            return null;
        }

        public CAstControlFlowMap getControlFlow() {
            Assertions.UNREACHABLE((String)"CompilationUnitEntity.getControlFlow()");
            return null;
        }

        public CAstSourcePositionMap getSourceMap() {
            Assertions.UNREACHABLE((String)"CompilationUnitEntity.getSourceMap()");
            return null;
        }

        public CAstSourcePositionMap.Position getPosition() {
            return null;
        }

        public CAstNodeTypeMap getNodeTypeMap() {
            Assertions.UNREACHABLE((String)"CompilationUnitEntity.getNodeTypeMap()");
            return null;
        }

        public Collection getQualifiers() {
            return Collections.EMPTY_LIST;
        }

        public CAstType getType() {
            Assertions.UNREACHABLE((String)"CompilationUnitEntity.getType()");
            return null;
        }
    }

    public static class DelegatingContext
    extends TranslatorToCAst.DelegatingContext<WalkContext, ASTNode>
    implements WalkContext {
        public DelegatingContext(WalkContext parent) {
            super((TranslatorToCAst.WalkContext)parent);
        }

        @Override
        public Collection<Pair<ITypeBinding, Object>> getCatchTargets(ITypeBinding type) {
            return ((WalkContext)this.parent).getCatchTargets(type);
        }

        @Override
        public Map<ASTNode, String> getLabelMap() {
            return ((WalkContext)this.parent).getLabelMap();
        }

        @Override
        public boolean needLValue() {
            return ((WalkContext)this.parent).needLValue();
        }
    }

    protected static final class FieldEntity
    implements CAstEntity {
        private final ITypeBinding type;
        private final String name;
        private final Collection<CAstQualifier> quals;
        private final T position;
        private final Set<CAstAnnotation> annotations;
        final /* synthetic */ JDTJava2CAstTranslator this$0;

        private FieldEntity(String name, ITypeBinding type, Collection<CAstQualifier> quals, T position, Set<CAstAnnotation> annotations) {
            this.this$0 = var1_1;
            this.type = type;
            this.quals = quals;
            this.name = name;
            this.position = position;
            this.annotations = annotations;
        }

        public Collection<CAstAnnotation> getAnnotations() {
            return this.annotations;
        }

        public int getKind() {
            return 4;
        }

        public String getName() {
            return this.name;
        }

        public String getSignature() {
            return String.valueOf(this.name) + this.this$0.fIdentityMapper.typeToTypeID(this.type);
        }

        public String[] getArgumentNames() {
            return new String[0];
        }

        public CAstNode[] getArgumentDefaults() {
            return new CAstNode[0];
        }

        public int getArgumentCount() {
            return 0;
        }

        public Iterator getScopedEntities(CAstNode construct) {
            return EmptyIterator.instance();
        }

        public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
            return Collections.emptyMap();
        }

        public CAstNode getAST() {
            return null;
        }

        public CAstControlFlowMap getControlFlow() {
            return null;
        }

        public CAstSourcePositionMap getSourceMap() {
            return null;
        }

        public CAstSourcePositionMap.Position getPosition() {
            return this.position;
        }

        public CAstNodeTypeMap getNodeTypeMap() {
            return null;
        }

        public Collection getQualifiers() {
            return this.quals;
        }

        public CAstType getType() {
            return this.this$0.fTypeDict.getCAstTypeFor(this.type);
        }
    }

    private class LoopContext
    extends BreakContext {
        private final ASTNode continueTo;

        protected LoopContext(WalkContext parent, String label, ASTNode breakTo, ASTNode continueTo) {
            super(parent, label, breakTo);
            this.continueTo = continueTo;
        }

        public ASTNode getContinueFor(String label) {
            return label == null || label.equals(this.label) ? this.continueTo : (ASTNode)super.getContinueFor(label);
        }
    }

    public class MethodContext
    extends DelegatingContext {
        private final Map<CAstNode, CAstEntity> fEntities;
        private final Map<ASTNode, String> labelMap;
        final CAstSourcePositionRecorder fSourceMap;
        final CAstControlFlowRecorder fCFG;
        final CAstNodeTypeMapRecorder fNodeTypeMap;

        public MethodContext(WalkContext parent, Map<CAstNode, CAstEntity> entities) {
            super(parent);
            this.labelMap = HashMapFactory.make((int)2);
            this.fSourceMap = new CAstSourcePositionRecorder();
            this.fCFG = new CAstControlFlowRecorder((CAstSourcePositionMap)this.fSourceMap);
            this.fNodeTypeMap = new CAstNodeTypeMapRecorder();
            this.fEntities = entities;
        }

        @Override
        public Map<ASTNode, String> getLabelMap() {
            return this.labelMap;
        }

        public CAstControlFlowRecorder cfg() {
            return this.fCFG;
        }

        public void addScopedEntity(CAstNode node, CAstEntity entity) {
            this.fEntities.put(node, entity);
        }

        public CAstSourcePositionRecorder pos() {
            return this.fSourceMap;
        }

        public CAstNodeTypeMapRecorder getNodeTypeMap() {
            return this.fNodeTypeMap;
        }

        @Override
        public Collection<Pair<ITypeBinding, Object>> getCatchTargets(ITypeBinding label) {
            Set<Pair<ITypeBinding, Object>> result = Collections.singleton(Pair.make((Object)JDTJava2CAstTranslator.this.fRuntimeExcType, (Object)CAstControlFlowMap.EXCEPTION_TO_EXIT));
            return result;
        }

        @Override
        public boolean needLValue() {
            return false;
        }
    }

    protected final class ProcedureEntity
    implements JavaProcedureEntity {
        private final Map<CAstNode, Collection<CAstEntity>> fEntities;
        private final CAstNode fAst;
        MethodDeclaration fDecl;
        private String[] fParameterNames;
        private ArrayList<CAstType> fParameterTypes;
        private MethodContext fContext;
        private ITypeBinding fType;
        protected ITypeBinding fReturnType;
        private int fModifiers;
        private final Set<CAstAnnotation> annotations;

        public Map<CAstNode, Collection<CAstEntity>> getAllScopedEntities() {
            return Collections.unmodifiableMap(this.fEntities);
        }

        public Iterator getScopedEntities(CAstNode construct) {
            if (this.fEntities.containsKey(construct)) {
                return this.fEntities.get(construct).iterator();
            }
            return EmptyIterator.instance();
        }

        public String getSignature() {
            return Util.methodEntityToSelector((CAstEntity)this).toString();
        }

        private ProcedureEntity(CAstNode mdast, MethodDeclaration decl, ITypeBinding type, Map<CAstNode, CAstEntity> entities, MethodContext context, Set<CAstAnnotation> annotations) {
            this(mdast, decl, type, entities, context, null, null, decl.getModifiers(), annotations);
        }

        private ProcedureEntity(CAstNode mdast, ITypeBinding type, Map<CAstNode, CAstEntity> entities, MethodContext context, Set<CAstAnnotation> annotations) {
            this(mdast, null, type, entities, context, null, null, 0, annotations);
        }

        private ProcedureEntity(CAstNode mdast, MethodDeclaration decl, ITypeBinding type, Map<CAstNode, CAstEntity> entities, MethodContext context, ArrayList<CAstType> parameterTypes, ITypeBinding returnType, Set<CAstAnnotation> annotations) {
            this(mdast, decl, type, entities, context, parameterTypes, returnType, decl.getModifiers(), annotations);
        }

        private ProcedureEntity(CAstNode mdast, MethodDeclaration decl, ITypeBinding type, Map<CAstNode, CAstEntity> entities, MethodContext context, ArrayList<CAstType> parameterTypes, ITypeBinding returnType, int modifiers, Set<CAstAnnotation> annotations) {
            this.fDecl = decl;
            this.fAst = mdast;
            this.fContext = context;
            this.fType = type;
            this.fReturnType = returnType;
            this.fModifiers = modifiers;
            this.annotations = annotations;
            this.fEntities = new LinkedHashMap<CAstNode, Collection<CAstEntity>>();
            for (CAstNode key : entities.keySet()) {
                this.fEntities.put(key, Collections.singleton(entities.get(key)));
            }
            if (this.fDecl != null) {
                int i = 0;
                if ((this.fModifiers & 8) != 0) {
                    this.fParameterNames = new String[this.fDecl.parameters().size()];
                    i = 0;
                } else {
                    this.fParameterNames = new String[this.fDecl.parameters().size() + 1];
                    this.fParameterNames[0] = "this";
                    i = 1;
                }
                if (parameterTypes == null) {
                    this.fParameterTypes = new ArrayList(this.fDecl.parameters().size());
                    for (Object p : this.fDecl.parameters()) {
                        this.fParameterNames[i++] = ((SingleVariableDeclaration)p).getName().getIdentifier();
                        this.fParameterTypes.add(JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(((SingleVariableDeclaration)p).resolveBinding().getType()));
                    }
                } else {
                    this.fParameterTypes = parameterTypes;
                    for (Object p : this.fDecl.parameters()) {
                        this.fParameterNames[i++] = ((SingleVariableDeclaration)p).getName().getIdentifier();
                    }
                }
            } else {
                this.fParameterNames = new String[0];
                this.fParameterTypes = new ArrayList(0);
            }
        }

        public Collection<CAstAnnotation> getAnnotations() {
            return this.annotations;
        }

        public String toString() {
            return this.fDecl == null ? "<clinit>" : this.fDecl.toString();
        }

        public int getKind() {
            return 1;
        }

        public String getName() {
            if (this.fDecl == null) {
                return MethodReference.clinitName.toString();
            }
            if (this.fDecl.isConstructor()) {
                return MethodReference.initAtom.toString();
            }
            return this.fDecl.getName().getIdentifier();
        }

        public String[] getArgumentNames() {
            return this.fParameterNames;
        }

        public CAstNode[] getArgumentDefaults() {
            return new CAstNode[0];
        }

        public int getArgumentCount() {
            return this.fParameterNames.length;
        }

        public CAstNode getAST() {
            return this.fAst;
        }

        public CAstControlFlowMap getControlFlow() {
            return this.fContext.cfg();
        }

        public CAstSourcePositionMap getSourceMap() {
            return this.fContext.pos();
        }

        public CAstSourcePositionMap.Position getPosition() {
            return this.fDecl == null ? this.getSourceMap().getPosition(this.fAst) : JDTJava2CAstTranslator.this.makePosition((ASTNode)this.fDecl);
        }

        public CAstNodeTypeMap getNodeTypeMap() {
            return this.fContext.getNodeTypeMap();
        }

        public Collection getQualifiers() {
            if (this.fDecl == null) {
                return JDT2CAstUtils.mapModifiersToQualifiers(8, false, false);
            }
            return JDT2CAstUtils.mapModifiersToQualifiers(this.fModifiers, false, false);
        }

        public CAstType getType() {
            return new CAstType.Method(){
                private Collection<CAstType> fExceptionTypes = null;

                public CAstType getReturnType() {
                    Type type;
                    if (ProcedureEntity.this.fReturnType != null) {
                        return ((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(ProcedureEntity.this.fReturnType);
                    }
                    Type type2 = ProcedureEntity.this.fDecl == null ? null : (type = ((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.ast.apiLevel() == 2 ? ProcedureEntity.this.fDecl.getReturnType() : ProcedureEntity.this.fDecl.getReturnType2());
                    if (type == null) {
                        return ((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.ast.resolveWellKnownType("void"));
                    }
                    return ((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(type.resolveBinding());
                }

                public List<CAstType> getArgumentTypes() {
                    return ProcedureEntity.this.fParameterTypes;
                }

                public int getArgumentCount() {
                    return ProcedureEntity.this.fDecl == null ? 0 : ProcedureEntity.this.fParameterTypes.size();
                }

                public String getName() {
                    Assertions.UNREACHABLE((String)"CAstType.FunctionImpl#getName() called???");
                    return "?";
                }

                public Collection<CAstType> getSupertypes() {
                    Assertions.UNREACHABLE((String)"CAstType.FunctionImpl#getSupertypes() called???");
                    return null;
                }

                public Collection<CAstType> getExceptionTypes() {
                    if (this.fExceptionTypes == null) {
                        this.fExceptionTypes = new LinkedHashSet<CAstType>();
                        if (ProcedureEntity.this.fDecl != null) {
                            for (Object exception : ProcedureEntity.this.fDecl.thrownExceptionTypes()) {
                                this.fExceptionTypes.add(((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(((SimpleType)exception).resolveBinding()));
                            }
                        }
                    }
                    return this.fExceptionTypes;
                }

                public CAstType getDeclaringType() {
                    return ((ProcedureEntity)ProcedureEntity.this).JDTJava2CAstTranslator.this.fTypeDict.getCAstTypeFor(ProcedureEntity.this.fType);
                }
            };
        }
    }

    public static class RootContext
    extends TranslatorToCAst.RootContext<WalkContext, ASTNode>
    implements WalkContext {
        @Override
        public Collection<Pair<ITypeBinding, Object>> getCatchTargets(ITypeBinding type) {
            Assertions.UNREACHABLE((String)"RootContext.getCatchTargets()");
            return null;
        }

        @Override
        public Map<ASTNode, String> getLabelMap() {
            Assertions.UNREACHABLE((String)"RootContext.getLabelMap()");
            return null;
        }

        @Override
        public boolean needLValue() {
            Assertions.UNREACHABLE((String)"Rootcontext.needLValue()");
            return false;
        }
    }

    private static class TryCatchContext
    extends DelegatingContext {
        Collection<Pair<ITypeBinding, Object>> fCatchNodes = new ArrayList<Pair<ITypeBinding, Object>>();

        TryCatchContext(WalkContext parent, TryStatement tryNode) {
            super(parent);
            for (CatchClause c : tryNode.catchClauses()) {
                Pair p = Pair.make((Object)c.getException().resolveBinding().getType(), (Object)c);
                this.fCatchNodes.add((Pair<ITypeBinding, Object>)p);
            }
        }

        @Override
        public Collection<Pair<ITypeBinding, Object>> getCatchTargets(ITypeBinding label) {
            ArrayList<Pair<ITypeBinding, Object>> catchNodes = new ArrayList<Pair<ITypeBinding, Object>>();
            for (Pair<ITypeBinding, Object> p : this.fCatchNodes) {
                ITypeBinding catchType = (ITypeBinding)p.fst;
                assert (!(catchNodes instanceof FakeExceptionTypeBinding)) : "catchNodes instanceof FakeExceptionTypeBinary!";
                if (label.isSubTypeCompatible(catchType) || label.isEqualTo((IBinding)catchType)) {
                    catchNodes.add(p);
                    return catchNodes;
                }
                if (!catchType.isSubTypeCompatible(label)) continue;
                catchNodes.add(p);
            }
            catchNodes.addAll(((WalkContext)this.parent).getCatchTargets(label));
            return catchNodes;
        }
    }

    public static interface WalkContext
    extends TranslatorToCAst.WalkContext<WalkContext, ASTNode> {
        public Collection<Pair<ITypeBinding, Object>> getCatchTargets(ITypeBinding var1);

        public Map<ASTNode, String> getLabelMap();

        public boolean needLValue();
    }
}

