/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.TypeReference;
import edu.cuny.hunter.streamrefactoring.core.analysis.CannotExtractSpliteratorException;
import edu.cuny.hunter.streamrefactoring.core.analysis.InconsistentPossibleOrderingException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoninstantiableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoniterableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Ordering;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import java.util.Spliterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.BaseStream;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;
import org.objenesis.instantiator.ObjectInstantiator;

class OrderingInference {
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private IClassHierarchy classHierarchy;
    private Objenesis objenesis = new ObjenesisStd();

    public OrderingInference(IClassHierarchy classHierarchy) {
        this.classHierarchy = classHierarchy;
    }

    private Object createInstance(Class<?> clazz) throws NoninstantiableException {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            ObjectInstantiator instantiator = this.objenesis.getInstantiatorOf(clazz);
            try {
                return instantiator.newInstance();
            }
            catch (InstantiationError e2) {
                throw new NoninstantiableException(clazz + " cannot be instantiated: " + e2.getCause(), e2, clazz);
            }
        }
    }

    private String findStreamCreationMethod(Collection<TypeAbstraction> types) {
        for (TypeAbstraction typeAbstraction : types) {
            String methodName = this.findStreamCreationMethod(typeAbstraction);
            if (methodName == null) continue;
            return methodName;
        }
        return null;
    }

    private String findStreamCreationMethod(IClass type) {
        Collection allMethods = type.getAllMethods();
        for (IMethod method : allMethods) {
            TypeReference typeToCheck = Util.getEvaluationType(method);
            if (!Util.implementsBaseStream(typeToCheck, this.getClassHierarchy())) continue;
            return method.getName().toString();
        }
        return null;
    }

    private String findStreamCreationMethod(TypeAbstraction typeAbstraction) {
        IClass type = typeAbstraction.getType();
        return this.findStreamCreationMethod(type);
    }

    protected IClassHierarchy getClassHierarchy() {
        return this.classHierarchy;
    }

    private Spliterator<?> getSpliterator(Object instance, String calledMethodName) throws CannotExtractSpliteratorException {
        Spliterator spliterator;
        block10: {
            Objects.requireNonNull(instance);
            Objects.requireNonNull(calledMethodName);
            spliterator = null;
            if (instance instanceof Iterable) {
                try {
                    spliterator = ((Iterable)instance).spliterator();
                }
                catch (NullPointerException e) {
                    LOGGER.log(Level.WARNING, "Possible trouble creating instance (most likely private type).", e);
                    return null;
                }
            }
            try (BaseStream baseStream = null;){
                try {
                    Method streamCreationMethod = instance.getClass().getMethod(calledMethodName, new Class[0]);
                    Object stream = streamCreationMethod.invoke(instance, new Object[0]);
                    if (stream instanceof BaseStream) {
                        baseStream = (BaseStream)stream;
                        spliterator = baseStream.spliterator();
                        break block10;
                    }
                    throw new CannotExtractSpliteratorException("Returned object of type: " + stream.getClass() + " doesn't implement BaseStream.", stream.getClass());
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new CannotExtractSpliteratorException("Cannot extract the spliterator from object of type: " + instance.getClass(), e, instance.getClass());
                }
            }
        }
        return spliterator;
    }

    Ordering inferOrdering(Collection<TypeAbstraction> possibleTypes) throws InconsistentPossibleOrderingException, NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        if (possibleTypes.isEmpty()) {
            return null;
        }
        String methodName = this.findStreamCreationMethod(possibleTypes);
        if (methodName == null) {
            LOGGER.warning(() -> "Can't find stream creation method for: " + possibleTypes);
            return null;
        }
        return this.inferOrdering(possibleTypes, methodName);
    }

    Ordering inferOrdering(Collection<TypeAbstraction> possibleTypes, org.eclipse.jdt.core.IMethod calledMethod) throws InconsistentPossibleOrderingException, NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        return this.inferOrdering(possibleTypes, calledMethod.getElementName());
    }

    private Ordering inferOrdering(Collection<TypeAbstraction> possibleTypes, String calledMethodName) throws InconsistentPossibleOrderingException, NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        Ordering ret = null;
        for (TypeAbstraction typeAbstraction : possibleTypes) {
            if (typeAbstraction == TypeAbstraction.TOP) continue;
            Ordering ordering = this.inferOrdering(typeAbstraction, calledMethodName);
            if (ret == null) {
                ret = ordering;
                continue;
            }
            if (ret == ordering) continue;
            throw new InconsistentPossibleOrderingException("Types have inconsistent orderings: " + possibleTypes);
        }
        return ret;
    }

    private Ordering inferOrdering(String className, String calledMethodName) throws NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        try {
            Class<?> clazz = Class.forName(className);
            if (!Util.isAbstractType(clazz)) {
                Object instance = this.createInstance(clazz);
                Spliterator<?> spliterator = this.getSpliterator(instance, calledMethodName);
                if (spliterator == null) {
                    LOGGER.warning("Can't extract spliterator. Defaulting to: " + (Object)((Object)Ordering.ORDERED));
                    return Ordering.ORDERED;
                }
                boolean ordered = spliterator.hasCharacteristics(16);
                if (!ordered) {
                    return Ordering.UNORDERED;
                }
                return Ordering.ORDERED;
            }
            throw new NoninstantiableException(clazz + " cannot be instantiated because it is an interface.", clazz);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.WARNING, "Can't find: " + className + ". Falling back to: " + (Object)((Object)Ordering.ORDERED), e);
            return Ordering.ORDERED;
        }
    }

    private Ordering inferOrdering(TypeAbstraction type, String calledMethodName) throws NoniterableException, NoninstantiableException, CannotExtractSpliteratorException {
        TypeReference typeReference = type.getTypeReference();
        if (typeReference.isArrayType()) {
            return Ordering.ORDERED;
        }
        String binaryName = Util.getBinaryName(typeReference);
        return this.inferOrdering(binaryName, calledMethodName);
    }
}

