/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.analysis;

import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.cast.java.translator.jdt.JDTIdentityMapper;
import com.ibm.wala.classLoader.IBytecodeMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInvokeInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import edu.cuny.hunter.streamrefactoring.core.analysis.CannotExtractSpliteratorException;
import edu.cuny.hunter.streamrefactoring.core.analysis.ExecutionMode;
import edu.cuny.hunter.streamrefactoring.core.analysis.InconsistentPossibleOrderingException;
import edu.cuny.hunter.streamrefactoring.core.analysis.InstanceKeyNotFoundException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoEnclosingMethodNodeFoundException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoninstantiableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.NoniterableException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Ordering;
import edu.cuny.hunter.streamrefactoring.core.analysis.OrderingInference;
import edu.cuny.hunter.streamrefactoring.core.analysis.PreconditionFailure;
import edu.cuny.hunter.streamrefactoring.core.analysis.PreconditionSuccess;
import edu.cuny.hunter.streamrefactoring.core.analysis.Refactoring;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamCreationNotConsideredException;
import edu.cuny.hunter.streamrefactoring.core.analysis.TransformationAction;
import edu.cuny.hunter.streamrefactoring.core.analysis.UnhandledCaseException;
import edu.cuny.hunter.streamrefactoring.core.analysis.Util;
import edu.cuny.hunter.streamrefactoring.core.safe.NoApplicationCodeExistsInCallStringsException;
import edu.cuny.hunter.streamrefactoring.core.wala.EclipseProjectAnalysisEngine;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.osgi.framework.FrameworkUtil;

public class Stream {
    private static final String BASE_STREAM_TYPE_NAME = "BaseStream";
    private static final String GENERATE_METHOD_ID = "generate(java.util.function.Supplier)";
    private static final String JAVA_UTIL_STREAM_DOUBLE_STREAM = "java.util.stream.DoubleStream";
    private static final String JAVA_UTIL_STREAM_INT_STREAM = "java.util.stream.IntStream";
    private static final String JAVA_UTIL_STREAM_LONG_STREAM = "java.util.stream.LongStream";
    private static final String JAVA_UTIL_STREAM_STREAM = "java.util.stream.Stream";
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static final String PARALLEL_STREAM_CREATION_METHOD_ID = "parallelStream()";
    private static final String PLUGIN_ID = FrameworkUtil.getBundle(Stream.class).getSymbolicName();
    private Set<TransformationAction> actions;
    private final MethodInvocation creation;
    private final MethodDeclaration enclosingMethodDeclaration;
    private IR enclosingMethodDeclarationIR;
    private final TypeDeclaration enclosingTypeDeclaration;
    private boolean hasNoTerminalOperation;
    private boolean hasPossibleSideEffects;
    private boolean hasPossibleStatefulIntermediateOperations;
    private ExecutionMode initialExecutionMode;
    private Ordering initialOrdering;
    private InstanceKey instanceKey;
    private Optional<SSAInvokeInstruction> instructionForCreation;
    private PreconditionSuccess passingPrecondition;
    private Set<ExecutionMode> possibleExecutionModes = new HashSet<ExecutionMode>();
    private Set<Ordering> possibleOrderings = new HashSet<Ordering>();
    private boolean reduceOrderingPossiblyMatters;
    private Refactoring refactoring;
    private RefactoringStatus status = new RefactoringStatus();

    public Stream(MethodInvocation streamCreation) throws ClassHierarchyException, IOException, CoreException, InvalidClassFileException, CallGraphBuilderCancelException, CancelException {
        this.creation = streamCreation;
        this.enclosingTypeDeclaration = (TypeDeclaration)ASTNodes.getParent((ASTNode)this.getCreation(), (int)55);
        this.enclosingMethodDeclaration = (MethodDeclaration)ASTNodes.getParent((ASTNode)this.getCreation(), (int)31);
        if (this.enclosingMethodDeclaration == null) {
            LOGGER.warning("Stream: " + this.creation + " not handled.");
            this.addStatusEntry(PreconditionFailure.CURRENTLY_NOT_HANDLED, "Stream: " + this.creation + " is most likely used in a context that is currently not handled by this plug-in.");
        }
    }

    protected void addPossibleExecutionMode(ExecutionMode executionMode) {
        this.possibleExecutionModes.add(executionMode);
    }

    protected void addPossibleExecutionModeCollection(Collection<? extends ExecutionMode> executionModeCollection) {
        this.possibleExecutionModes.addAll(executionModeCollection);
    }

    protected void addPossibleOrderingCollection(Collection<? extends Ordering> orderingCollection) {
        this.possibleOrderings.addAll(orderingCollection);
    }

    void addStatusEntry(PreconditionFailure failure, String message) {
        MethodInvocation creation = this.getCreation();
        CompilationUnit compilationUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)creation, (int)15);
        ICompilationUnit compilationUnit2 = (ICompilationUnit)compilationUnit.getJavaElement();
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)compilationUnit2, (ASTNode)creation);
        this.getStatus().addEntry(3, message, context, PLUGIN_ID, failure.getCode(), (Object)this);
    }

    protected void check() {
        Set<ExecutionMode> possibleExecutionModes = this.getPossibleExecutionModes();
        Set<Ordering> possibleOrderings = this.getPossibleOrderings();
        boolean hasPossibleSideEffects = this.hasPossibleSideEffects();
        boolean hasPossibleStatefulIntermediateOperations = this.hasPossibleStatefulIntermediateOperations();
        boolean reduceOrderingPossiblyMatters = this.reduceOrderingPossiblyMatters();
        boolean hasNoTerminalOperation = this.hasNoTerminalOperation();
        LOGGER.fine("Execution modes: " + possibleExecutionModes);
        LOGGER.fine("Orderings: " + possibleOrderings);
        LOGGER.fine("Side-effects: " + hasPossibleSideEffects);
        LOGGER.fine("Stateful intermediate operations: " + hasPossibleStatefulIntermediateOperations);
        LOGGER.fine("Reduce ordering matters: " + reduceOrderingPossiblyMatters);
        LOGGER.fine("Terminal operation: " + hasNoTerminalOperation);
        MethodInvocation creation = this.getCreation();
        if (hasNoTerminalOperation) {
            LOGGER.warning(() -> "Require terminal operations: " + creation);
            this.addStatusEntry(PreconditionFailure.NO_TERMINAL_OPERATIONS, "Require terminal operations: " + creation + ".");
            return;
        }
        if (this.isConsistent(possibleExecutionModes, PreconditionFailure.INCONSISTENT_POSSIBLE_EXECUTION_MODES, "Stream: " + creation + " has inconsitent possible execution modes.", creation) && this.isConsistent(possibleOrderings, PreconditionFailure.INCONSISTENT_POSSIBLE_ORDERINGS, "Stream: " + creation + " has inconsitent possible orderings.", creation)) {
            ExecutionMode executionMode = possibleExecutionModes.iterator().next();
            assert (executionMode != null) : "Execution mode is null";
            Ordering ordering = possibleOrderings.iterator().next();
            assert (ordering != null) : "Ordering is null";
            block0 : switch (executionMode) {
                case SEQUENTIAL: {
                    switch (ordering) {
                        case UNORDERED: {
                            if (hasPossibleSideEffects) {
                                this.addStatusEntry(PreconditionFailure.HAS_SIDE_EFFECTS, "Stream: " + creation + " is associated with a behavioral parameter containing possible side-effects");
                                break;
                            }
                            this.setRefactoring(Refactoring.CONVERT_SEQUENTIAL_STREAM_TO_PARALLEL);
                            this.setTransformationAction(TransformationAction.CONVERT_TO_PARALLEL);
                            this.setPassingPrecondition(PreconditionSuccess.P1);
                            break;
                        }
                        case ORDERED: {
                            if (hasPossibleSideEffects) {
                                this.addStatusEntry(PreconditionFailure.HAS_SIDE_EFFECTS2, "Stream: " + creation + " is associated with a behavioral parameter containing possible side-effects");
                                break;
                            }
                            if (!hasPossibleStatefulIntermediateOperations) {
                                this.setRefactoring(Refactoring.CONVERT_SEQUENTIAL_STREAM_TO_PARALLEL);
                                this.setTransformationAction(TransformationAction.CONVERT_TO_PARALLEL);
                                this.setPassingPrecondition(PreconditionSuccess.P2);
                                break;
                            }
                            if (!reduceOrderingPossiblyMatters) {
                                this.setRefactoring(Refactoring.CONVERT_SEQUENTIAL_STREAM_TO_PARALLEL);
                                this.setTransformationAction(TransformationAction.UNORDER, TransformationAction.CONVERT_TO_PARALLEL);
                                this.setPassingPrecondition(PreconditionSuccess.P3);
                                break;
                            }
                            this.addStatusEntry(PreconditionFailure.REDUCE_ORDERING_MATTERS, "Ordering of the result produced by a terminal operation must be preserved");
                        }
                    }
                    break;
                }
                case PARALLEL: {
                    switch (ordering) {
                        case ORDERED: {
                            if (hasPossibleStatefulIntermediateOperations) {
                                if (!reduceOrderingPossiblyMatters) {
                                    this.setRefactoring(Refactoring.OPTIMIZE_PARALLEL_STREAM);
                                    this.setTransformationAction(TransformationAction.UNORDER);
                                    this.setPassingPrecondition(PreconditionSuccess.P4);
                                    break block0;
                                }
                                this.setRefactoring(Refactoring.OPTIMIZE_PARALLEL_STREAM);
                                this.setTransformationAction(TransformationAction.CONVERT_TO_SEQUENTIAL);
                                this.setPassingPrecondition(PreconditionSuccess.P5);
                                break block0;
                            }
                            this.addStatusEntry(PreconditionFailure.NO_STATEFUL_INTERMEDIATE_OPERATIONS, "No stateful intermediate operation exists within the stream's pipeline.");
                            break block0;
                        }
                        case UNORDERED: {
                            this.addStatusEntry(PreconditionFailure.UNORDERED, "Stream is unordered.");
                        }
                    }
                }
            }
        }
    }

    protected InstanceKey computeInstanceKey(Collection<InstanceKey> trackedInstances, EclipseProjectAnalysisEngine<InstanceKey> engine) throws InvalidClassFileException, IOException, CoreException, UnhandledCaseException, NoApplicationCodeExistsInCallStringsException, InstanceKeyNotFoundException {
        Optional<SSAInvokeInstruction> instructionForCreation = this.getInstructionForCreation(engine);
        if (instructionForCreation.isPresent()) {
            SSAInvokeInstruction instruction = instructionForCreation.get();
            for (InstanceKey ik : trackedInstances) {
                if (!edu.cuny.hunter.streamrefactoring.core.safe.Util.instanceKeyCorrespondsWithInstantiationInstruction(ik, instruction, this.getEnclosingMethodReference(), engine)) continue;
                return ik;
            }
        }
        throw new InstanceKeyNotFoundException("Can't find instance key for: " + this.getCreation() + " using tracked instances: " + trackedInstances);
    }

    public Set<TransformationAction> getActions() {
        if (this.actions != null) {
            return Collections.unmodifiableSet(this.actions);
        }
        return null;
    }

    public MethodInvocation getCreation() {
        return this.creation;
    }

    public IJavaProject getCreationJavaProject() {
        return this.getEnclosingEclipseMethod().getJavaProject();
    }

    public CompilationUnit getEnclosingCompilationUnit() {
        return (CompilationUnit)ASTNodes.getParent((ASTNode)this.getEnclosingTypeDeclaration(), (int)15);
    }

    public IMethod getEnclosingEclipseMethod() {
        MethodDeclaration enclosingMethodDeclaration = this.getEnclosingMethodDeclaration();
        if (enclosingMethodDeclaration == null) {
            return null;
        }
        IMethodBinding binding = enclosingMethodDeclaration.resolveBinding();
        return (IMethod)binding.getJavaElement();
    }

    public MethodDeclaration getEnclosingMethodDeclaration() {
        return this.enclosingMethodDeclaration;
    }

    private IR getEnclosingMethodIR(EclipseProjectAnalysisEngine<InstanceKey> engine) throws IOException, CoreException, UnhandledCaseException {
        if (this.enclosingMethodDeclarationIR == null) {
            com.ibm.wala.classLoader.IMethod resolvedMethod = this.getEnclosingWalaMethod(engine);
            if (resolvedMethod == null) {
                throw new UnhandledCaseException("Couldn't retrieve enclosing WALA method. Most likely an AIC #155.");
            }
            this.enclosingMethodDeclarationIR = engine.getCache().getIR(resolvedMethod);
            if (this.enclosingMethodDeclarationIR == null) {
                throw new IllegalStateException("IR is null for: " + resolvedMethod);
            }
            LOGGER.fine("IR is: " + this.enclosingMethodDeclarationIR);
        }
        return this.enclosingMethodDeclarationIR;
    }

    protected Collection<CGNode> getEnclosingMethodNodes(EclipseProjectAnalysisEngine<InstanceKey> engine) throws IOException, CoreException, NoEnclosingMethodNodeFoundException {
        MethodReference methodReference = this.getEnclosingMethodReference();
        Set nodes = engine.getCallGraph().getNodes(methodReference);
        if (nodes.isEmpty()) {
            throw new NoEnclosingMethodNodeFoundException(methodReference);
        }
        return nodes;
    }

    MethodReference getEnclosingMethodReference() {
        MethodDeclaration enclosingMethodDeclaration = this.getEnclosingMethodDeclaration();
        JDTIdentityMapper mapper = Util.getJDTIdentifyMapper((ASTNode)enclosingMethodDeclaration);
        MethodReference methodRef = mapper.getMethodRef(enclosingMethodDeclaration.resolveBinding());
        if (methodRef == null) {
            throw new IllegalStateException("Could not get method reference for: " + enclosingMethodDeclaration.getName());
        }
        return methodRef;
    }

    public IType getEnclosingType() {
        MethodDeclaration enclosingMethodDeclaration = this.getEnclosingMethodDeclaration();
        if (enclosingMethodDeclaration == null) {
            return null;
        }
        IMethodBinding binding = enclosingMethodDeclaration.resolveBinding();
        return (IType)binding.getDeclaringClass().getJavaElement();
    }

    public TypeDeclaration getEnclosingTypeDeclaration() {
        return this.enclosingTypeDeclaration;
    }

    public TypeReference getEnclosingTypeReference() {
        JDTIdentityMapper mapper = Util.getJDTIdentifyMapper((ASTNode)this.getEnclosingTypeDeclaration());
        TypeReference ref = mapper.getTypeRef(this.getEnclosingTypeDeclaration().resolveBinding());
        if (ref == null) {
            throw new IllegalStateException("Could not get type reference for: " + this.getEnclosingTypeDeclaration().getName());
        }
        return ref;
    }

    public com.ibm.wala.classLoader.IMethod getEnclosingWalaMethod(EclipseProjectAnalysisEngine<InstanceKey> engine) throws IOException, CoreException {
        IClassHierarchy classHierarchy = engine.getClassHierarchy();
        MethodReference methodRef = this.getEnclosingMethodReference();
        com.ibm.wala.classLoader.IMethod resolvedMethod = classHierarchy.resolveMethod(methodRef);
        return resolvedMethod;
    }

    protected ExecutionMode getInitialExecutionMode() {
        return this.initialExecutionMode;
    }

    protected Ordering getInitialOrdering() {
        return this.initialOrdering;
    }

    public InstanceKey getInstanceKey(Collection<InstanceKey> trackedInstances, EclipseProjectAnalysisEngine<InstanceKey> engine) throws InvalidClassFileException, IOException, CoreException, InstanceKeyNotFoundException, UnhandledCaseException, NoApplicationCodeExistsInCallStringsException {
        if (this.instanceKey == null) {
            this.instanceKey = this.computeInstanceKey(trackedInstances, engine);
        }
        return this.instanceKey;
    }

    Optional<SSAInvokeInstruction> getInstructionForCreation(EclipseProjectAnalysisEngine<InstanceKey> engine) throws InvalidClassFileException, IOException, CoreException, UnhandledCaseException {
        if (this.instructionForCreation == null) {
            IR enclosingMethodIR = this.getEnclosingMethodIR(engine);
            IBytecodeMethod method = (IBytecodeMethod)enclosingMethodIR.getMethod();
            SimpleName methodName = this.getCreation().getName();
            Iterator it = enclosingMethodIR.iterateNormalInstructions();
            while (it.hasNext()) {
                int lineNumberFromAST;
                SSAInstruction instruction = (SSAInstruction)it.next();
                int lineNumberFromIR = Util.getLineNumberFromIR(method, instruction);
                if (lineNumberFromIR != (lineNumberFromAST = Util.getLineNumberFromAST(methodName)) || !Util.matches(instruction, this.getCreation(), Optional.of(LOGGER))) continue;
                this.instructionForCreation = Optional.of((SSAInvokeInstruction)instruction);
                return this.instructionForCreation;
            }
            this.instructionForCreation = Optional.empty();
        }
        return this.instructionForCreation;
    }

    private JDTIdentityMapper getJDTIdentifyMapperForCreation() {
        return Util.getJDTIdentifyMapper((ASTNode)this.getCreation());
    }

    public PreconditionSuccess getPassingPrecondition() {
        return this.passingPrecondition;
    }

    public Set<ExecutionMode> getPossibleExecutionModes() {
        ExecutionMode initialExecutionMode = this.getInitialExecutionMode();
        if (this.possibleExecutionModes.isEmpty()) {
            if (initialExecutionMode == null) {
                return null;
            }
            return Collections.singleton(initialExecutionMode);
        }
        return this.possibleExecutionModes.stream().map(e -> e == null ? initialExecutionMode : e).collect(Collectors.toSet());
    }

    public Set<Ordering> getPossibleOrderings() {
        Ordering initialOrdering = this.getInitialOrdering();
        if (this.possibleOrderings.isEmpty()) {
            if (initialOrdering == null) {
                return null;
            }
            return Collections.singleton(initialOrdering);
        }
        return this.possibleOrderings.stream().map(e -> e == null ? initialOrdering : e).collect(Collectors.toSet());
    }

    public Refactoring getRefactoring() {
        return this.refactoring;
    }

    public RefactoringStatus getStatus() {
        return this.status;
    }

    public TypeReference getTypeReference() {
        ITypeBinding[] allSuperTypes;
        JDTIdentityMapper mapper = this.getJDTIdentifyMapperForCreation();
        ITypeBinding typeBinding = this.getCreation().resolveTypeBinding();
        ITypeBinding[] iTypeBindingArray = allSuperTypes = Bindings.getAllSuperTypes((ITypeBinding)typeBinding);
        int n = allSuperTypes.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding supertype = iTypeBindingArray[n2];
            if (supertype.isInterface() && supertype.getName().startsWith(BASE_STREAM_TYPE_NAME)) {
                typeBinding = supertype;
                break;
            }
            ++n2;
        }
        TypeReference typeRef = mapper.getTypeRef(typeBinding);
        return typeRef;
    }

    private int getUseValueNumberForCreation(EclipseProjectAnalysisEngine<InstanceKey> engine) throws InvalidClassFileException, IOException, CoreException, UnhandledCaseException {
        return this.getInstructionForCreation(engine).map(i -> i.getUse(0)).orElse(-1);
    }

    public boolean hasNoTerminalOperation() {
        return this.hasNoTerminalOperation;
    }

    public boolean hasPossibleSideEffects() {
        return this.hasPossibleSideEffects;
    }

    public boolean hasPossibleStatefulIntermediateOperations() {
        return this.hasPossibleStatefulIntermediateOperations;
    }

    public void inferInitialAttributes(EclipseProjectAnalysisEngine<InstanceKey> engine, OrderingInference orderingInference) throws InvalidClassFileException, IOException, CoreException, UnhandledCaseException, StreamCreationNotConsideredException {
        this.inferInitialExecution();
        this.inferInitialOrdering(engine, orderingInference);
    }

    private void inferInitialExecution() throws JavaModelException {
        String methodIdentifier = edu.cuny.hunter.streamrefactoring.core.utils.Util.getMethodIdentifier((IMethod)this.getCreation().resolveMethodBinding().getJavaElement());
        if (methodIdentifier.equals(PARALLEL_STREAM_CREATION_METHOD_ID)) {
            this.setInitialExecutionMode(ExecutionMode.PARALLEL);
        } else {
            this.setInitialExecutionMode(ExecutionMode.SEQUENTIAL);
        }
    }

    private void inferInitialOrdering(EclipseProjectAnalysisEngine<InstanceKey> engine, OrderingInference orderingInference) throws InvalidClassFileException, IOException, CoreException, UnhandledCaseException, StreamCreationNotConsideredException {
        block27: {
            IMethodBinding calledMethodBinding;
            block25: {
                if (this.getCreation().getExpression() == null) {
                    if (this.getCreation().toString().startsWith("concat(")) {
                        throw new UnhandledCaseException("concat() is not yet implemented.");
                    }
                    throw new StreamCreationNotConsideredException("Creation: " + this.getCreation() + " is not considered to create a new stream.");
                }
                ITypeBinding expressionTypeBinding = this.getCreation().getExpression().resolveTypeBinding();
                String expressionTypeQualifiedName = expressionTypeBinding.getErasure().getQualifiedName();
                calledMethodBinding = this.getCreation().resolveMethodBinding();
                if (!JdtFlags.isStatic((IMethodBinding)calledMethodBinding)) break block25;
                switch (expressionTypeQualifiedName) {
                    case "java.util.stream.LongStream": 
                    case "java.util.stream.DoubleStream": 
                    case "java.util.stream.IntStream": 
                    case "java.util.stream.Stream": {
                        String methodIdentifier = edu.cuny.hunter.streamrefactoring.core.utils.Util.getMethodIdentifier((IMethod)calledMethodBinding.getJavaElement());
                        if (methodIdentifier.equals(GENERATE_METHOD_ID)) {
                            this.setInitialOrdering(Ordering.UNORDERED);
                            break;
                        }
                        this.setInitialOrdering(Ordering.ORDERED);
                        break;
                    }
                    default: {
                        Ordering defaultOrdering = Ordering.ORDERED;
                        LOGGER.warning(() -> "Unhandled expression type qualified name: " + expressionTypeQualifiedName + ". Falling back to: " + (Object)((Object)defaultOrdering) + ".");
                        this.setInitialOrdering(defaultOrdering);
                        break;
                    }
                }
                break block27;
            }
            int valueNumber = this.getUseValueNumberForCreation(engine);
            if (valueNumber < 0) {
                LOGGER.warning("Use value number: " + valueNumber + " for stream creation: " + this.getCreation().getName() + " is invalid. Most likely #155.");
                throw new UnhandledCaseException("Encountered unhandled case, most likely an embedded stream.");
            }
            Collection<CGNode> nodeCollection = null;
            try {
                nodeCollection = this.getEnclosingMethodNodes(engine);
            }
            catch (NoEnclosingMethodNodeFoundException e) {
                LOGGER.log(Level.WARNING, "Can't find enclosing method nodes for " + this.getCreation() + ". Falling back to: " + (Object)((Object)Ordering.ORDERED) + ".", e);
                this.setInitialOrdering(Ordering.ORDERED);
                return;
            }
            Collection<TypeAbstraction> possibleTypes = null;
            IMethod calledMethod = null;
            Ordering ordering = null;
            try {
                possibleTypes = Util.getPossibleTypesInterprocedurally(nodeCollection, valueNumber, engine, orderingInference);
                calledMethod = (IMethod)calledMethodBinding.getJavaElement();
                ordering = orderingInference.inferOrdering(possibleTypes, calledMethod);
            }
            catch (NoniterableException e) {
                LOGGER.log(Level.WARNING, "Stream: " + this.getCreation() + " has a non-iterable possible source. Falling back to: " + (Object)((Object)Ordering.ORDERED) + ".", e);
                ordering = Ordering.ORDERED;
            }
            catch (NoninstantiableException e) {
                LOGGER.log(Level.WARNING, "Stream: " + this.getCreation() + " has a non-instantiable possible source with type: " + e.getSourceType() + ". Falling back to: " + (Object)((Object)Ordering.ORDERED) + ".", e);
                ordering = Ordering.ORDERED;
            }
            catch (CannotExtractSpliteratorException e) {
                LOGGER.log(Level.WARNING, "Cannot extract spliterator from type: " + e.getFromType() + " for stream: " + this.getCreation() + ". Falling back to: " + (Object)((Object)Ordering.ORDERED) + ".", e);
                ordering = Ordering.ORDERED;
            }
            catch (InconsistentPossibleOrderingException e) {
                LOGGER.log(Level.WARNING, "Stream: " + this.getCreation() + " has inconsistent possible source orderings. Falling back to: " + (Object)((Object)Ordering.ORDERED) + ".", e);
                ordering = Ordering.ORDERED;
            }
            if (ordering == null) {
                ordering = Ordering.ORDERED;
                LOGGER.warning("Can't find ordering for: " + possibleTypes + " using: " + calledMethod + ". Falling back to: " + (Object)((Object)ordering));
            }
            this.setInitialOrdering(ordering);
        }
    }

    private boolean isConsistent(Collection<?> collection, PreconditionFailure failure, String failureMessage, MethodInvocation streamCreation) {
        if (!Util.allEqual(collection)) {
            this.addStatusEntry(failure, failureMessage);
            return false;
        }
        return true;
    }

    public boolean reduceOrderingPossiblyMatters() {
        return this.reduceOrderingPossiblyMatters;
    }

    public void setHasNoTerminalOperation(boolean hasNoTerminalOperation) {
        this.hasNoTerminalOperation = hasNoTerminalOperation;
    }

    protected void setHasPossibleSideEffects(boolean hasPossibleSideEffects) {
        this.hasPossibleSideEffects = hasPossibleSideEffects;
    }

    protected void setHasPossibleStatefulIntermediateOperations(boolean hasPossibleStatefulIntermediateOperations) {
        this.hasPossibleStatefulIntermediateOperations = hasPossibleStatefulIntermediateOperations;
    }

    protected void setInitialExecutionMode(ExecutionMode initialExecutionMode) {
        Objects.requireNonNull(initialExecutionMode);
        this.initialExecutionMode = initialExecutionMode;
    }

    protected void setInitialOrdering(Ordering initialOrdering) {
        Objects.requireNonNull(initialOrdering);
        this.initialOrdering = initialOrdering;
    }

    private void setPassingPrecondition(PreconditionSuccess succcess) {
        if (this.passingPrecondition != null) {
            throw new IllegalStateException("Passing precondition being set twice.");
        }
        this.passingPrecondition = succcess;
    }

    protected void setReduceOrderingPossiblyMatters(boolean reduceOrderingPossiblyMatters) {
        this.reduceOrderingPossiblyMatters = reduceOrderingPossiblyMatters;
    }

    protected void setRefactoring(Refactoring refactoring) {
        if (this.refactoring != null) {
            throw new IllegalStateException("Refactoring being set twice.");
        }
        this.refactoring = refactoring;
    }

    protected void setTransformationAction(TransformationAction ... actions) {
        if (this.actions != null) {
            throw new IllegalStateException("Tranformation being set twice.");
        }
        this.actions = new HashSet<TransformationAction>(Arrays.asList(actions));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Stream [actions=");
        builder.append(this.actions);
        builder.append(", creation=");
        builder.append(this.creation);
        builder.append(", enclosingMethodDeclaration=");
        builder.append(this.enclosingMethodDeclaration.getName());
        builder.append(", hasPossibleSideEffects=");
        builder.append(this.hasPossibleSideEffects);
        builder.append(", hasPossibleStatefulIntermediateOperations=");
        builder.append(this.hasPossibleStatefulIntermediateOperations);
        builder.append(", hasNoTerminalOperation=");
        builder.append(this.hasNoTerminalOperation);
        builder.append(", initialExecutionMode=");
        builder.append((Object)this.initialExecutionMode);
        builder.append(", initialOrdering=");
        builder.append((Object)this.initialOrdering);
        builder.append(", passingPrecondition=");
        builder.append((Object)this.passingPrecondition);
        builder.append(", possibleExecutionModes=");
        builder.append(this.possibleExecutionModes);
        builder.append(", possibleOrderings=");
        builder.append(this.possibleOrderings);
        builder.append(", reduceOrderingPossiblyMatters=");
        builder.append(this.reduceOrderingPossiblyMatters);
        builder.append(", refactoring=");
        builder.append((Object)this.refactoring);
        builder.append(", status=");
        builder.append(this.status.getSeverity());
        builder.append("]");
        return builder.toString();
    }
}

