/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.wala;

import com.ibm.wala.classLoader.BinaryDirectoryTreeModule;
import com.ibm.wala.classLoader.JarFileModule;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ide.util.JavaEclipseProjectPath;
import com.ibm.wala.util.collections.MapUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;

public class TestableJavaEclipseProjectPath
extends JavaEclipseProjectPath {
    public static EclipseProjectPath<?, IJavaProject> create(IJavaProject project, EclipseProjectPath.AnalysisScopeType scopeType) throws IOException, CoreException {
        TestableJavaEclipseProjectPath path = new TestableJavaEclipseProjectPath(scopeType);
        path.create(project.getProject());
        return path;
    }

    public TestableJavaEclipseProjectPath(EclipseProjectPath.AnalysisScopeType scopeType) throws IOException, CoreException {
        super(scopeType);
    }

    protected boolean isPrimordialJarFile(JarFile j) {
        return j.getName().endsWith("rtstubs18.jar");
    }

    protected void resolveLibraryPathEntry(EclipseProjectPath.ILoader loader, IPath p) {
        JarFile j;
        if (p.lastSegment().matches("rtstubs[0-9]*\\.jar")) {
            return;
        }
        File file = TestableJavaEclipseProjectPath.makeAbsolute((IPath)p).toFile();
        try {
            j = new JarFile(file);
        }
        catch (ZipException zipException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        if (this.isPrimordialJarFile(j)) {
            loader = EclipseProjectPath.Loader.PRIMORDIAL;
        }
        List s = MapUtil.findOrCreateList((Map)this.modules, (Object)loader);
        s.add(file.isDirectory() ? new BinaryDirectoryTreeModule(file) : new JarFileModule(j));
    }
}

