/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Debug {
    public static final boolean PRINT_CHARACTER_RANGE_TABLE = false;
    private static PrintStream OUT_STREAM = System.out;
    private static final Map<LogLevel, LogStream> logStreams = new HashMap<LogLevel, LogStream>();
    private static Set<LogLevel> allowed = new HashSet<LogLevel>();

    static {
        int i = 0;
        while (i < LogLevel.values().length) {
            allowed.add(LogLevel.values()[i]);
            ++i;
        }
    }

    private Debug() {
    }

    public static void setLogFile(String file) throws FileNotFoundException {
        OUT_STREAM = file != null && file.equals("console") ? System.out : (file != null ? new PrintStream(file) : null);
    }

    public static void setMinLogLevel(LogLevel level) {
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel l = logLevelArray[n2];
            if (l == level || l.isHigherPriority(level)) {
                Debug.allow(l);
            } else {
                Debug.ignore(l);
            }
            ++n2;
        }
    }

    public static void noLogging() {
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel l = logLevelArray[n2];
            Debug.ignore(l);
            ++n2;
        }
    }

    public static void fullLogging() {
        LogLevel[] logLevelArray = LogLevel.values();
        int n = logLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            LogLevel l = logLevelArray[n2];
            Debug.allow(l);
            ++n2;
        }
    }

    public static void error(String str, Object ... obj) {
        Debug.log(LogLevel.ERROR, String.valueOf(str) + "\n", obj);
    }

    public static void warn(String str, Object ... obj) {
        Debug.log(LogLevel.WARN, String.valueOf(str) + "\n", obj);
    }

    public static void info(String str, Object ... obj) {
        Debug.log(LogLevel.INFO, String.valueOf(str) + "\n", obj);
    }

    public static void debug(String str, Object ... obj) {
        Debug.log(LogLevel.DEBUG, String.valueOf(str) + "\n", obj);
    }

    public static void error(String str) {
        Debug.log(LogLevel.ERROR, String.valueOf(str) + "\n");
    }

    public static void warn(String str) {
        Debug.log(LogLevel.WARN, String.valueOf(str) + "\n");
    }

    public static void logTime() {
        Date date = new Date();
        Debug.log(LogLevel.INFO, "Current time: " + date + "\n");
    }

    public static void info(String str) {
        Debug.log(LogLevel.INFO, String.valueOf(str) + "\n");
    }

    public static void appendInfo(String str) {
        if (OUT_STREAM != null && allowed.contains((Object)LogLevel.INFO)) {
            OUT_STREAM.print(str);
        }
    }

    public static void debug(String str) {
        Debug.log(LogLevel.DEBUG, String.valueOf(str) + "\n");
    }

    public static void error(Throwable t) {
        Debug.log(LogLevel.ERROR, t);
    }

    public static void warn(Throwable t) {
        Debug.log(LogLevel.WARN, t);
    }

    public static void info(Throwable t) {
        Debug.log(LogLevel.INFO, t);
    }

    public static void debug(Throwable t) {
        Debug.log(LogLevel.DEBUG, t);
    }

    public static void allow(LogLevel level) {
        allowed.add(level);
    }

    public static void ignore(LogLevel level) {
        allowed.remove((Object)level);
    }

    private static void log(LogLevel level, Throwable exc) {
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        Debug.log(level, sw.toString());
    }

    private static void log(LogLevel level, String str) {
        if (OUT_STREAM != null && allowed.contains((Object)level)) {
            OUT_STREAM.print("[" + (Object)((Object)level) + "] " + str);
        }
    }

    private static void log(LogLevel level, String str, Object ... obj) {
        if (OUT_STREAM != null && allowed.contains((Object)level)) {
            OUT_STREAM.format("[" + (Object)((Object)level) + "] " + str, obj);
        }
    }

    public static PrintStream getStream(LogLevel level) {
        LogStream logStream = logStreams.get((Object)level);
        if (OUT_STREAM != null && logStream == null) {
            logStream = new LogStream((OutputStream)OUT_STREAM, level);
            logStreams.put(level, logStream);
        }
        return logStream;
    }

    public static enum LogLevel {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3);

        private final Integer priority;

        private LogLevel(int priority) {
            this.priority = priority;
        }

        public boolean isHigherPriority(LogLevel l) {
            return this.priority > l.priority;
        }
    }

    private static final class LogStream
    extends PrintStream {
        private final LogLevel level;

        LogStream(OutputStream out, LogLevel level) {
            super(out);
            this.level = level;
        }

        @Override
        public void print(String str) {
            Debug.log(this.level, str);
        }

        @Override
        public void println(String str) {
            Debug.log(this.level, String.valueOf(str) + "\n");
        }
    }
}

