/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import com.ibm.wala.sourcepos.CRTFlags;
import com.ibm.wala.sourcepos.InvalidCRTDataException;
import com.ibm.wala.sourcepos.InvalidPositionException;
import com.ibm.wala.sourcepos.InvalidRangeException;
import com.ibm.wala.sourcepos.Position;
import com.ibm.wala.sourcepos.Range;

public final class CRTData {
    private static final String WARN_INVALID_PC_RANGE = "Error at CRT entry %1$s: the program counter start index (%2$s) must be greater or equal than the end index (%3$s).";
    private static final String WARN_INVALID_START_LINE_NUMBER = "Error at CRT entry %1$s: the line number of the source start position must not be 0.";
    private static final String WARN_INVALID_START_COLUMN_NUMBER = "Error at CRT entry %1$s: the column number of the source start position not be 0.";
    private static final String WARN_INVALID_END_LINE_NUMBER = "Error at CRT entry %1$s: the line number of the source end position must not be 0.";
    private static final String WARN_INVALID_END_COLUMN_NUMBER = "Error at CRT entry %1$s: the column number of the source end position must not be 0.";
    private static final String WARN_END_BEFORE_START = "Error at CRT entry %1$s: the source end position (%3$s) is before the source start position (%2$s).";
    private static final String WARN_START_UNDEFINED = "Error at CRT entry %1$s: the source start position is undefined.";
    private static final String WARN_END_UNDEFINED = "Error at CRT entry %1$s: the source end position is undefined.";
    private final int pc_start_index;
    private final int pc_end_index;
    private final Range source_positions;
    private final CRTFlags flags;

    CRTData(short pc_start_index, short pc_end_index, int source_start_position, int source_end_position, short flags) throws InvalidCRTDataException {
        block25: {
            Position source_end;
            Position source_start;
            block23: {
                block22: {
                    this.pc_start_index = pc_start_index & 0xFFFF;
                    this.pc_end_index = pc_end_index & 0xFFFF;
                    if (pc_start_index > pc_end_index) {
                        throw new InvalidCRTDataException(WARN_INVALID_PC_RANGE, this.pc_start_index, this.pc_end_index);
                    }
                    source_start = null;
                    try {
                        source_start = new Position(source_start_position);
                    }
                    catch (InvalidPositionException e) {
                        switch (e.getThisCause()) {
                            case LINE_NUMBER_ZERO: {
                                throw new InvalidCRTDataException(WARN_INVALID_START_LINE_NUMBER);
                            }
                            case COLUMN_NUMBER_ZERO: {
                                throw new InvalidCRTDataException(WARN_INVALID_START_COLUMN_NUMBER);
                            }
                        }
                        if ($assertionsDisabled) break block22;
                        throw new AssertionError();
                    }
                }
                source_end = null;
                try {
                    source_end = new Position(source_end_position);
                }
                catch (InvalidPositionException e) {
                    switch (e.getThisCause()) {
                        case LINE_NUMBER_ZERO: {
                            throw new InvalidCRTDataException(WARN_INVALID_END_LINE_NUMBER);
                        }
                        case COLUMN_NUMBER_ZERO: {
                            throw new InvalidCRTDataException(WARN_INVALID_END_COLUMN_NUMBER);
                        }
                    }
                    if ($assertionsDisabled) break block23;
                    throw new AssertionError();
                }
            }
            Range range = null;
            try {
                try {
                    range = new Range(source_start, source_end);
                }
                catch (InvalidRangeException e) {
                    switch (e.getThisCause()) {
                        case END_BEFORE_START: {
                            throw new InvalidCRTDataException(WARN_END_BEFORE_START, source_start.toString(), source_end.toString());
                        }
                        case START_UNDEFINED: {
                            throw new InvalidCRTDataException(WARN_START_UNDEFINED);
                        }
                        case END_UNDEFINED: {
                            throw new InvalidCRTDataException(WARN_END_UNDEFINED);
                        }
                    }
                    this.source_positions = range;
                    break block25;
                }
            }
            catch (Throwable throwable) {
                this.source_positions = range;
                throw throwable;
            }
            this.source_positions = range;
        }
        this.flags = new CRTFlags(flags);
    }

    public final CRTFlags getFlags() {
        return this.flags;
    }

    public final boolean isInRange(int pc) {
        return this.pc_start_index <= pc && pc <= this.pc_end_index;
    }

    public final boolean matches(CRTData d) {
        return d != null && (this.isMorePrecise(d) || d.isMorePrecise(this));
    }

    public final boolean isMorePrecise(CRTData d) {
        return d != null && this.pc_start_index >= d.pc_start_index && this.pc_end_index <= d.pc_end_index && (this.source_positions.isWithin(d.source_positions) || this.hasNoPosition() || d.hasNoPosition());
    }

    private boolean hasNoPosition() {
        return this.source_positions.isUndefined();
    }

    public final Range getSourceInfo() {
        return this.source_positions;
    }

    public String toString() {
        return "(Range [pc]: " + this.pc_start_index + "-" + this.pc_end_index + ") => " + this.source_positions.toString();
    }
}

