/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.StackMapConstants;
import java.util.ArrayList;
import java.util.List;

public class StackMapTableReader
extends AttributeReader {
    private List<StackMapConstants.StackMapFrame> frames = new ArrayList<StackMapConstants.StackMapFrame>();

    public List<StackMapConstants.StackMapFrame> frames() {
        return this.frames;
    }

    private StackMapConstants.StackMapType item(int offset) throws InvalidClassFileException {
        StackMapConstants.Item item = StackMapConstants.items[this.cr.getByte(offset)];
        if (StackMapConstants.Item.ITEM_Uninitalized == item) {
            return new StackMapConstants.UninitializedType("#" + this.cr.getUShort(offset + 1) + "#unknown");
        }
        if (StackMapConstants.Item.ITEM_Object == item) {
            return new StackMapConstants.ObjectType(this.cr.getCP().getCPClass(this.cr.getUShort(offset + 1)));
        }
        return item;
    }

    public StackMapTableReader(ClassReader.AttrIterator iter) throws InvalidClassFileException {
        super(iter, "StackMapTable");
        int entries = this.cr.getUShort(this.attr + 6);
        int ptr = this.attr + 8;
        int i = 0;
        while (i < entries) {
            int frameType;
            if ((frameType = 0xFF & this.cr.getByte(ptr++)) < 64) {
                int offset = frameType;
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, new StackMapConstants.StackMapType[0], new StackMapConstants.StackMapType[0]));
            } else if (frameType < 128) {
                StackMapConstants.StackMapType stack1;
                int offset = frameType - 64;
                ptr += (stack1 = this.item(ptr)) instanceof StackMapConstants.ObjectType ? 3 : 1;
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, new StackMapConstants.StackMapType[0], new StackMapConstants.StackMapType[]{stack1}));
            } else if (frameType == 247) {
                int offset = this.cr.getUShort(ptr);
                StackMapConstants.StackMapType stack1 = this.item(ptr += 2);
                ptr += stack1 instanceof StackMapConstants.ObjectType ? 3 : 1;
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, new StackMapConstants.StackMapType[0], new StackMapConstants.StackMapType[]{stack1}));
            } else if (frameType >= 248 && frameType <= 250) {
                int offset = this.cr.getUShort(ptr);
                ptr += 2;
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, new StackMapConstants.StackMapType[0], new StackMapConstants.StackMapType[0]));
            } else if (frameType == 251) {
                int offset = this.cr.getUShort(ptr);
                ptr += 2;
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, new StackMapConstants.StackMapType[0], new StackMapConstants.StackMapType[0]));
            } else if (frameType >= 252 && frameType <= 254) {
                StackMapConstants.StackMapType[] locals = new StackMapConstants.StackMapType[frameType - 251];
                int offset = this.cr.getUShort(ptr);
                ptr += 2;
                int j = 0;
                while (j < locals.length) {
                    locals[j] = this.item(ptr);
                    ptr += locals[j] instanceof StackMapConstants.ObjectType ? 3 : 1;
                    ++j;
                }
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, locals, new StackMapConstants.StackMapType[0]));
            } else if (frameType == 255) {
                int offset = this.cr.getUShort(ptr);
                int numLocals = this.cr.getUShort(ptr += 2);
                ptr += 2;
                StackMapConstants.StackMapType[] locals = new StackMapConstants.StackMapType[numLocals];
                int j = 0;
                while (j < numLocals) {
                    locals[j] = this.item(ptr);
                    ptr += locals[j] instanceof StackMapConstants.ObjectType ? 3 : 1;
                    ++j;
                }
                int numStack = this.cr.getUShort(ptr);
                ptr += 2;
                StackMapConstants.StackMapType[] stack = new StackMapConstants.StackMapType[numStack];
                int j2 = 0;
                while (j2 < numStack) {
                    stack[j2] = this.item(ptr);
                    ptr += stack[j2].isObject() ? 3 : 1;
                    ++j2;
                }
                this.frames.add(new StackMapConstants.StackMapFrame(frameType, offset, locals, stack));
            }
            ++i;
        }
    }

    public static List<StackMapConstants.StackMapFrame> readStackMap(CodeReader code) throws InvalidClassFileException, IllegalArgumentException {
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        code.initAttributeIterator(iter);
        while (iter.isValid()) {
            if (iter.getName().equals("StackMapTable")) {
                StackMapTableReader r = new StackMapTableReader(iter);
                return r.frames();
            }
            iter.advance();
        }
        return null;
    }
}

