/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;

public class BootstrapMethodsReader
extends AttributeReader {
    private BootstrapMethod[] entries;

    protected BootstrapMethodsReader(ClassReader.AttrIterator attr) throws InvalidClassFileException {
        super(attr, "BootstrapMethods");
        this.readBootstrapEntries();
    }

    private void readBootstrapEntries() throws InvalidClassFileException {
        final ConstantPoolParser cp = this.cr.getCP();
        this.entries = new BootstrapMethod[this.cr.getUShort(this.attr + 6)];
        int base = 8;
        int i = 0;
        while (i < this.entries.length) {
            int methodHandleOffset = this.cr.getUShort(this.attr + base);
            final int argsBase = this.attr + base + 4;
            final int index = i;
            final int argumentCount = this.cr.getUShort(this.attr + base + 2);
            this.entries[i] = new BootstrapMethod(methodHandleOffset){
                private final int invokeType;
                private final String methodClass;
                private final String methodName;
                private final String methodType;
                {
                    this.invokeType = constantPoolParser.getCPHandleKind(n);
                    this.methodClass = constantPoolParser.getCPHandleClass(n);
                    this.methodName = constantPoolParser.getCPHandleName(n);
                    this.methodType = constantPoolParser.getCPHandleType(n);
                }

                public String toString() {
                    return String.valueOf(this.methodClass) + ":" + this.methodName + this.methodType;
                }

                @Override
                public int invokeType() {
                    return this.invokeType;
                }

                @Override
                public String methodClass() {
                    return this.methodClass;
                }

                @Override
                public String methodName() {
                    return this.methodName;
                }

                @Override
                public String methodType() {
                    return this.methodType;
                }

                @Override
                public int callArgumentCount() {
                    return argumentCount;
                }

                @Override
                public int callArgumentKind(int i) {
                    return cp.getItemType(this.callArgumentIndex(i));
                }

                @Override
                public int callArgumentIndex(int i) {
                    if (!($assertionsDisabled || i >= 0 && i < argumentCount)) {
                        throw new AssertionError();
                    }
                    int index2 = argsBase + 2 * i;
                    return BootstrapMethodsReader.this.cr.getUShort(index2);
                }

                @Override
                public Object callArgument(ClassLoader cl, int i) {
                    block24: {
                        try {
                            int index2 = this.callArgumentIndex(i);
                            int t = this.callArgumentKind(i);
                            switch (t) {
                                case 1: {
                                    return cp.getCPUtf8(index2);
                                }
                                case 7: {
                                    return cp.getCPClass(index2);
                                }
                                case 8: {
                                    return cp.getCPString(index2);
                                }
                                case 3: {
                                    return cp.getCPInt(index2);
                                }
                                case 4: {
                                    return Float.valueOf(cp.getCPFloat(index2));
                                }
                                case 6: {
                                    return cp.getCPDouble(index2);
                                }
                                case 5: {
                                    return cp.getCPLong(index2);
                                }
                                case 15: {
                                    String className = cp.getCPHandleClass(index2);
                                    String eltName = cp.getCPHandleName(index2);
                                    String eltDesc = cp.getCPHandleType(index2);
                                    MethodType type = MethodType.fromMethodDescriptorString(eltDesc, cl);
                                    Class<?> cls = Class.forName(className.replace('/', '.'), false, cl);
                                    Method m = cls.getDeclaredMethod(eltName, type.parameterList().toArray(new Class[type.parameterCount()]));
                                    MethodHandles.Lookup lk = MethodHandles.lookup().in(cls);
                                    m.setAccessible(true);
                                    return lk.unreflect(m);
                                }
                                case 16: {
                                    return MethodType.fromMethodDescriptorString(cp.getCPMethodType(index2), cl);
                                }
                            }
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)("invalid type " + t));
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)e);
                            }
                        }
                        catch (InvalidClassFileException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)e);
                            }
                        }
                        catch (ClassNotFoundException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)e);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)e);
                            }
                        }
                        catch (SecurityException e) {
                            if (!$assertionsDisabled) {
                                throw new AssertionError((Object)e);
                            }
                        }
                        catch (IllegalAccessException e) {
                            if ($assertionsDisabled) break block24;
                            throw new AssertionError((Object)e);
                        }
                    }
                    return null;
                }

                @Override
                public ConstantPoolParser getCP() {
                    return cp;
                }

                @Override
                public int getIndexInClassFile() {
                    return index;
                }
            };
            base += argumentCount * 2 + 4;
            ++i;
        }
    }

    public int count() {
        return this.entries.length;
    }

    public BootstrapMethod getEntry(int i) {
        return this.entries[i];
    }

    public static interface BootstrapMethod {
        public int invokeType();

        public String methodClass();

        public String methodName();

        public String methodType();

        public int callArgumentCount();

        public Object callArgument(ClassLoader var1, int var2);

        public int callArgumentIndex(int var1);

        public int callArgumentKind(int var1);

        public ConstantPoolParser getCP();

        public int getIndexInClassFile();
    }
}

