/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.tools;

import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.info.LocalAllocator;
import java.util.Arrays;
import java.util.BitSet;

@Deprecated
public final class MethodOptimizer {
    private final MethodData data;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private final MethodEditor editor;
    private int[][] uniqueStackDefLocations;
    private int[] uniqueStackUseLocations;
    private int[] stackSizes;
    private int[][] backEdges;
    static final int[] noEdges = new int[0];

    public MethodOptimizer(MethodData d, MethodEditor e) {
        if (d == null) {
            throw new IllegalArgumentException("null d");
        }
        this.data = d;
        this.editor = e;
    }

    public MethodOptimizer(MethodData d) {
        this(d, new MethodEditor(d));
    }

    public int findUniqueStackDef(int instr, int stack) throws UnoptimizableCodeException {
        this.instructions = this.editor.getInstructions();
        this.handlers = this.editor.getHandlers();
        this.checkConsistentStackSizes();
        this.buildBackEdges();
        this.buildStackDefMap();
        return this.uniqueStackDefLocations[instr][stack];
    }

    public void optimize() throws UnoptimizableCodeException {
        boolean changed;
        do {
            this.instructions = this.editor.getInstructions();
            this.handlers = this.editor.getHandlers();
            this.checkConsistentStackSizes();
            this.buildBackEdges();
            this.editor.beginPass();
            this.buildStackDefMap();
            this.pushBackLocalStores();
            this.forwardDups();
            changed = this.editor.applyPatches();
            this.editor.endPass();
        } while (changed);
    }

    private void buildBackEdges() {
        int j;
        ExceptionHandler[] hs;
        int[] targets;
        int[] backEdgeCount = new int[this.instructions.length];
        int i = 0;
        while (i < this.instructions.length) {
            targets = this.instructions[i].getBranchTargets();
            int j2 = 0;
            while (j2 < targets.length) {
                int n = targets[j2];
                backEdgeCount[n] = backEdgeCount[n] + 1;
                ++j2;
            }
            hs = this.handlers[i];
            j = 0;
            while (j < hs.length) {
                int n = hs[j].getHandler();
                backEdgeCount[n] = backEdgeCount[n] + 1;
                ++j;
            }
            ++i;
        }
        this.backEdges = new int[this.instructions.length][];
        i = 0;
        while (i < this.backEdges.length) {
            this.backEdges[i] = backEdgeCount[i] > 0 ? new int[backEdgeCount[i]] : noEdges;
            ++i;
        }
        Arrays.fill(backEdgeCount, 0);
        i = 0;
        while (i < this.instructions.length) {
            targets = this.instructions[i].getBranchTargets();
            int j3 = 0;
            while (j3 < targets.length) {
                int target = targets[j3];
                this.backEdges[target][backEdgeCount[target]] = i;
                int n = target;
                backEdgeCount[n] = backEdgeCount[n] + 1;
                ++j3;
            }
            hs = this.handlers[i];
            j = 0;
            while (j < hs.length) {
                int target = hs[j].getHandler();
                this.backEdges[target][backEdgeCount[target]] = i;
                int n = target;
                backEdgeCount[n] = backEdgeCount[n] + 1;
                ++j;
            }
            ++i;
        }
    }

    private int checkConsistentStackSizes() throws UnoptimizableCodeException {
        this.stackSizes = new int[this.instructions.length];
        Arrays.fill(this.stackSizes, -1);
        this.checkStackSizesAt(0, 0);
        int result = 0;
        int i = 0;
        while (i < this.stackSizes.length) {
            result = Math.max(result, this.stackSizes[i]);
            ++i;
        }
        return result;
    }

    private void checkStackSizesAt(int instruction, int stackSize) throws UnoptimizableCodeException {
        while (true) {
            if (instruction < 0 || instruction >= this.instructions.length) {
                throw new UnoptimizableCodeException("Code exits in an illegal way");
            }
            if (this.stackSizes[instruction] != -1) {
                if (this.stackSizes[instruction] != stackSize) {
                    throw new UnoptimizableCodeException("Mismatched stack sizes at " + instruction + ": " + stackSize + " and " + this.stackSizes[instruction]);
                }
                return;
            }
            this.stackSizes[instruction] = stackSize;
            IInstruction instr = this.instructions[instruction];
            if ((stackSize -= instr.getPoppedCount()) < 0) {
                throw new UnoptimizableCodeException("Stack underflow at " + instruction);
            }
            if (instr instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)instr;
                stackSize += d.getSize() + d.getPoppedCount();
            } else if (instr.getPushedType(null) != null) {
                ++stackSize;
            }
            int[] targets = instr.getBranchTargets();
            int i = 0;
            while (i < targets.length) {
                this.checkStackSizesAt(targets[i], stackSize);
                ++i;
            }
            ExceptionHandler[] hs = this.handlers[instruction];
            int i2 = 0;
            while (i2 < hs.length) {
                this.checkStackSizesAt(hs[i2].getHandler(), 1);
                ++i2;
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++instruction;
        }
    }

    private static boolean instructionKillsVar(IInstruction instr, int v) {
        if (instr instanceof StoreInstruction) {
            StoreInstruction st = (StoreInstruction)instr;
            return st.getVarIndex() == v || Util.getWordSize(st.getType()) == 2 && st.getVarIndex() + 1 == v;
        }
        return false;
    }

    private void forwardDups() {
        int i = 0;
        while (i < this.instructions.length) {
            IInstruction instr = this.instructions[i];
            if (instr instanceof DupInstruction && ((DupInstruction)instr).getDelta() == 0 && this.uniqueStackDefLocations[i][0] >= 0 && this.instructions[this.uniqueStackDefLocations[i][0]] instanceof LoadInstruction) {
                int source = this.uniqueStackDefLocations[i][0];
                final LoadInstruction li = (LoadInstruction)this.instructions[source];
                int j = 0;
                while (j < this.instructions.length) {
                    int[] locs = this.uniqueStackDefLocations[j];
                    if (locs[0] == i) {
                        BitSet path = this.getInstructionsOnPath(source, j);
                        boolean killed = false;
                        int v = li.getVarIndex();
                        int k = 0;
                        while (j < this.instructions.length && !killed) {
                            if (path.get(k) && MethodOptimizer.instructionKillsVar(this.instructions[k], v)) {
                                killed = true;
                            }
                            ++k;
                        }
                        if (!killed) {
                            this.editor.insertBefore(j, new MethodEditor.Patch(){

                                @Override
                                public void emitTo(MethodEditor.Output w) {
                                    w.emit(PopInstruction.make(1));
                                    w.emit(li);
                                }
                            });
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void pushBackLocalStores() {
        int i = 0;
        while (i < this.instructions.length) {
            IInstruction instr = this.instructions[i];
            if (instr instanceof StoreInstruction && this.uniqueStackDefLocations[i][0] >= 0 && this.uniqueStackDefLocations[i][0] != i - 1 && this.uniqueStackUseLocations[this.uniqueStackDefLocations[i][0]] == i) {
                final StoreInstruction s = (StoreInstruction)instr;
                int source = this.uniqueStackDefLocations[i][0];
                BitSet path = this.getInstructionsOnPath(source, i);
                boolean killed = false;
                int v = s.getVarIndex();
                int j = 0;
                while (j < this.instructions.length && !killed) {
                    if (path.get(j) && MethodOptimizer.instructionKillsVar(this.instructions[j], v)) {
                        killed = true;
                    }
                    ++j;
                }
                if (killed) {
                    final String type = s.getType();
                    final int newVar = LocalAllocator.allocate(this.data, type);
                    this.editor.insertAfter(source, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                            w.emit(StoreInstruction.make(type, newVar));
                        }
                    });
                    this.editor.insertBefore(i, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                            w.emit(LoadInstruction.make(type, newVar));
                        }
                    });
                } else {
                    this.editor.replaceWith(i, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                        }
                    });
                    this.editor.insertAfter(source, new MethodEditor.Patch(){

                        @Override
                        public void emitTo(MethodEditor.Output w) {
                            w.emit(s);
                        }
                    });
                }
            }
            ++i;
        }
    }

    private void buildStackDefMap() {
        int j;
        int[][] abstractStacks = new int[this.instructions.length][];
        int i = 0;
        while (i < this.instructions.length) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
            ++i;
        }
        i = 0;
        while (i < this.instructions.length) {
            if (this.instructions[i] instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)this.instructions[i];
                j = 0;
                while (j < 2 * d.getSize() + d.getDelta()) {
                    this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1 - j);
                    ++j;
                }
            } else if (this.instructions[i].getPushedType(null) != null) {
                this.followStackDef(abstractStacks, i, i + 1, this.stackSizes[i + 1] - 1);
            }
            ++i;
        }
        this.uniqueStackDefLocations = new int[this.instructions.length][];
        i = 0;
        while (i < this.instructions.length) {
            this.uniqueStackDefLocations[i] = new int[this.instructions[i].getPoppedCount()];
            int popped = this.instructions[i].getPoppedCount();
            System.arraycopy(abstractStacks[i], this.stackSizes[i] - popped, this.uniqueStackDefLocations[i], 0, popped);
            ++i;
        }
        this.uniqueStackUseLocations = new int[this.instructions.length];
        Arrays.fill(this.uniqueStackUseLocations, -2);
        i = 0;
        while (i < this.instructions.length) {
            abstractStacks[i] = new int[this.stackSizes[i]];
            Arrays.fill(abstractStacks[i], -2);
            ++i;
        }
        i = 0;
        while (i < this.instructions.length) {
            int count = this.instructions[i].getPoppedCount();
            if (count == 1) {
                this.followStackUse(abstractStacks, i, i, this.stackSizes[i] - 1);
            } else if (count > 1) {
                j = 0;
                while (j < count) {
                    this.followStackUse(abstractStacks, -1, i, this.stackSizes[i] - 1 - j);
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.instructions.length) {
            if (this.instructions[i].getPushedType(null) != null) {
                this.uniqueStackUseLocations[i] = abstractStacks[i + 1][this.stackSizes[i + 1] - 1];
            }
            ++i;
        }
    }

    private void followStackDef(int[][] abstractDefStacks, int def, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractDefStacks[instruction]).length) {
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = def;
            } else {
                if (stack[stackPointer] == def) {
                    return;
                }
                if (stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                def = -1;
            }
            int[] targets = this.instructions[instruction].getBranchTargets();
            int i = 0;
            while (i < targets.length) {
                this.followStackDef(abstractDefStacks, def, targets[i], stackPointer);
                ++i;
            }
            ExceptionHandler[] hs = this.handlers[instruction];
            int i2 = 0;
            while (i2 < hs.length) {
                this.followStackDef(abstractDefStacks, -1, hs[i2].getHandler(), 0);
                ++i2;
            }
            if (!this.instructions[instruction].isFallThrough()) {
                return;
            }
            ++instruction;
        }
        return;
    }

    private void followStackUse(int[][] abstractUseStacks, int use, int instruction, int stackPointer) {
        int[] stack;
        while (stackPointer < (stack = abstractUseStacks[instruction]).length) {
            if (stack[stackPointer] == -2) {
                stack[stackPointer] = use;
            } else {
                if (stack[stackPointer] == use || stack[stackPointer] == -1) {
                    return;
                }
                stack[stackPointer] = -1;
                use = -1;
            }
            int[] back = this.backEdges[instruction];
            int i = 0;
            while (i < back.length) {
                this.followStackUse(abstractUseStacks, use, back[i], stackPointer);
                ++i;
            }
            if (instruction == 0 || !this.instructions[instruction - 1].isFallThrough()) {
                return;
            }
            --instruction;
        }
        return;
    }

    private BitSet getInstructionsOnPath(int from, int to) {
        BitSet reachable = new BitSet();
        this.getReachableInstructions(reachable, from, to);
        BitSet reaching = new BitSet();
        this.getReachingInstructions(reaching, from, to);
        reachable.and(reaching);
        return reachable;
    }

    private void getReachableInstructions(BitSet bits, int from, int to) {
        while (from != to) {
            bits.set(from);
            int[] targets = this.instructions[from].getBranchTargets();
            int i = 0;
            while (i < targets.length) {
                this.getReachableInstructions(bits, targets[i], to);
                ++i;
            }
            if (!this.instructions[from].isFallThrough()) {
                return;
            }
            ++from;
        }
        return;
    }

    private void getReachingInstructions(BitSet bits, int from, int to) {
        while (to != from) {
            bits.set(to);
            int[] targets = this.backEdges[to];
            int i = 0;
            while (i < targets.length) {
                this.getReachingInstructions(bits, from, targets[i]);
                ++i;
            }
            if (to == 0 || !this.instructions[to - 1].isFallThrough()) {
                return;
            }
            --to;
        }
        return;
    }

    public static class UnoptimizableCodeException
    extends Exception {
        private static final long serialVersionUID = 2543170335674010642L;

        public UnoptimizableCodeException(String s) {
            super(s);
        }
    }
}

