/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public class BatchVerifier {
    private static boolean disasm = false;
    private static final ClassHierarchyStore store = new ClassHierarchyStore();
    private static int errors = 0;

    public static void main(String[] args) throws Exception {
        OfflineInstrumenter oi = new OfflineInstrumenter(true);
        args = oi.parseStandardArgs(args);
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                disasm = true;
            }
            ++i;
        }
        Throwable throwable = null;
        Object var3_5 = null;
        try (PrintWriter w = new PrintWriter(new BufferedWriter(new FileWriter("report", false)));){
            ClassInstrumenter ci;
            oi.beginTraversal();
            while ((ci = oi.nextClass()) != null) {
                ClassReader cr = ci.getReader();
                CTUtils.addClassToHierarchy(store, cr);
            }
            oi.beginTraversal();
            while ((ci = oi.nextClass()) != null) {
                BatchVerifier.doClass(ci.getReader(), w);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        oi.close();
        if (errors > 0) {
            System.err.println(String.valueOf(errors) + " error" + (errors > 1 ? "s" : "") + " detected");
        }
    }

    private static void doClass(ClassReader cr, PrintWriter w) throws Exception {
        int methodCount = cr.getMethodCount();
        w.write("Verifying " + cr.getName() + "\n");
        w.flush();
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        int i = 0;
        while (i < methodCount) {
            cr.initMethodAttributeIterator(i, iter);
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    w.write("Verifying " + cr.getName() + "." + cr.getMethodName(i) + " " + cr.getMethodType(i) + ":\n");
                    w.flush();
                    CodeReader code = new CodeReader(iter);
                    CTDecoder d = new CTDecoder(code);
                    try {
                        d.decode();
                    }
                    catch (Decoder.InvalidBytecodeException e) {
                        throw new InvalidClassFileException(code.getRawOffset(), e.getMessage());
                    }
                    MethodData md = new MethodData(d, cr.getMethodAccessFlags(i), CTDecoder.convertClassToType(cr.getName()), cr.getMethodName(i), cr.getMethodType(i));
                    if (disasm) {
                        w.write("ShrikeBT code:\n");
                        new Disassembler(md).disassembleTo(w);
                        w.flush();
                    }
                    Verifier v = new Verifier(md);
                    try {
                        v.verify();
                    }
                    catch (Analyzer.FailureException e) {
                        w.println("ERROR: VERIFICATION FAILED");
                        e.printStackTrace(w);
                        e.printPath(w);
                        ++errors;
                        w.flush();
                    }
                    break;
                }
                iter.advance();
            }
            ++i;
        }
    }
}

