/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ReturnInstruction
extends Instruction {
    private static final ReturnInstruction[] preallocated = ReturnInstruction.preallocate();
    private static final ReturnInstruction preallocatedVoid = new ReturnInstruction(177);

    protected ReturnInstruction(short opcode) {
        super(opcode);
    }

    private static ReturnInstruction[] preallocate() {
        ReturnInstruction[] r = new ReturnInstruction[5];
        int i = 0;
        while (i < r.length) {
            r[i] = new ReturnInstruction((short)(172 + i));
            ++i;
        }
        return r;
    }

    public static ReturnInstruction make(String type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (type.equals("V")) {
            return preallocatedVoid;
        }
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 4) {
            throw new IllegalArgumentException("Cannot return type " + type);
        }
        return preallocated[t];
    }

    public boolean equals(Object o) {
        if (o instanceof ReturnInstruction) {
            ReturnInstruction i = (ReturnInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public boolean isFallThrough() {
        return false;
    }

    public int hashCode() {
        return this.opcode + 31111;
    }

    @Override
    public int getPoppedCount() {
        return this.opcode == 177 ? 0 : 1;
    }

    public String getType() {
        return this.opcode == 177 ? "V" : indexedTypes[this.opcode - 172];
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitReturn(this);
    }

    @Override
    public String toString() {
        return "Return(" + this.getType() + ")";
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

