/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ComparisonInstruction
extends Instruction
implements IComparisonInstruction {
    private static final ComparisonInstruction preallocatedLCMP = new ComparisonInstruction(148);
    private static final ComparisonInstruction[] preallocatedFloatingCompares = ComparisonInstruction.preallocateFloatingCompares();

    protected ComparisonInstruction(short opcode) {
        super(opcode);
    }

    private static ComparisonInstruction[] preallocateFloatingCompares() {
        ComparisonInstruction[] r = new ComparisonInstruction[4];
        short i = 149;
        while (i <= 152) {
            r[i - 149] = new ComparisonInstruction(i);
            i = (short)(i + 1);
        }
        return r;
    }

    public static ComparisonInstruction make(String type, IComparisonInstruction.Operator operator) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        switch (t) {
            case 1: {
                if (operator != IComparisonInstruction.Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for longs");
                }
                return preallocatedLCMP;
            }
            case 2: 
            case 3: {
                if (operator == IComparisonInstruction.Operator.CMP) {
                    throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is not a valid comparison operator for floating point values");
                }
                return preallocatedFloatingCompares[operator.ordinal() - IComparisonInstruction.Operator.CMPL.ordinal() + (t - 2) * 2];
            }
        }
        throw new IllegalArgumentException("Type " + type + " cannot be compared");
    }

    public boolean equals(Object o) {
        if (o instanceof ComparisonInstruction) {
            ComparisonInstruction i = (ComparisonInstruction)o;
            return i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public IComparisonInstruction.Operator getOperator() {
        switch (this.opcode) {
            case 148: {
                return IComparisonInstruction.Operator.CMP;
            }
            case 149: 
            case 151: {
                return IComparisonInstruction.Operator.CMPL;
            }
            case 150: 
            case 152: {
                return IComparisonInstruction.Operator.CMPG;
            }
        }
        throw new Error("Unknown opcode");
    }

    @Override
    public String getType() {
        switch (this.opcode) {
            case 148: {
                return "J";
            }
            case 149: 
            case 150: {
                return "F";
            }
            case 151: 
            case 152: {
                return "D";
            }
        }
        throw new Error("Unknown opcode");
    }

    public int hashCode() {
        return this.opcode + 1391901;
    }

    @Override
    public int getPoppedCount() {
        return 2;
    }

    @Override
    public String getPushedType(String[] types) {
        return "Z";
    }

    @Override
    public byte getPushedWordSize() {
        return 1;
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitComparison(this);
    }

    @Override
    public String toString() {
        return "Comparison(" + this.getType() + "," + (Object)((Object)this.getOperator()) + ")";
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

