/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.wala;

import com.ibm.wala.cast.java.client.JDTJavaSourceAnalysisEngine;
import com.ibm.wala.ide.util.EclipseProjectPath;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.config.FileOfClasses;
import com.ibm.wala.util.config.SetOfClasses;
import edu.cuny.hunter.streamrefactoring.core.wala.TestableJavaEclipseProjectPath;
import edu.cuny.hunter.streamrefactoring.core.wala.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class EclipseProjectAnalysisEngine<I extends InstanceKey>
extends JDTJavaSourceAnalysisEngine<I> {
    private static final Logger LOGGER = Logger.getLogger("edu.cuny.hunter.streamrefactoring");
    private static final int N = 1;
    private static final int N_FOR_STREAMS_DEFAULT = 2;
    private CallGraphBuilder<?> callGraphBuilder;
    private int nToUseForStreams = 2;
    private IJavaProject project;

    public EclipseProjectAnalysisEngine(IJavaProject project) throws IOException, CoreException {
        super(project);
        this.project = project;
    }

    public EclipseProjectAnalysisEngine(IJavaProject project, int nForStreams) throws IOException, CoreException {
        this(project);
        this.nToUseForStreams = nForStreams;
    }

    void addToScopeNotWindows(String fileName, Path installPath) throws IOException {
        this.scope.addToScope(ClassLoaderReference.Primordial, new JarFile(installPath.resolve("jre").resolve("lib").resolve(fileName).toFile()));
    }

    void addToScopeWindows(String fileName, Path installPath) throws IOException {
        this.scope.addToScope(ClassLoaderReference.Primordial, new JarFile(installPath.resolve("lib").resolve(fileName).toFile()));
    }

    public void buildAnalysisScope() throws IOException {
        try {
            this.ePath = this.createProjectPath(this.getProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.scope = this.ePath.toAnalysisScope(this.makeAnalysisScope());
        if (this.scope.getModules(ClassLoaderReference.Primordial).isEmpty()) {
            IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            File installLocation = defaultVMInstall.getInstallLocation();
            Path installPath = installLocation.toPath();
            if (Util.isWindows()) {
                this.addToScopeWindows("resources.jar", installPath);
                this.addToScopeWindows("rt.jar", installPath);
                this.addToScopeWindows("jsse.jar", installPath);
                this.addToScopeWindows("jce.jar", installPath);
                this.addToScopeWindows("charsets.jar", installPath);
            } else {
                this.addToScopeNotWindows("resources.jar", installPath);
                this.addToScopeNotWindows("rt.jar", installPath);
                this.addToScopeNotWindows("jsse.jar", installPath);
                this.addToScopeNotWindows("jce.jar", installPath);
                this.addToScopeNotWindows("charsets.jar", installPath);
            }
        }
        if (this.getExclusionsFile() != null) {
            InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/EclipseDefaultExclusions.txt");
            this.scope.setExclusions((SetOfClasses)new FileOfClasses(stream));
        }
    }

    public IClassHierarchy buildClassHierarchy() {
        IClassHierarchy classHierarchy = super.buildClassHierarchy();
        this.setClassHierarchy(classHierarchy);
        return classHierarchy;
    }

    public CallGraph buildSafeCallGraph(AnalysisOptions options) throws CallGraphBuilderCancelException, CancelException {
        LOGGER.entering(((Object)((Object)this)).getClass().getName(), "buildSafeCallGraph", this.callGraphBuilder);
        if (this.callGraphBuilder == null) {
            LOGGER.info("Creating new call graph builder.");
            this.callGraphBuilder = this.buildCallGraph(this.getClassHierarchy(), options, true, null);
        } else {
            LOGGER.info("Reusing call graph builder.");
        }
        LOGGER.exiting(((Object)((Object)this)).getClass().getName(), "buildSafeCallGraph", this.callGraphBuilder);
        return this.callGraphBuilder.makeCallGraph(options, null);
    }

    public CallGraph buildSafeCallGraph(Iterable<Entrypoint> entryPoints) throws IllegalArgumentException, CallGraphBuilderCancelException, CancelException {
        return this.buildSafeCallGraph(this.getDefaultOptions(entryPoints));
    }

    public void clearCallGraphBuilder() {
        this.callGraphBuilder = null;
    }

    protected EclipseProjectPath<?, IJavaProject> createProjectPath(IJavaProject project) throws IOException, CoreException {
        project.open((IProgressMonitor)new NullProgressMonitor());
        return TestableJavaEclipseProjectPath.create(project, EclipseProjectPath.AnalysisScopeType.NO_SOURCE);
    }

    public CallGraph getCallGraph() {
        return super.getCallGraph();
    }

    public CallGraphBuilder<?> getCallGraphBuilder() {
        return this.callGraphBuilder;
    }

    protected CallGraphBuilder<?> getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
        LOGGER.fine(() -> "Using N = " + this.getNToUseForStreams() + ".");
        return Util.makeNCFABuilder(1, options, (AnalysisCache)cache, cha, this.scope, this.getNToUseForStreams());
    }

    public int getNToUseForStreams() {
        return this.nToUseForStreams;
    }

    public IJavaProject getProject() {
        return this.project;
    }

    protected void setNToUseForStreams(int nToUseForStreams) {
        this.nToUseForStreams = nToUseForStreams;
    }
}

