/*
 * Decompiled with CFR 0.152.
 */
package edu.cuny.hunter.streamrefactoring.core.refactorings;

import com.ibm.wala.ipa.callgraph.Entrypoint;
import edu.cuny.hunter.streamrefactoring.core.analysis.PreconditionFailure;
import edu.cuny.hunter.streamrefactoring.core.analysis.Stream;
import edu.cuny.hunter.streamrefactoring.core.analysis.StreamAnalyzer;
import edu.cuny.hunter.streamrefactoring.core.descriptors.OptimizeStreamRefactoringDescriptor;
import edu.cuny.hunter.streamrefactoring.core.messages.Messages;
import edu.cuny.hunter.streamrefactoring.core.utils.TimeCollector;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.TextEditBasedChangeManager;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.osgi.framework.FrameworkUtil;

public class OptimizeStreamsRefactoringProcessor
extends RefactoringProcessor {
    private static int loggingLevel = 2;
    private static final int N_FOR_STREAMS_DEFAULT = 2;
    private static final GroupCategorySet SET_CONVERT_STREAM_TO_PARALLEL = new GroupCategorySet(new GroupCategory("edu.cuny.hunter.streamrefactoring", Messages.CategoryName, Messages.CategoryDescription));
    private Map<ICompilationUnit, CompilationUnitRewrite> compilationUnitToCompilationUnitRewriteMap = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
    private TimeCollector excludedTimeCollector = new TimeCollector();
    private IJavaProject[] javaProjects;
    private final boolean layer;
    private int nForStreams = 2;
    private int numberOfProcessedStreamInstances;
    private int numberOfSkippedStreamInstances;
    private Map<IJavaProject, Collection<Entrypoint>> projectToEntryPoints;
    private SearchEngine searchEngine = new SearchEngine();
    private CodeGenerationSettings settings;
    private Set<Stream> streamSet;
    private Map<ITypeRoot, CompilationUnit> typeRootToCompilationUnitMap = new HashMap<ITypeRoot, CompilationUnit>();
    private Map<IType, ITypeHierarchy> typeToTypeHierarchyMap = new HashMap<IType, ITypeHierarchy>();
    private boolean useImplicitBenchmarkEntrypoints = false;
    private boolean useImplicitEntrypoints = true;
    private boolean useImplicitJavaFXEntrypoints = false;
    private boolean useImplicitTestEntrypoints = false;

    protected static int getLoggingLevel() {
        return loggingLevel;
    }

    private static void log(int severity, String message) {
        if (severity >= OptimizeStreamsRefactoringProcessor.getLoggingLevel()) {
            String name = FrameworkUtil.getBundle(OptimizeStreamsRefactoringProcessor.class).getSymbolicName();
            Status status = new Status(severity, name, message);
            JavaPlugin.log((IStatus)status);
        }
    }

    private static void logWarning(String message) {
        OptimizeStreamsRefactoringProcessor.log(2, message);
    }

    public static void setLoggingLevel(int level) {
        loggingLevel = level;
    }

    public OptimizeStreamsRefactoringProcessor() throws JavaModelException {
        this(null, null, false, true, false, false, false, Optional.empty());
    }

    public OptimizeStreamsRefactoringProcessor(CodeGenerationSettings settings, Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(null, settings, false, true, false, false, false, monitor);
    }

    public OptimizeStreamsRefactoringProcessor(IJavaProject[] javaProjects, CodeGenerationSettings settings, boolean layer, boolean useImplicitEntrypoints, boolean useImplicitTestEntrypoints, boolean useImplicitBenchmarkEntrypoints, boolean useImplicitJavaFXEntrypoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        try {
            this.javaProjects = javaProjects;
            this.settings = settings;
            this.layer = layer;
            this.useImplicitEntrypoints = useImplicitEntrypoints;
            this.useImplicitTestEntrypoints = useImplicitTestEntrypoints;
            this.useImplicitBenchmarkEntrypoints = useImplicitBenchmarkEntrypoints;
            this.useImplicitJavaFXEntrypoints = useImplicitJavaFXEntrypoints;
        }
        finally {
            monitor.ifPresent(IProgressMonitor::done);
        }
    }

    public OptimizeStreamsRefactoringProcessor(IJavaProject[] javaProjects, CodeGenerationSettings settings, boolean layer, int nForStreams, boolean useImplicitEntrypoints, boolean useImplicitTestEntrypoints, boolean useImplicitBenchmarkEntrypoints, boolean useImplicitJavaFXEntrypoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(javaProjects, settings, layer, useImplicitEntrypoints, useImplicitTestEntrypoints, useImplicitBenchmarkEntrypoints, useImplicitJavaFXEntrypoints, monitor);
        this.nForStreams = nForStreams;
    }

    public OptimizeStreamsRefactoringProcessor(IJavaProject[] javaProjects, CodeGenerationSettings settings, boolean useImplicitJoinpoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(javaProjects, settings, false, useImplicitJoinpoints, false, false, false, monitor);
    }

    public OptimizeStreamsRefactoringProcessor(IJavaProject[] javaProjects, CodeGenerationSettings settings, int nForStreams, boolean useImplicitJoinpoints, Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(javaProjects, settings, false, nForStreams, useImplicitJoinpoints, false, false, false, monitor);
    }

    public OptimizeStreamsRefactoringProcessor(IJavaProject[] javaProjects, CodeGenerationSettings settings, Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(javaProjects, settings, false, true, false, false, false, monitor);
    }

    public OptimizeStreamsRefactoringProcessor(Optional<IProgressMonitor> monitor) throws JavaModelException {
        this(null, null, false, true, false, false, false, monitor);
    }

    private RefactoringStatus checkExistence(IMember member, PreconditionFailure failure) {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        try {
            Set<Stream> passingStreamSet;
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckingPreconditions, (int)(this.getJavaProjects().length * 1000));
            RefactoringStatus status = new RefactoringStatus();
            StreamAnalyzer analyzer = new StreamAnalyzer(false, this.getNForStreams(), this.getUseImplicitEntrypoints(), this.getUseImplicitTestEntrypoints(), this.getUseImplicitBenchmarkEntrypoints(), this.getUseImplicitJavaFXEntrypoints());
            this.setStreamSet(analyzer.getStreamSet());
            IJavaProject[] iJavaProjectArray = this.getJavaProjects();
            int n = iJavaProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot[] roots;
                IJavaProject jproj = iJavaProjectArray[n2];
                IPackageFragmentRoot[] iPackageFragmentRootArray = roots = jproj.getPackageFragmentRoots();
                int n3 = roots.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement[] children;
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n4];
                    IJavaElement[] iJavaElementArray = children = root.getChildren();
                    int n5 = children.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IJavaElement child = iJavaElementArray[n6];
                        if (child.getElementType() == 4) {
                            ICompilationUnit[] units;
                            IPackageFragment fragment = (IPackageFragment)child;
                            ICompilationUnit[] iCompilationUnitArray = units = fragment.getCompilationUnits();
                            int n7 = units.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                ICompilationUnit unit = iCompilationUnitArray[n8];
                                CompilationUnit compilationUnit = this.getCompilationUnit((ITypeRoot)unit, (IProgressMonitor)subMonitor.split(1));
                                compilationUnit.accept((ASTVisitor)analyzer);
                                ++n8;
                            }
                        }
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
            this.projectToEntryPoints = analyzer.analyze(Optional.of(this.getExcludedTimeCollector()));
            this.setNumberOfProcessedStreamInstances(analyzer.getNumberOfProcessedStreamInstances());
            this.setNumberOfSkippedStreamInstances(analyzer.getNumberOfSkippedStreamInstances());
            iJavaProjectArray = this.getJavaProjects();
            n = iJavaProjectArray.length;
            n2 = 0;
            while (n2 < n) {
                IJavaProject project = iJavaProjectArray[n2];
                this.projectToEntryPoints.computeIfAbsent(project, p -> Collections.emptySet());
                ++n2;
            }
            RefactoringStatus collectedStatus = this.getStreamSet().stream().map(Stream::getStatus).collect(() -> new RefactoringStatus(), (a, b) -> a.merge(b), (a, b) -> a.merge(b));
            status.merge(collectedStatus);
            if (!status.hasFatalError() && (passingStreamSet = this.getOptimizableStreams()).isEmpty()) {
                status.addFatalError(Messages.NoStreamsHavePassedThePreconditions);
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            throw e;
        }
        finally {
            monitor.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            this.clearCaches();
            this.getExcludedTimeCollector().clear();
            RefactoringStatus status = new RefactoringStatus();
            pm.beginTask(Messages.CheckingPreconditions, 1);
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        catch (Exception e) {
            JavaPlugin.log((Throwable)e);
            throw e;
        }
        finally {
            pm.done();
        }
    }

    private RefactoringStatus checkProjectCompliance(IJavaProject destinationProject) throws JavaModelException {
        RefactoringStatus status = new RefactoringStatus();
        return status;
    }

    private RefactoringStatus checkStructure(IMember member) throws JavaModelException {
        if (!member.isStructureKnown()) {
            return RefactoringStatus.createErrorStatus((String)MessageFormat.format(Messages.CUContainsCompileErrors, JavaElementLabels.getElementLabel((IJavaElement)member, (long)JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)member.getCompilationUnit(), (long)JavaElementLabels.ALL_FULLY_QUALIFIED)), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)member.getCompilationUnit()));
        }
        return new RefactoringStatus();
    }

    private RefactoringStatus checkWritabilitiy(IMember member, PreconditionFailure failure) {
        return new RefactoringStatus();
    }

    public void clearCaches() {
        this.getTypeToTypeHierarchyMap().clear();
        this.getCompilationUnitToCompilationUnitRewriteMap().clear();
        this.getTypeRootToCompilationUnitMap().clear();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            ICompilationUnit[] units;
            pm.beginTask(Messages.CreatingChange, 1);
            TextEditBasedChangeManager manager = new TextEditBasedChangeManager();
            ICompilationUnit[] iCompilationUnitArray = units = (ICompilationUnit[])this.getCompilationUnitToCompilationUnitRewriteMap().keySet().stream().filter(cu -> !manager.containsChangesIn(cu)).toArray(ICompilationUnit[]::new);
            int n = units.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu2 = iCompilationUnitArray[n2];
                CompilationUnit compilationUnit = this.getCompilationUnit((ITypeRoot)cu2, pm);
                this.manageCompilationUnit(manager, this.getCompilationUnitRewrite(cu2, compilationUnit), Optional.of(new SubProgressMonitor(pm, -1)));
                ++n2;
            }
            HashMap arguments = new HashMap();
            int flags = 6;
            OptimizeStreamRefactoringDescriptor descriptor = new OptimizeStreamRefactoringDescriptor(null, "TODO", null, arguments, flags);
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)descriptor, this.getProcessorName(), (Change[])manager.getAllChanges());
            return dynamicValidationRefactoringChange;
        }
        finally {
            pm.done();
            this.clearCaches();
        }
    }

    private RefactoringStatus createWorkingCopyLayer(IProgressMonitor monitor) {
        try {
            monitor.beginTask(Messages.CheckingPreconditions, 1);
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            monitor.done();
        }
    }

    private CompilationUnit getCompilationUnit(ITypeRoot root, IProgressMonitor pm) {
        CompilationUnit compilationUnit = this.getTypeRootToCompilationUnitMap().get(root);
        if (compilationUnit == null) {
            this.getExcludedTimeCollector().start();
            compilationUnit = RefactoringASTParser.parseWithASTProvider((ITypeRoot)root, (boolean)true, (IProgressMonitor)pm);
            this.getExcludedTimeCollector().stop();
            this.getTypeRootToCompilationUnitMap().put(root, compilationUnit);
        }
        return compilationUnit;
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(ICompilationUnit unit, CompilationUnit root) {
        CompilationUnitRewrite rewrite = this.getCompilationUnitToCompilationUnitRewriteMap().get(unit);
        if (rewrite == null) {
            rewrite = new CompilationUnitRewrite(unit, root);
            this.getCompilationUnitToCompilationUnitRewriteMap().put(unit, rewrite);
        }
        return rewrite;
    }

    protected Map<ICompilationUnit, CompilationUnitRewrite> getCompilationUnitToCompilationUnitRewriteMap() {
        return this.compilationUnitToCompilationUnitRewriteMap;
    }

    public Object[] getElements() {
        return null;
    }

    public Collection<Entrypoint> getEntryPoints(IJavaProject javaProject) {
        return this.projectToEntryPoints == null ? Collections.emptySet() : this.projectToEntryPoints.get(javaProject);
    }

    public TimeCollector getExcludedTimeCollector() {
        return this.excludedTimeCollector;
    }

    public String getIdentifier() {
        return "edu.cuny.hunter.streamrefactoring.optimize.stream";
    }

    protected IJavaProject[] getJavaProjects() {
        return this.javaProjects;
    }

    public int getNForStreams() {
        return this.nForStreams;
    }

    public int getNumberOfProcessedStreamInstances() {
        return this.numberOfProcessedStreamInstances;
    }

    public int getNumberOfSkippedStreamInstances() {
        return this.numberOfSkippedStreamInstances;
    }

    public Set<Stream> getOptimizableStreams() {
        Set<Stream> streamSet = this.getStreamSet();
        return streamSet == null ? Collections.emptySet() : streamSet.parallelStream().filter(s -> !s.getStatus().hasError()).collect(Collectors.toSet());
    }

    public String getProcessorName() {
        return Messages.Name;
    }

    private SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public Set<Stream> getStreamSet() {
        return this.streamSet;
    }

    protected Map<ITypeRoot, CompilationUnit> getTypeRootToCompilationUnitMap() {
        return this.typeRootToCompilationUnitMap;
    }

    protected Map<IType, ITypeHierarchy> getTypeToTypeHierarchyMap() {
        return this.typeToTypeHierarchyMap;
    }

    public Set<Stream> getUnoptimizableStreams() {
        return this.getStreamSet().parallelStream().filter(s -> s.getStatus().hasError()).collect(Collectors.toSet());
    }

    public boolean getUseImplicitBenchmarkEntrypoints() {
        return this.useImplicitBenchmarkEntrypoints;
    }

    public boolean getUseImplicitEntrypoints() {
        return this.useImplicitEntrypoints;
    }

    public void setUseImplicitBenchmarkEntrypoints(boolean useImplicitBenchmarkEntrypoints) {
        this.useImplicitBenchmarkEntrypoints = useImplicitBenchmarkEntrypoints;
    }

    public void setUseImplicitEntrypoints(boolean useImplicitEntrypoints) {
        this.useImplicitEntrypoints = useImplicitEntrypoints;
    }

    public void setUseImplicitJavaFXEntrypoints(boolean useImplicitJavaFXEntrypoints) {
        this.useImplicitJavaFXEntrypoints = useImplicitJavaFXEntrypoints;
    }

    public void setUseImplicitTestEntrypoints(boolean useImplicitTestEntrypoints) {
        this.useImplicitTestEntrypoints = useImplicitTestEntrypoints;
    }

    public boolean getUseImplicitJavaFXEntrypoints() {
        return this.useImplicitJavaFXEntrypoints;
    }

    public boolean getUseImplicitTestEntrypoints() {
        return this.useImplicitTestEntrypoints;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    private void logInfo(String message) {
        OptimizeStreamsRefactoringProcessor.log(1, message);
    }

    private void manageCompilationUnit(TextEditBasedChangeManager manager, CompilationUnitRewrite rewrite, Optional<IProgressMonitor> monitor) throws CoreException {
        monitor.ifPresent(m -> m.beginTask("Creating change ...", -1));
        CompilationUnitChange change = rewrite.createChange(false, monitor.orElseGet(NullProgressMonitor::new));
        if (change != null) {
            change.setTextType("java");
        }
        manager.manage(rewrite.getCu(), (TextEditBasedChange)change);
    }

    public void setNForStreams(int nForStreams) {
        this.nForStreams = nForStreams;
    }

    protected void setNumberOfProcessedStreamInstances(int numberOfProcessedStreamInstances) {
        this.numberOfProcessedStreamInstances = numberOfProcessedStreamInstances;
    }

    protected void setNumberOfSkippedStreamInstances(int numberOfSkippedStreamInstances) {
        this.numberOfSkippedStreamInstances = numberOfSkippedStreamInstances;
    }

    protected void setStreamSet(Set<Stream> streamSet) {
        this.streamSet = streamSet;
    }
}

