/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.ObjectVisitor;
import com.ibm.wala.util.functions.Function;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Util {
    public static final BitSet EMPTY_BITSET = new BitSet();
    public static final boolean FULLY_QUALIFIED_NAMES = false;

    public static String str(Throwable thrown) throws IllegalArgumentException {
        if (thrown == null) {
            throw new IllegalArgumentException("thrown == null");
        }
        ByteArrayOutputStream traceDump = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var3_4 = null;
        try (PrintWriter w = new PrintWriter(traceDump);){
            thrown.printStackTrace(w);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return traceDump.toString();
    }

    public static <S, T> Set<T> filterByType(Iterable<S> c, Class<T> klass) {
        HashSet result = HashSetFactory.make();
        for (S s : c) {
            if (!klass.isAssignableFrom(s.getClass())) continue;
            result.add(s);
        }
        return result;
    }

    public static <T> boolean forSome(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T t : c) {
            if (!p.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> T find(Collection<T> c, Predicate<T> p) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        for (T obj : c) {
            if (!p.test(obj)) continue;
            return obj;
        }
        return null;
    }

    public static <T> boolean forAll(Collection<T> c, Predicate<T> p) throws NullPointerException {
        for (T t : c) {
            if (p.test(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> void doForAll(Collection<T> c, ObjectVisitor<T> v) throws IllegalArgumentException {
        if (c == null) {
            throw new IllegalArgumentException("c == null");
        }
        Iterator<T> iter = c.iterator();
        while (iter.hasNext()) {
            v.visit(iter.next());
        }
    }

    public static <T, U> List<U> map(List<T> srcList, Function<T, U> f) throws IllegalArgumentException {
        if (srcList == null) {
            throw new IllegalArgumentException("srcList == null");
        }
        ArrayList<U> result = new ArrayList<U>();
        Iterator<T> srcIter = srcList.iterator();
        while (srcIter.hasNext()) {
            result.add(f.apply(srcIter.next()));
        }
        return result;
    }

    public static <T, U> Set<U> mapToSet(Collection<T> srcSet, Function<T, U> f) throws IllegalArgumentException {
        if (srcSet == null) {
            throw new IllegalArgumentException("srcSet == null");
        }
        HashSet result = HashSetFactory.make();
        Iterator<T> srcIter = srcSet.iterator();
        while (srcIter.hasNext()) {
            result.add(f.apply(srcIter.next()));
        }
        return result;
    }

    public static int[] realloc(int[] data, int newSize) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        if (data.length < newSize) {
            int[] newData = new int[newSize];
            System.arraycopy(data, 0, newData, 0, data.length);
            return newData;
        }
        return data;
    }

    public static String objectFieldsToString(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException("obj == null");
        }
        SecurityManager oldsecurity = System.getSecurityManager();
        System.setSecurityManager(new SecurityManager(){

            @Override
            public void checkPermission(Permission perm) {
            }
        });
        Class<?> c = obj.getClass();
        StringBuffer buf = new StringBuffer(Util.removePackageName(c.getName()));
        while (c != Object.class) {
            Field[] fields = c.getDeclaredFields();
            if (fields.length > 0) {
                buf = buf.append(" (");
            }
            int i = 0;
            while (i < fields.length) {
                fields[i].setAccessible(true);
                try {
                    Class<?> type = fields[i].getType();
                    String name = fields[i].getName();
                    Object value = fields[i].get(obj);
                    buf = buf.append(name);
                    buf = buf.append("=");
                    buf = buf.append(value == null ? "null" : value.toString());
                    buf = buf.append(" : ");
                    buf = buf.append(Util.removePackageName(type.getName()));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                buf = buf.append(i + 1 >= fields.length ? ")" : ",");
                ++i;
            }
            c = c.getSuperclass();
        }
        System.setSecurityManager(oldsecurity);
        return buf.toString();
    }

    public static String removePackageName(String fully_qualified_name_) {
        if (fully_qualified_name_ == null) {
            return null;
        }
        int lastdot = fully_qualified_name_.lastIndexOf(46);
        if (lastdot < 0) {
            return "";
        }
        return fully_qualified_name_.substring(lastdot + 1);
    }

    public static <T> boolean intersecting(Set<T> s1, final Set<T> s2) {
        return Util.forSome(s1, new Predicate<T>(){

            @Override
            public boolean test(T obj) {
                return s2.contains(obj);
            }
        });
    }

    public static String topLevelTypeString(String typeStr) throws IllegalArgumentException {
        if (typeStr == null) {
            throw new IllegalArgumentException("typeStr == null");
        }
        int dollarIndex = typeStr.indexOf(36);
        String topLevelTypeStr = dollarIndex == -1 ? typeStr : typeStr.substring(0, dollarIndex);
        return topLevelTypeStr;
    }

    public static <T> void addIfNotNull(T val, Collection<T> vals) {
        if (val != null) {
            vals.add(val);
        }
    }

    public static long getUsedMemory() {
        Util.gc();
        long totalMemory = Runtime.getRuntime().totalMemory();
        Util.gc();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        return usedMemory;
    }

    private static void gc() {
        try {
            int i = 0;
            while (i < 2) {
                System.gc();
                Thread.sleep(100L);
                System.runFinalization();
                Thread.sleep(100L);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

