/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ide.ui;

import com.ibm.wala.dataflow.IFDS.TabulationResult;
import com.ibm.wala.ide.ui.SWTTreeViewer;
import com.ibm.wala.ide.ui.ViewIFDSLocalAction;
import com.ibm.wala.properties.WalaProperties;
import com.ibm.wala.util.WalaException;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.InferGraphRoots;
import com.ibm.wala.viz.DotUtil;
import com.ibm.wala.viz.NodeDecorator;
import java.io.File;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.jface.action.IAction;

public class IFDSExplorer {
    protected static String dotExe = null;
    protected static String viewerExe = null;
    private static final boolean PRINT_DOMAIN = true;

    public static void setDotExe(String newDotExe) {
        dotExe = newDotExe;
    }

    public static void setGvExe(String newGvExe) {
        viewerExe = newGvExe;
    }

    public static <T, P, F> void viewIFDS(TabulationResult<T, P, F> r, Collection<? extends P> roots) throws WalaException {
        IFDSExplorer.viewIFDS(r, roots, null);
    }

    public static <T, P, F> void viewIFDS(TabulationResult<T, P, F> r, Collection<? extends P> roots, NodeDecorator labels) throws WalaException {
        Properties p = null;
        try {
            p = WalaProperties.loadProperties();
        }
        catch (WalaException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
        }
        String scratch = p.getProperty("output_dir");
        IFDSExplorer.viewIFDS(r, roots, labels, scratch);
    }

    public static <T, P, F> void viewIFDS(TabulationResult<T, P, F> r, Collection<? extends P> roots, NodeDecorator labels, String scratchDirectory) throws WalaException {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        assert (dotExe != null);
        System.err.println("Domain:\n" + r.getProblem().getDomain().toString());
        String irFileName = null;
        switch (DotUtil.getOutputType()) {
            case PDF: {
                irFileName = "ir.pdf";
                break;
            }
            case PS: 
            case EPS: {
                irFileName = "ir.ps";
                break;
            }
            case SVG: {
                irFileName = "ir.svg";
            }
        }
        String outputFile = String.valueOf(scratchDirectory) + File.separatorChar + irFileName;
        String dotFile = String.valueOf(scratchDirectory) + File.separatorChar + "ir.dt";
        SWTTreeViewer v = new SWTTreeViewer();
        Graph g = r.getProblem().getSupergraph().getProcedureGraph();
        v.setGraphInput(g);
        v.setBlockInput(true);
        v.setRootsInput(roots);
        ViewIFDSLocalAction<T, P, F> action = labels == null ? new ViewIFDSLocalAction<T, P, F>(v, r, outputFile, dotFile, dotExe, viewerExe) : new ViewIFDSLocalAction<T, P, F>(v, r, outputFile, dotFile, dotExe, viewerExe, labels);
        v.getPopUpActions().add((IAction)action);
        v.run();
    }

    public static <T, P, F> void viewIFDS(TabulationResult<T, P, F> r) throws WalaException {
        if (r == null) {
            throw new IllegalArgumentException("null r");
        }
        Collection roots = InferGraphRoots.inferRoots((Graph)r.getProblem().getSupergraph().getProcedureGraph());
        IFDSExplorer.viewIFDS(r, roots);
    }

    public static String getDotExe() {
        return dotExe;
    }

    public static String getGvExe() {
        return viewerExe;
    }
}

