/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.strings.ImmutableByteArray;
import java.io.UTFDataFormatException;

public abstract class UTF8Convert {
    static final boolean STRICTLY_CHECK_FORMAT = false;
    static final boolean ALLOW_NORMAL_UTF8 = false;
    static final boolean ALLOW_PSEUDO_UTF8 = true;
    static final boolean WRITE_PSEUDO_UTF8 = true;

    public static String fromUTF8(byte[] utf8) throws UTFDataFormatException {
        if (utf8 == null) {
            throw new IllegalArgumentException("utf8 is null");
        }
        char[] result = new char[utf8.length];
        int result_index = 0;
        int i = 0;
        int n = utf8.length;
        while (i < n) {
            byte b;
            if ((b = utf8[i++]) >= 0) {
                result[result_index++] = (char)b;
                continue;
            }
            try {
                byte nb = utf8[i++];
                if (b < -32) {
                    int n2 = result_index++;
                    char c = (char)((b & 0x1F) << 6 | nb & 0x3F);
                    result[n2] = c;
                    char c2 = c;
                    continue;
                }
                byte nnb = utf8[i++];
                int n3 = result_index++;
                char c = (char)((b & 0xF) << 12 | (nb & 0x3F) << 6 | nnb & 0x3F);
                result[n3] = c;
                char c3 = c;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new UTFDataFormatException("unexpected end at location " + i);
            }
        }
        return new String(result, 0, result_index);
    }

    public static byte[] toUTF8(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        byte[] result = new byte[UTF8Convert.utfLength(s)];
        int result_index = 0;
        int i = 0;
        int n = s.length();
        while (i < n) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                result[result_index++] = (byte)c;
            } else if (c > '\u07ff') {
                result[result_index++] = (byte)(0xE0 | (byte)(c >> 12));
                result[result_index++] = (byte)(0x80 | (c & 0xFC0) >> 6);
                result[result_index++] = (byte)(0x80 | c & 0x3F);
            } else {
                result[result_index++] = (byte)(0xC0 | (byte)(c >> 6));
                result[result_index++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        return result;
    }

    public static int utfLength(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        int utflen = 0;
        int i = 0;
        int n = s.length();
        while (i < n) {
            char c = s.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    public static boolean check(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        int i = 0;
        int n = bytes.length;
        while (i < n) {
            char c;
            block12: {
                byte nb;
                byte b;
                block9: {
                    char c2;
                    block11: {
                        block10: {
                            if ((b = bytes[i++]) == 0) {
                                return false;
                            }
                            if (b >= 0) continue;
                            try {
                                nb = bytes[i++];
                                if (b >= -32) break block9;
                                c2 = (char)((b & 0x1F) << 6 | nb & 0x3F);
                                if ((b & 0xE0) == 192 && (nb & 0xC0) == 128) break block10;
                                return false;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                return false;
                            }
                        }
                        if (c2 >= '\u0080') break block11;
                        if (c2 == '\u0000') continue;
                        return false;
                    }
                    if (c2 <= '\u07ff') continue;
                    return false;
                }
                byte nnb = bytes[i++];
                c = (char)((b & 0xF) << 12 | (nb & 0x3F) << 6 | nnb & 0x3F);
                if ((b & 0xF0) == 224 && (nb & 0xC0) == 128 && (nnb & 0xC0) == 128) break block12;
                return false;
            }
            if (c >= '\u0800') continue;
            return false;
        }
        return true;
    }

    public static String fromUTF8(ImmutableByteArray s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        try {
            return UTF8Convert.fromUTF8(s.b);
        }
        catch (UTFDataFormatException e) {
            e.printStackTrace();
            Assertions.UNREACHABLE();
            return null;
        }
    }
}

