/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.util.MonitorUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

public class ProgressMaster
implements MonitorUtil.IProgressMonitor {
    private final MonitorUtil.IProgressMonitor delegate;
    private volatile boolean timedOut = false;
    private volatile boolean tooMuchMemory = false;
    private final int msPerWorkItem;
    private final boolean checkMemory;
    private Timeout currentNanny;

    private ProgressMaster(MonitorUtil.IProgressMonitor monitor, int msPerWorkItem, boolean checkMemory) {
        this.delegate = monitor;
        this.msPerWorkItem = msPerWorkItem;
        this.checkMemory = checkMemory;
    }

    public static ProgressMaster make(MonitorUtil.IProgressMonitor monitor, int msPerWorkItem, boolean checkMemory) {
        if (monitor == null) {
            throw new IllegalArgumentException("null monitor");
        }
        return new ProgressMaster(monitor, msPerWorkItem, checkMemory);
    }

    public synchronized void beginTask(String name, int totalWork) {
        this.delegate.beginTask(name, totalWork);
        this.startNanny();
    }

    private synchronized void startNanny() {
        this.killNanny();
        if (this.msPerWorkItem >= 1 || this.checkMemory) {
            this.currentNanny = new Timeout();
            this.currentNanny.setDaemon(true);
            this.currentNanny.start();
        }
    }

    public synchronized void reset() {
        this.killNanny();
        this.setCanceled(false);
        this.timedOut = false;
        this.tooMuchMemory = false;
    }

    public boolean lastItemTimedOut() {
        return this.timedOut;
    }

    public boolean lastItemTooMuchMemory() {
        return this.tooMuchMemory;
    }

    public synchronized void done() {
        this.killNanny();
        this.delegate.done();
    }

    private synchronized void killNanny() {
        if (this.currentNanny != null) {
            this.currentNanny.interrupt();
            try {
                this.currentNanny.join();
            }
            catch (InterruptedException interruptedException) {}
            this.currentNanny = null;
        }
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled() || this.timedOut || this.tooMuchMemory;
    }

    public void setCanceled(boolean value) {
        this.killNanny();
    }

    public void subTask(String subTask) {
        this.delegate.subTask(subTask);
    }

    public void cancel() {
        this.setCanceled(true);
    }

    public synchronized void worked(int work) {
        this.killNanny();
        this.delegate.worked(work);
        this.startNanny();
    }

    public int getMillisPerWorkItem() {
        return this.msPerWorkItem;
    }

    public String getCancelMessage() {
        return this.tooMuchMemory ? "too much memory" : (this.timedOut ? "timed out" : "unknown");
    }

    private class Timeout
    extends Thread {
        private static final double MAX_USED_MEM_BEFORE_BACKING_OUT = 0.7;

        private Timeout() {
        }

        @Override
        public void run() {
            try {
                MemoryMXBean gcbean = null;
                NotificationListener listener = null;
                if (ProgressMaster.this.checkMemory) {
                    for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
                        if (!pool.getType().equals((Object)MemoryType.HEAP)) continue;
                        pool.setCollectionUsageThreshold((long)((double)pool.getUsage().getMax() * 0.7));
                    }
                    final Timeout nannyThread = this;
                    gcbean = ManagementFactory.getMemoryMXBean();
                    listener = new NotificationListener(){

                        @Override
                        public void handleNotification(Notification notification, Object arg1) {
                            long max;
                            MemoryNotificationInfo info = MemoryNotificationInfo.from((CompositeData)notification.getUserData());
                            long used = info.getUsage().getUsed();
                            if ((double)used / (double)(max = Runtime.getRuntime().maxMemory()) > 0.7) {
                                System.err.println("used " + used + " of " + max);
                                ProgressMaster.this.tooMuchMemory = true;
                                nannyThread.interrupt();
                            }
                        }
                    };
                    try {
                        ManagementFactory.getPlatformMBeanServer().addNotificationListener(gcbean.getObjectName(), listener, null, null);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        throw new Error("cannot find existing bean");
                    }
                }
                Thread.sleep(ProgressMaster.this.msPerWorkItem);
                if (ProgressMaster.this.checkMemory) {
                    try {
                        ManagementFactory.getPlatformMBeanServer().removeNotificationListener(gcbean.getObjectName(), listener);
                    }
                    catch (InstanceNotFoundException | ListenerNotFoundException operationsException) {
                        throw new Error("cannot find existing bean");
                    }
                }
                if (this.isInterrupted()) {
                    return;
                }
                ProgressMaster.this.timedOut = true;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public static class TooMuchMemoryUsed
    extends Exception {
    }
}

